/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.io;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.io.File;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class FileCleanerService {
    private static final long DELAY_INTERVAL = 5000L;
    private static final int RETRY_COUNT = 10;
    private static final FileCleanerService INSTANCE = new FileCleanerService();
    private final ConcurrentLinkedQueue<FileToDelete> deleteQueue = new ConcurrentLinkedQueue();
    private volatile Thread cleanerThread = null;
    private final XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "FileCleanerService", LogLevel.INFO);

    private FileCleanerService() {
        this.startCleanerThread();
    }

    public static FileCleanerService getInstance() {
        return INSTANCE;
    }

    public void deleteLater(File fileToDelete) {
        this.deleteLater(fileToDelete, null);
    }

    public void deleteLater(File fileToDelete, IFileDeleteListener listener) {
        if (this.logger.isOn(LogLevel.TRACE)) {
            File[] buffer = new StringBuilder();
            buffer.append("Registering file for deletion: ").append(fileToDelete.getAbsolutePath());
            this.logger.log(LogLevel.TRACE, buffer.toString());
        }
        if (fileToDelete.isDirectory()) {
            for (File f : fileToDelete.listFiles()) {
                this.deleteLater(f, null);
            }
            return;
        }
        if (!fileToDelete.exists()) {
            if (null != listener) {
                listener.onDelete(fileToDelete);
            }
            return;
        }
        this.deleteQueue.add(new FileToDelete(fileToDelete, listener));
        Thread thread = this.cleanerThread;
        if (thread != null) {
            thread.interrupt();
        }
    }

    public void release() {
        Thread thread = this.cleanerThread;
        this.cleanerThread = null;
        if (thread != null) {
            thread.interrupt();
        }
    }

    private void startCleanerThread() {
        this.logger.log("Starting FileCleanerService");
        this.cleanerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                FileCleanerService.this.cleanerTask();
            }
        }, "FileCleanerThread");
        this.cleanerThread.setDaemon(true);
        this.cleanerThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                FileCleanerService.this.logger.log(LogLevel.ERROR, "CleanerThread caught unhandled exception: ", throwable);
            }
        });
        this.cleanerThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                FileCleanerService.getInstance().release();
            }
        });
        this.logger.log("Started FileCleanerService");
    }

    private void cleanerTask() {
        Thread thisThread = Thread.currentThread();
        while (this.cleanerThread == thisThread) {
            FileToDelete fileToDelete;
            this.logger.log(LogLevel.TRACE, "Polling queue");
            try {
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((fileToDelete = this.deleteQueue.poll()) == null) continue;
            if (fileToDelete.getAttemptCounter().get() > 0) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.deleteFile(fileToDelete)) continue;
            if (fileToDelete.getAttemptCounter().incrementAndGet() > 10) {
                if (!this.logger.isOn(LogLevel.WARN)) continue;
                StringBuilder buffer = new StringBuilder();
                buffer.append("Exceeded maximum attempts (").append(10).append(") to delete file: ").append(fileToDelete.getFile().getAbsolutePath());
                this.logger.log(LogLevel.WARN, buffer.toString());
                fileToDelete.getFile().deleteOnExit();
                continue;
            }
            this.deleteQueue.add(fileToDelete);
            thisThread.interrupt();
        }
    }

    private boolean deleteFile(FileToDelete file) {
        boolean success = false;
        if (!file.getFile().exists()) {
            if (this.logger.isOn(LogLevel.INFO)) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Non-existent file: ").append(file.getFile().getAbsolutePath());
                this.logger.log(LogLevel.INFO, buffer.toString());
            }
            success = true;
            file.fireOnDelete();
        } else if (file.getFile().delete()) {
            if (this.logger.isOn(LogLevel.INFO)) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Deleted file: ").append(file.getFile().getAbsolutePath());
                this.logger.log(LogLevel.INFO, buffer.toString());
            }
            success = true;
            file.fireOnDelete();
        } else {
            if (this.logger.isOn(LogLevel.WARN)) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Failed attempt ").append(file.getAttemptCounter().get()).append(" to delete file: ").append(file.getFile().getAbsolutePath());
                this.logger.log(LogLevel.WARN, buffer.toString());
            }
            success = false;
            file.fireOnDeleteFailed();
        }
        return success;
    }

    private final class FileToDelete {
        private final File file;
        private final IFileDeleteListener listener;
        private final AtomicInteger attemptCounter = new AtomicInteger();

        FileToDelete(File theFile, IFileDeleteListener theListener) {
            this.file = theFile;
            this.listener = theListener;
        }

        public File getFile() {
            return this.file;
        }

        public void fireOnDelete() {
            block3: {
                if (null != this.listener) {
                    try {
                        this.listener.onDelete(this.file);
                    }
                    catch (Throwable ex) {
                        if (!FileCleanerService.this.logger.isOn(LogLevel.ERROR)) break block3;
                        FileCleanerService.this.logger.log(LogLevel.ERROR, "Exception caught from onDelete event of IFileDeleteListener: ", ex);
                    }
                }
            }
        }

        public void fireOnDeleteFailed() {
            block3: {
                if (null != this.listener) {
                    try {
                        this.listener.onDeleteFailed(this.file, this.attemptCounter.get());
                    }
                    catch (Throwable ex) {
                        if (!FileCleanerService.this.logger.isOn(LogLevel.ERROR)) break block3;
                        FileCleanerService.this.logger.log(LogLevel.ERROR, "Exception caught from onDeleteFailed event of IFileDeleteListener: ", ex);
                    }
                }
            }
        }

        public AtomicInteger getAttemptCounter() {
            return this.attemptCounter;
        }
    }

    public static interface IFileDeleteListener {
        public void onDelete(File var1);

        public void onDeleteFailed(File var1, int var2);
    }
}

