/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public class ForwardingInputStream
extends InputStream {
    private final InputStream sourceStream;
    private final OutputStream destStream;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public ForwardingInputStream(InputStream theSourceStream, OutputStream theDestStream) {
        if (null == theSourceStream) {
            throw new NullPointerException("theSourceStream");
        }
        if (null == theDestStream) {
            throw new NullPointerException("theDestStream");
        }
        this.sourceStream = theSourceStream;
        this.destStream = theDestStream;
    }

    public InputStream getSourceStream() {
        return this.sourceStream;
    }

    public OutputStream getDestinationStream() {
        return this.destStream;
    }

    @Override
    public int available() throws IOException {
        return this.sourceStream.available();
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.sourceStream.close();
            }
            finally {
                this.destStream.close();
            }
        }
    }

    @Override
    public void mark(int readlimit) {
        this.sourceStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.sourceStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        int result = this.sourceStream.read();
        if (result != -1) {
            this.destStream.write(result);
        }
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = this.sourceStream.read(b);
        if (result != -1) {
            this.destStream.write(b, 0, result);
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.sourceStream.read(b, off, len);
        if (result != -1) {
            this.destStream.write(b, off, result);
        }
        return result;
    }

    @Override
    public void reset() throws IOException {
        this.sourceStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.sourceStream.skip(n);
    }
}

