/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.memory;

public enum MemoryStateEnum {
    NORMAL(1, "normal", 480000L),
    HIGH(70, "high", 240000L),
    VERYHIGH(80, "very high", 120000L),
    CRITICAL(90, "critical", 60000L);

    int percentThreshold;
    String description;
    long timeThreshold;
    long statistics = 0L;
    public static final int DEFAULT_CRITICAL_PERCENTAGE = 90;
    public static final int MIN_CRITICAL_PERCENTAGE = 75;
    public static final int MAX_CRITICAL_PERCENTAGE = 100;

    private MemoryStateEnum(int thePercentThreshold, String theDescription, long theTimeThreashold) {
        this.percentThreshold = thePercentThreshold;
        this.description = theDescription;
        this.timeThreshold = theTimeThreashold;
    }

    public String toString() {
        return this.description;
    }

    static MemoryStateEnum fromMemoryLevel(long level) {
        if (level >= (long)MemoryStateEnum.CRITICAL.percentThreshold) {
            return CRITICAL;
        }
        if (level >= (long)MemoryStateEnum.VERYHIGH.percentThreshold) {
            return VERYHIGH;
        }
        if (level >= (long)MemoryStateEnum.HIGH.percentThreshold) {
            return HIGH;
        }
        return NORMAL;
    }

    long getTimeThreshold() {
        return this.timeThreshold;
    }

    int getPercentThreshold() {
        return this.percentThreshold;
    }

    void setPercentThreshold(int thePercentThreshold) {
        this.percentThreshold = thePercentThreshold;
    }

    void setTimeThreshold(long theTimeThreshold) {
        this.timeThreshold = theTimeThreshold;
    }

    void updateStatistics(long milliseconds) {
        this.statistics += milliseconds;
    }

    static void resetStatistics() {
        for (MemoryStateEnum memoryState : MemoryStateEnum.values()) {
            memoryState.statistics = 0L;
        }
    }

    public long getTotalTime() {
        return this.statistics;
    }

    public static void adjustRange(int criticalThreshold) {
        if (criticalThreshold > 100 || criticalThreshold < 75) {
            return;
        }
        CRITICAL.setPercentThreshold(criticalThreshold);
        VERYHIGH.setPercentThreshold(HIGH.getPercentThreshold() + (CRITICAL.getPercentThreshold() - HIGH.getPercentThreshold()) / 2);
    }
}

