/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.pool;

import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.SoftReferenceObjectPool;

public final class XQEXMLOutputFactoryPool {
    private static final String STATUS_MSG_FRAGMENT = ", # of idle: ";
    private static final String NEW_LINE = "\n";
    private static XQEXMLOutputFactoryPool instance = new XQEXMLOutputFactoryPool();
    private ObjectPool xmlOutputFactoryPool = new SoftReferenceObjectPool((PoolableObjectFactory)new XMLOutputFactoryPoolableFactory());

    private XQEXMLOutputFactoryPool() {
    }

    public static XQEXMLOutputFactoryPool getInstance() {
        return instance;
    }

    public XMLOutputFactory borrowXMLOutputFactory() throws Exception {
        return (XMLOutputFactory)this.xmlOutputFactoryPool.borrowObject();
    }

    public void returnXMLOutputFactory(XMLOutputFactory aFactory) throws Exception {
        this.xmlOutputFactoryPool.returnObject((Object)aFactory);
    }

    public void clear() throws Exception {
        this.xmlOutputFactoryPool.clear();
    }

    public void showStatus(Writer aWriter) throws IOException {
        aWriter.write(NEW_LINE);
        aWriter.write("XMLOutputFactory pool ->\t# in use: ");
        aWriter.write(String.valueOf(this.xmlOutputFactoryPool.getNumActive()));
        aWriter.write(STATUS_MSG_FRAGMENT);
        aWriter.write(String.valueOf(this.xmlOutputFactoryPool.getNumIdle()));
        aWriter.write(NEW_LINE);
        aWriter.flush();
    }

    private static class XMLOutputFactoryPoolableFactory
    implements PoolableObjectFactory {
        private XMLOutputFactoryPoolableFactory() {
        }

        public void activateObject(Object arg0) throws Exception {
        }

        public void destroyObject(Object arg0) throws Exception {
        }

        public Object makeObject() throws Exception {
            return StaxUtil.createXMLOutputFactory();
        }

        public void passivateObject(Object arg0) throws Exception {
            XMLOutputFactory theFactory = (XMLOutputFactory)arg0;
            StaxUtil.configureOutputFactory(theFactory, false);
        }

        public boolean validateObject(Object arg0) {
            return true;
        }
    }
}

