/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.primitive;

import com.cognos.xqe.util.JavaObjectMemorySize;
import com.cognos.xqe.util.primitive.ByteArrayList;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.RandomAccess;

public class CompactBigIntegerList
extends AbstractList<BigInteger>
implements RandomAccess {
    private static final byte ALL_BITS_ON = -1;
    private static final int DEFAULT_MAX_INDIVIDUAL_ARRAY_LENGTH = 0xA00000;
    private static final int DEFAULT_INITIAL_ITEMS_IN_ARRAY = 1000;
    private static final int NUM_INT_FIELDS = 3;
    private final int bytesPerInteger;
    private final BigInteger maxBigInteger;
    private final int initialArraySize;
    private final int entriesPerArray;
    private final byte[] transferByteArray;
    private final byte[] transferByteArray2;
    private ArrayList<ByteArrayList> byteArrays = new ArrayList();

    public CompactBigIntegerList(BigInteger theMaxBigInteger) {
        this(theMaxBigInteger, 1000, 0xA00000);
    }

    public CompactBigIntegerList(BigInteger theMaxBigInteger, int initialSize) {
        this(theMaxBigInteger, initialSize, 0xA00000);
    }

    public CompactBigIntegerList(BigInteger theMaxBigInteger, int initialSize, int maxArrayLength) {
        byte[] maxByteArrayFormat = theMaxBigInteger.toByteArray();
        this.maxBigInteger = theMaxBigInteger;
        this.bytesPerInteger = maxByteArrayFormat.length;
        this.transferByteArray = new byte[this.bytesPerInteger];
        this.transferByteArray2 = new byte[this.bytesPerInteger];
        this.entriesPerArray = Math.max(maxArrayLength / this.bytesPerInteger, 1);
        int numInitialEntriesInArray = Math.min(this.entriesPerArray, initialSize);
        this.initialArraySize = Math.max(numInitialEntriesInArray, 1) * this.bytesPerInteger;
    }

    @Override
    public BigInteger get(int index) {
        int arrayIndex = index / this.entriesPerArray;
        int byteOffsetInLastArray = (index - arrayIndex * this.entriesPerArray) * this.bytesPerInteger;
        ByteArrayList byteArray = this.byteArrays.get(arrayIndex);
        byte[] bytes = new byte[this.bytesPerInteger];
        byteArray.get(byteOffsetInLastArray, this.bytesPerInteger, bytes);
        return new BigInteger(bytes);
    }

    @Override
    public int size() {
        int numEntries = 0;
        if (this.byteArrays.size() > 0) {
            numEntries = (this.byteArrays.size() - 1) * this.entriesPerArray;
            ByteArrayList lastArray = this.getLastArray();
            numEntries += lastArray.size() / this.bytesPerInteger;
        }
        return numEntries;
    }

    @Override
    public boolean add(BigInteger e) {
        int index = this.size();
        int arrayIndex = index / this.entriesPerArray;
        if (arrayIndex >= this.byteArrays.size()) {
            this.byteArrays.add(new ByteArrayList(this.initialArraySize));
        }
        ByteArrayList lastArray = this.getLastArray();
        this.populateTransferArray(e);
        lastArray.add(this.transferByteArray);
        return true;
    }

    @Override
    public boolean add(Number e) {
        BigInteger bigInteger = e instanceof BigInteger ? (BigInteger)e : BigInteger.valueOf(e.longValue());
        return this.add(bigInteger);
    }

    @Override
    public void add(int index, BigInteger element) {
        throw new UnsupportedOperationException("Only add() is supported.");
    }

    @Override
    public BigInteger set(int index, BigInteger value) {
        int arrayIndex = index / this.entriesPerArray;
        int byteOffsetInLastArray = (index - arrayIndex * this.entriesPerArray) * this.bytesPerInteger;
        ByteArrayList byteArray = this.byteArrays.get(arrayIndex);
        this.populateTransferArray(value);
        byte[] previousValueBytes = byteArray.set(byteOffsetInLastArray, this.transferByteArray, this.transferByteArray2);
        return new BigInteger(previousValueBytes);
    }

    private void populateTransferArray(BigInteger value) {
        if (value.signum() >= 0) {
            Arrays.fill(this.transferByteArray, (byte)0);
        } else {
            Arrays.fill(this.transferByteArray, (byte)-1);
        }
        byte[] data = value.toByteArray();
        if (data.length > this.transferByteArray.length) {
            throw new IllegalArgumentException("Value passed in " + value + " is larger than max value passed on constructor.");
        }
        System.arraycopy(data, 0, this.transferByteArray, this.transferByteArray.length - data.length, data.length);
    }

    public void trim() {
        for (ByteArrayList list : this.byteArrays) {
            list.trim();
        }
        this.byteArrays.trimToSize();
    }

    public long estimateMemoryUsage() {
        return CompactBigIntegerList.estimateMemoryUsage(this.bytesPerInteger, this.size(), this.bytesPerInteger * this.entriesPerArray);
    }

    public BigInteger getMaxBigInteger() {
        return this.maxBigInteger;
    }

    public static long estimateMemoryUsage(BigInteger maxBigInteger, int numBigIntegersStored) {
        int bytesPerBigInteger = maxBigInteger.toByteArray().length;
        return CompactBigIntegerList.estimateMemoryUsage(bytesPerBigInteger, numBigIntegersStored, 0xA00000);
    }

    private static long estimateMemoryUsage(int bytesPerBigInteger, int numBigIntegersStored, int maxArraySize) {
        long estimatedSize = JavaObjectMemorySize.getJavaObjectSize(12L, 2L);
        estimatedSize += JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(1, bytesPerBigInteger);
        estimatedSize += (long)(bytesPerBigInteger * numBigIntegersStored);
        int numArrays = bytesPerBigInteger * numBigIntegersStored / maxArraySize + 1;
        return estimatedSize += JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(1, 0L) * (long)numArrays;
    }

    private ByteArrayList getLastArray() {
        ByteArrayList lastArray = null;
        if (this.byteArrays.size() > 0) {
            lastArray = this.byteArrays.get(this.byteArrays.size() - 1);
        }
        return lastArray;
    }
}

