/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.primitive;

import com.cognos.xqe.util.JavaObjectMemorySize;
import com.cognos.xqe.util.primitive.ICollectionInt;
import com.cognos.xqe.util.primitive.IteratorInt;
import gnu.trove.TIntCollection;
import gnu.trove.set.hash.TIntHashSet;

public class HashSetInt
implements ICollectionInt {
    private static final int TINT_HASH_SET_DEFAULT_CAPACITY = 23;
    private static final double TINT_HASH_SET_CAPACITY_MULTIPLIER = 2.25;
    private TIntHashSet intHashSet = new TIntHashSet();

    @Override
    public boolean add(int value) {
        return this.intHashSet.add(value);
    }

    @Override
    public boolean contains(int value) {
        return this.intHashSet.contains(value);
    }

    @Override
    public boolean isEmpty() {
        return this.intHashSet.isEmpty();
    }

    @Override
    public int size() {
        return this.intHashSet.size();
    }

    @Override
    public void clear() {
        this.intHashSet.clear();
    }

    @Override
    public boolean remove(int entry) {
        return this.intHashSet.remove(entry);
    }

    @Override
    public IteratorInt iterator() {
        return new IteratorInt(this.intHashSet.iterator());
    }

    public boolean removeAll(HashSetInt set) {
        return this.intHashSet.removeAll((TIntCollection)set.intHashSet);
    }

    public int getMax() {
        int max = Integer.MIN_VALUE;
        IteratorInt iter = this.iterator();
        while (iter.hasNext()) {
            int i = iter.next();
            if (max >= i) continue;
            max = i;
        }
        return max;
    }

    public boolean containsAny(HashSetInt set) {
        if (this.size() < set.size()) {
            IteratorInt iter = this.iterator();
            while (iter.hasNext()) {
                int intThis = iter.next();
                if (!set.contains(intThis)) continue;
                return true;
            }
        } else {
            IteratorInt iter = set.iterator();
            while (iter.hasNext()) {
                int intOther = iter.next();
                if (!this.contains(intOther)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int[] toArray(int[] array) {
        return this.intHashSet.toArray(array);
    }

    public long estimateMemoryUsage() {
        return HashSetInt.estimateMemoryUsage(this.size());
    }

    public static long estimateMemoryUsage(int hashSetIntSize) {
        long estimatedSize = JavaObjectMemorySize.getEstimatedJavaObjectShallowSize(HashSetInt.class);
        return estimatedSize += HashSetInt.estimateMemoryUsageOfIntHashSet(hashSetIntSize);
    }

    private static long estimateMemoryUsageOfIntHashSet(int hashSetIntSize) {
        long estimatedSize = JavaObjectMemorySize.getEstimatedJavaObjectShallowSize(TIntHashSet.class);
        long tIntHashSetCapacity = 23L;
        while (tIntHashSetCapacity < (long)hashSetIntSize) {
            tIntHashSetCapacity = (long)Math.ceil((double)tIntHashSetCapacity * 2.25);
        }
        long tIntHashSetFieldSetSize = JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(4, tIntHashSetCapacity);
        estimatedSize += tIntHashSetFieldSetSize;
        long tIntHashSetFieldStatesSize = JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(1, tIntHashSetCapacity);
        return estimatedSize += tIntHashSetFieldStatesSize;
    }
}

