/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.primitive.sort;

import com.cognos.xqe.util.primitive.sort.ArraySortUtility;
import com.cognos.xqe.util.primitive.sort.ListDoubleArrayInsertionSort;
import com.cognos.xqe.util.primitive.sort.ListDoubleArraySort;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class ListDoubleArrayQuickSort<T>
extends ListDoubleArraySort<T> {
    protected static final int SMALL_ARRAY_SIZE_DEFAULT = 16;
    private int smallArraySize = 16;
    private boolean isInsertionSortRequired = false;
    private Random random = new Random(0L);

    protected ListDoubleArrayQuickSort(List<T> theList, Comparator<T> comparator, double[] theDoubleArray, int theSmallArraySize) {
        super(theList, comparator, theDoubleArray);
        this.smallArraySize = theSmallArraySize;
    }

    protected boolean isInsertionSortRequired() {
        return this.isInsertionSortRequired;
    }

    protected void sort(int leftIndex, int rightIndex) {
        if (rightIndex <= leftIndex) {
            return;
        }
        if (rightIndex - leftIndex + 1 <= this.smallArraySize) {
            this.isInsertionSortRequired = true;
            return;
        }
        int partitionIndex = leftIndex + this.random.nextInt(rightIndex - leftIndex + 1);
        Object partitionValue = this.list.get(partitionIndex);
        this.swap(partitionIndex, rightIndex);
        int currentLeftIndex = leftIndex - 1;
        int currentRightIndex = rightIndex;
        int equalLeftIndex = leftIndex - 1;
        int equalRightIndex = rightIndex;
        int lastEqualRightIndex = rightIndex - 1;
        while (true) {
            if (this.listComparator.compare(this.list.get(++currentLeftIndex), partitionValue) < 0) {
                continue;
            }
            while (this.listComparator.compare(this.list.get(--currentRightIndex), partitionValue) > 0 && currentRightIndex != leftIndex) {
            }
            if (currentLeftIndex >= currentRightIndex) break;
            this.swap(currentLeftIndex, currentRightIndex);
            if (this.listComparator.compare(this.list.get(currentLeftIndex), partitionValue) == 0) {
                this.swap(++equalLeftIndex, currentLeftIndex);
            }
            if (this.listComparator.compare(this.list.get(currentRightIndex), partitionValue) != 0) continue;
            this.swap(currentRightIndex, --equalRightIndex);
        }
        if (this.listComparator.compare(this.list.get(currentLeftIndex), partitionValue) == 0) {
            if (currentLeftIndex != rightIndex) {
                lastEqualRightIndex = rightIndex;
                if (currentLeftIndex == equalRightIndex) {
                    ++equalRightIndex;
                }
            }
        } else {
            this.swap(currentLeftIndex, rightIndex);
        }
        currentRightIndex = currentLeftIndex - 1;
        int currentEqualIndex = leftIndex;
        while (currentEqualIndex <= equalLeftIndex) {
            this.swap(currentEqualIndex, currentRightIndex);
            ++currentEqualIndex;
            --currentRightIndex;
        }
        ++currentLeftIndex;
        currentEqualIndex = lastEqualRightIndex;
        while (currentEqualIndex >= equalRightIndex) {
            this.swap(currentLeftIndex, currentEqualIndex);
            --currentEqualIndex;
            ++currentLeftIndex;
        }
        this.sort(leftIndex, currentRightIndex);
        this.sort(currentLeftIndex, rightIndex);
    }

    public static void sort(List<int[]> theList, Comparator<int[]> comparator, double[] doubleArray) {
        ListDoubleArrayQuickSort.sort(theList, comparator, doubleArray, 16);
    }

    public static void sort(List<int[]> theList, Comparator<int[]> comparator, double[] doubleArray, int smallArraySize) {
        ArraySortUtility.throwExceptionIfInvalid(theList, doubleArray);
        if (!ArraySortUtility.isSortRequired(theList)) {
            return;
        }
        ListDoubleArrayQuickSort<int[]> quickSort = new ListDoubleArrayQuickSort<int[]>(theList, comparator, doubleArray, smallArraySize);
        quickSort.sort(0, theList.size() - 1);
        if (quickSort.isInsertionSortRequired()) {
            ListDoubleArrayInsertionSort.sort(theList, comparator, doubleArray);
        }
    }
}

