/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.primitive.sort;

import com.cognos.xqe.util.primitive.sort.ArraySortUtility;
import com.cognos.xqe.util.primitive.sort.LongDoubleArrayInsertionSort;
import com.cognos.xqe.util.primitive.sort.LongDoubleArraySort;
import java.util.Random;

public class LongDoubleArrayQuickSort
extends LongDoubleArraySort {
    protected static final int SMALL_ARRAY_SIZE_DEFAULT = 16;
    private int smallArraySize = 16;
    private boolean isInsertionSortRequired = false;
    private Random random = new Random(0L);

    protected LongDoubleArrayQuickSort(long[] theLongArray, double[] theDoubleArray, int theSmallArraySize) {
        super(theLongArray, theDoubleArray);
        this.smallArraySize = theSmallArraySize;
    }

    protected boolean isInsertionSortRequired() {
        return this.isInsertionSortRequired;
    }

    protected void sort(int leftIndex, int rightIndex) {
        if (rightIndex <= leftIndex) {
            return;
        }
        if (rightIndex - leftIndex + 1 <= this.smallArraySize) {
            this.isInsertionSortRequired = true;
            return;
        }
        int partitionIndex = leftIndex + this.random.nextInt(rightIndex - leftIndex + 1);
        long partitionValue = this.longArray[partitionIndex];
        this.swap(partitionIndex, rightIndex);
        int currentLeftIndex = leftIndex - 1;
        int currentRightIndex = rightIndex;
        int equalLeftIndex = leftIndex - 1;
        int equalRightIndex = rightIndex;
        int lastEqualRightIndex = rightIndex - 1;
        while (true) {
            if (this.longArray[++currentLeftIndex] < partitionValue) {
                continue;
            }
            while (this.longArray[--currentRightIndex] > partitionValue && currentRightIndex != leftIndex) {
            }
            if (currentLeftIndex >= currentRightIndex) break;
            this.swap(currentLeftIndex, currentRightIndex);
            if (this.longArray[currentLeftIndex] == partitionValue) {
                this.swap(++equalLeftIndex, currentLeftIndex);
            }
            if (this.longArray[currentRightIndex] != partitionValue) continue;
            this.swap(currentRightIndex, --equalRightIndex);
        }
        if (this.longArray[currentLeftIndex] == partitionValue) {
            if (currentLeftIndex != rightIndex) {
                lastEqualRightIndex = rightIndex;
                if (currentLeftIndex == equalRightIndex) {
                    ++equalRightIndex;
                }
            }
        } else {
            this.swap(currentLeftIndex, rightIndex);
        }
        currentRightIndex = currentLeftIndex - 1;
        int currentEqualIndex = leftIndex;
        while (currentEqualIndex <= equalLeftIndex) {
            this.swap(currentEqualIndex, currentRightIndex);
            ++currentEqualIndex;
            --currentRightIndex;
        }
        ++currentLeftIndex;
        currentEqualIndex = lastEqualRightIndex;
        while (currentEqualIndex >= equalRightIndex) {
            this.swap(currentLeftIndex, currentEqualIndex);
            --currentEqualIndex;
            ++currentLeftIndex;
        }
        this.sort(leftIndex, currentRightIndex);
        this.sort(currentLeftIndex, rightIndex);
    }

    public static void sort(long[] longArray, double[] doubleArray) {
        LongDoubleArrayQuickSort.sort(longArray, doubleArray, 16);
    }

    public static void sort(long[] longArray, double[] doubleArray, int smallArraySize) {
        ArraySortUtility.throwExceptionIfInvalid(longArray, doubleArray);
        if (!ArraySortUtility.isSortRequired(longArray)) {
            return;
        }
        LongDoubleArrayQuickSort quickSort = new LongDoubleArrayQuickSort(longArray, doubleArray, smallArraySize);
        quickSort.sort(0, longArray.length - 1);
        if (quickSort.isInsertionSortRequired()) {
            LongDoubleArrayInsertionSort.sort(longArray, doubleArray);
        }
    }
}

