/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.reference;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.reference.IReferenceCounted;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ReferenceCountedBase
implements IReferenceCounted {
    private final AtomicInteger mRefCount = new AtomicInteger(0);

    protected ReferenceCountedBase() {
    }

    protected ReferenceCountedBase(int initialRefCount) {
        this.setRefCount(initialRefCount);
    }

    @Override
    public final int getRefCount() {
        return this.mRefCount.get();
    }

    @Override
    public final int decrementRefCount() {
        int count = this.mRefCount.decrementAndGet();
        if (count < 0) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Reference count became negative.");
        }
        this.onDecrementRefCount(count);
        return count;
    }

    @Override
    public final int incrementRefCount() {
        int count = this.mRefCount.incrementAndGet();
        this.onIncrementRefCount(count);
        return count;
    }

    protected final void setRefCount(int theRefCount) {
        this.mRefCount.set(theRefCount);
    }

    protected abstract void onIncrementRefCount(int var1);

    protected abstract void onDecrementRefCount(int var1);
}

