/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.reference;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.reference.IResourceHolder;
import com.cognos.xqe.util.reference.ReferenceCountedBase;
import java.util.concurrent.atomic.AtomicReference;

public final class ReferenceCountedResourceHolder<T extends IReleasable>
extends ReferenceCountedBase
implements IResourceHolder<T> {
    private final AtomicReference<T> mReferent = new AtomicReference<Object>(null);
    private static final XQELogger ERROR_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public ReferenceCountedResourceHolder(T referent) {
        super(1);
        this.mReferent.set(referent);
    }

    public ReferenceCountedResourceHolder(T referent, int initialRefCount) {
        super(initialRefCount);
        this.mReferent.set(referent);
    }

    @Override
    public T reset(T value) {
        return (T)((IReleasable)this.mReferent.getAndSet(value));
    }

    @Override
    public T acquire() {
        return (T)((IReleasable)this.mReferent.get());
    }

    @Override
    public void release() {
        this.decrementRefCount();
    }

    @Override
    public boolean isSessionScope() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.getRefCount() > 0 && null != this.mReferent.get();
    }

    @Override
    protected void onDecrementRefCount(int newRefCount) {
        if (0 == newRefCount) {
            try {
                IReleasable resource = this.mReferent.getAndSet(null);
                if (null != resource) {
                    resource.release();
                }
            }
            catch (Throwable ex) {
                ERROR_LOGGER.log(ex);
            }
        }
    }

    @Override
    protected void onIncrementRefCount(int newRefCount) {
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ReferenceCountedResourceHolder[ref=").append(this.mReferent.get()).append(", count=").append(this.getRefCount()).append("]");
        return buffer.toString();
    }
}

