/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.resource;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.resource.ResourceReleaseService;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AutoReleaseResource
extends WeakReference<Object>
implements IReleasable {
    private final AtomicBoolean bReleased = new AtomicBoolean(false);
    private boolean bSafetyNet;
    private static final XQELogger ERROR_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Resources", LogLevel.ERROR);

    public AutoReleaseResource(Object parent) {
        this(parent, true);
    }

    public AutoReleaseResource(Object parent, boolean safetyNet) {
        super(parent, ResourceReleaseService.getReferenceQueue());
        this.bSafetyNet = safetyNet;
        Class<?> clazz = this.getClass();
        if (clazz.isLocalClass() || clazz.isSynthetic() || clazz.isAnonymousClass()) {
            throw new IllegalArgumentException("The auto-release functionality cannot be used with a local, synthetic or anonymous class, because it may prevent the parent from being garbage-collected.");
        }
        if (clazz.isMemberClass() && (clazz.getModifiers() & 8) != 8) {
            throw new IllegalArgumentException("The auto-release functionality cannot be used with a non-static, inner class, because it may prevent the parent from being garbage-collected.");
        }
        ResourceReleaseService.pinResource(this);
    }

    public boolean isSafetyNet() {
        return this.bSafetyNet;
    }

    @Override
    public final void release() {
        if (this.bReleased.compareAndSet(false, true)) {
            this.clear();
            ResourceReleaseService.unPinResource(this);
            try {
                this.releaseImpl();
            }
            catch (Throwable e) {
                ERROR_LOGGER.log("Error releasing resource: ", e);
            }
        }
    }

    protected abstract void releaseImpl() throws Exception;
}

