/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.resource;

import com.cognos.xqe.cache.ICaching;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import java.util.HashSet;
import java.util.Set;

public final class ReleaseSupport {
    private static final String LOGMSG_RELEASING_RESOURCE = "Releasing resource ";
    private static final String LOGMSG_NOT_RELEASING_RESOURCE = "Not releasing caching resource ";
    private static final String LOGMSG_ERROR_RELEASING = "An error occurred during resource release: ";
    private final ServiceEnumeration logService;
    private final String logComponent;
    private final String logGroup;
    private final Set<IReleasable> subscribers = new HashSet<IReleasable>();
    private XQELogger logger = null;

    public ReleaseSupport() {
        this(null, null, null);
    }

    public ReleaseSupport(String theLogComponent) {
        this(null, theLogComponent, null);
    }

    public ReleaseSupport(String theLogComponent, String theLogGroup) {
        this(null, theLogComponent, theLogGroup);
    }

    public ReleaseSupport(ServiceEnumeration theLogService, String theLogComponent, String theLogGroup) {
        this.logService = null == theLogService ? ServiceEnumeration.XQE : theLogService;
        this.logComponent = null == theLogComponent ? "XQE" : theLogComponent;
        this.logGroup = null == theLogGroup ? "InitTerm" : theLogGroup;
    }

    public synchronized void register(IReleasable object) {
        this.subscribers.add(object);
    }

    public synchronized void unregister(IReleasable object) {
        this.subscribers.remove(object);
    }

    public synchronized void releaseAll(boolean excludeCaching) {
        XQELogger traceLogger = this.getLogger();
        for (IReleasable object : this.subscribers) {
            try {
                boolean attemptRelease = true;
                if (excludeCaching && object instanceof ICaching) {
                    ICaching iCaching = (ICaching)((Object)object);
                    boolean bl = attemptRelease = !iCaching.isCaching();
                }
                if (attemptRelease) {
                    if (traceLogger.isOn()) {
                        traceLogger.log(LOGMSG_RELEASING_RESOURCE + object);
                    }
                    object.release();
                    continue;
                }
                if (!traceLogger.isOn()) continue;
                traceLogger.log(LOGMSG_NOT_RELEASING_RESOURCE + object);
            }
            catch (Exception ex) {
                if (!traceLogger.isOn(LogLevel.ERROR)) continue;
                this.getLogger().log(LogLevel.ERROR, LOGMSG_ERROR_RELEASING, (Throwable)ex);
            }
        }
        this.subscribers.clear();
    }

    private XQELogger getLogger() {
        if (null == this.logger) {
            this.logger = XQELog.getLogger(this.logService, this.logComponent, this.logGroup, LogLevel.INFO);
        }
        return this.logger;
    }
}

