/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.symboltable;

import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.util.symboltable.ISymbolTable;
import com.cognos.xqe.util.symboltable.SymbolTableStack;
import com.cognos.xqe.util.symboltable.SymbolTableUtil;
import com.cognos.xqemoser.MoserQuerySubject;
import java.util.List;

public class SymbolTableForQS
implements ISymbolTable {
    private final IQuerySubject querySubject;
    private final IMetadata contextMetadata;
    private final boolean bOnlyInQS;
    private MoserQuerySubject.SearchScope[] scope = null;

    public SymbolTableForQS(IQuerySubject qs, IMetadata c, boolean b) {
        this.querySubject = qs;
        this.contextMetadata = c;
        this.bOnlyInQS = b;
    }

    public void setScope(MoserQuerySubject.SearchScope[] s) {
        this.scope = s;
    }

    @Override
    public IMetadata get(String ref, SymbolTableStack stack) {
        if (SymbolTableStack.bindInMoserQuerySubject(this.querySubject)) {
            MoserQuerySubject.SearchScope[] s = this.scope;
            if (s == null) {
                s = this.bOnlyInQS ? MoserQuerySubject.ONLY_IN_QUERYSUBJECT : MoserQuerySubject.QUERYSUBJECT_AND_SOURCE_QUERYSUBJECT;
            }
            return ((MoserQuerySubject)this.querySubject).getReferencedMetadata(ref, this.contextMetadata, s);
        }
        String singleName = SymbolTableUtil.getSingleName(ref);
        if (singleName == null) {
            return null;
        }
        List<IMetadata> queryItems = this.querySubject.getQueryItemsAndMeasures();
        for (IMetadata qi : queryItems) {
            if (!qi.getName().equals(singleName)) continue;
            return qi;
        }
        return null;
    }

    @Override
    public IQuerySubject getQuerySubject() {
        return this.querySubject;
    }
}

