/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.symboltable;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RMQueryItemList;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.util.symboltable.ISymbolTable;
import com.cognos.xqe.util.symboltable.SymbolTableStack;
import com.cognos.xqe.util.symboltable.SymbolTableUtil;
import com.cognos.xqemoser.MoserQuerySubject;
import java.util.Iterator;

public class SymbolTableForRMQuery
implements ISymbolTable {
    private RMQueryItemList queryItems;
    private IQuerySubject querySubject;
    private final IMetadata contextMetadata;
    private final boolean bOnlyInQS;

    public SymbolTableForRMQuery(IPlanningEnvironment environment, RMQuery rmQuery, IMetadata c, boolean bOnlyQS) {
        this.contextMetadata = c;
        this.queryItems = rmQuery.getRMQueryItemList((PlanningEnvironment)environment);
        this.querySubject = rmQuery.getQuerySubject();
        this.bOnlyInQS = bOnlyQS;
    }

    @Override
    public IMetadata get(String ref, SymbolTableStack stack) {
        if (SymbolTableStack.bindInMoserQuerySubject(this.querySubject)) {
            MoserQuerySubject.SearchScope[] s = null;
            s = this.bOnlyInQS ? MoserQuerySubject.ONLY_IN_QUERYSUBJECT : MoserQuerySubject.QUERYSUBJECT_AND_SOURCE_QUERYSUBJECT;
            return ((MoserQuerySubject)this.querySubject).getReferencedMetadata(ref, this.contextMetadata, s);
        }
        String singleName = SymbolTableUtil.getSingleName(ref);
        if (singleName == null) {
            return null;
        }
        Iterator<IXQEQueryNode> childIterator = this.queryItems.getChildrenIterator();
        while (childIterator.hasNext()) {
            IXQEQueryNode qi = childIterator.next();
            RMQueryItem rmQueryItem = (RMQueryItem)qi;
            if (!rmQueryItem.getName().equals(singleName)) continue;
            return rmQueryItem.getQueryItem();
        }
        return null;
    }

    @Override
    public IQuerySubject getQuerySubject() {
        return this.querySubject;
    }
}

