/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

class Command {
    int exitCode = 0;
    String commandLine;
    String[] consoleOut = null;
    private ProcessBuilder builder;

    public static int runCommand(String cmd) {
        int exitCode = -1;
        Command aCmd = new Command(cmd);
        aCmd.runCmd();
        exitCode = aCmd.getExitCode();
        return exitCode;
    }

    public static String[] runCommandConsole(String cmd) {
        Command aCmd = new Command(cmd);
        aCmd.runCmd();
        return aCmd.getConsoleOutput();
    }

    Command(String cmd) {
        this.commandLine = cmd;
        String[] cmdLineArgs = cmd.split(" ");
        this.builder = new ProcessBuilder(cmdLineArgs);
    }

    public String[] getConsoleOutput() {
        return this.consoleOut;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void runCmd() {
        this.exitCode = -1;
        try {
            Process nativeProcess = this.builder.start();
            this.getConsoleOutput(nativeProcess);
            nativeProcess.getErrorStream().close();
            nativeProcess.getInputStream().close();
            this.exitCode = nativeProcess.exitValue();
        }
        catch (IllegalThreadStateException stateException) {
            this.exitCode = -1;
        }
        catch (Exception e) {
            this.exitCode = -1;
        }
    }

    private void getConsoleOutput(Process nativeProcess) throws IOException {
        BufferedReader aReader = new BufferedReader(new InputStreamReader(nativeProcess.getInputStream()));
        ArrayList<String> lineArray = new ArrayList<String>();
        String line = aReader.readLine();
        while (line != null) {
            Command.addNonBlankLine(lineArray, line);
            line = aReader.readLine();
        }
        this.consoleOut = new String[lineArray.size()];
        lineArray.toArray(this.consoleOut);
    }

    private static void addNonBlankLine(ArrayList<String> lineArray, String line) {
        if (!line.equals("")) {
            lineArray.add(line);
        }
    }
}

