/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.usage.indicators;

import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.SessionContext;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.context.UsageSummaryContext;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import java.util.Observable;
import java.util.Observer;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractUsageIndicator
implements IUsageIndicator,
Observer {
    protected final String name;
    protected final UsageIndicatorCategory category;
    protected final AtomicLong value = new AtomicLong(0L);
    protected final boolean perReport;
    private WeakHashMap<SessionContext, AtomicLong> perReportValues = null;
    private ReentrantReadWriteLock perReportValueLock = null;

    protected AbstractUsageIndicator(UsageIndicatorCategory cat, String nam, boolean perRep) {
        this.category = cat;
        this.name = nam;
        this.perReport = perRep;
        if (this.perReport) {
            this.perReportValues = new WeakHashMap();
            this.perReportValueLock = new ReentrantReadWriteLock();
        }
    }

    @Override
    public final void setValue(long val) {
        if (this.perReport) {
            AtomicLong v = this.getPerReportValue();
            if (v != null) {
                this.onSet(v, val);
            }
        } else {
            this.onSet(this.value, val);
        }
    }

    @Override
    public final void increment() {
        if (this.perReport) {
            AtomicLong v = this.getPerReportValue();
            if (v != null) {
                this.onIncrement(v);
            }
        } else {
            this.onIncrement(this.value);
        }
    }

    @Override
    public final void add(long val) {
        if (this.perReport) {
            AtomicLong v = this.getPerReportValue();
            if (v != null) {
                this.onAdd(v, val);
            }
        } else {
            this.onAdd(this.value, val);
        }
    }

    @Override
    public long getValue() {
        if (this.perReport) {
            AtomicLong v = this.getPerReportValue();
            if (v != null) {
                return v.get();
            }
            return 0L;
        }
        return this.value.get();
    }

    @Override
    public long pullValue() {
        if (this.perReport) {
            AtomicLong v = this.getPerReportValue();
            if (v != null) {
                return v.getAndSet(0L);
            }
            return 0L;
        }
        return this.value.getAndSet(0L);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UsageIndicatorCategory getCategory() {
        return this.category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtomicLong getPerReportValue() {
        SessionContext sc;
        MultiRequestContext mrc;
        if (this.getCategory() == UsageIndicatorCategory.XQE_SUMMARY) {
            return UsageSummaryContext.getOrCreateReportValue(this.getCategory(), this.getName());
        }
        AtomicLong val = null;
        IExecutionEnvironment env = ExecutionEnvironmentContext.getExecutionEnvironment();
        if (env != null && (mrc = env.getMultiRequestContextNoThrow()) != null && (sc = mrc.getSessionContext()) != null) {
            this.perReportValueLock.readLock().lock();
            try {
                val = this.perReportValues.get(sc);
                if (val != null) {
                    AtomicLong atomicLong = val;
                    return atomicLong;
                }
            }
            finally {
                this.perReportValueLock.readLock().unlock();
            }
            this.perReportValueLock.writeLock().lock();
            try {
                val = this.perReportValues.get(sc);
                if (val != null) {
                    AtomicLong atomicLong = val;
                    return atomicLong;
                }
                val = new AtomicLong(0L);
                this.perReportValues.put(sc, val);
                sc.addObserver(this);
                UsageTrackingService.registerReport(sc, env.getRequestEnvironment().getReportName());
            }
            finally {
                this.perReportValueLock.writeLock().unlock();
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof SessionContext) {
            this.perReportValueLock.writeLock().lock();
            try {
                AtomicLong val = this.perReportValues.remove(o);
                if (val == null) {
                    throw new IllegalStateException("Indicator counter must exist");
                }
                this.onReportClose(val);
                UsageTrackingService.updatePerReportValue((SessionContext)o, this.getCategory(), this.getName(), val.getAndSet(0L));
            }
            finally {
                this.perReportValueLock.writeLock().unlock();
            }
        }
    }

    protected abstract void onIncrement(AtomicLong var1);

    protected abstract void onAdd(AtomicLong var1, long var2);

    protected abstract void onSet(AtomicLong var1, long var2);

    protected abstract void onReportClose(AtomicLong var1);
}

