/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.xml;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class XMLUtils {
    public static final String ID = "id";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String SINGLE_QUOTE = "'";
    private static final String COLON = ":";
    public static final String XMLNS = "xmlns";
    public static final String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    public static final String NS_PREFIX_XML = "xml";
    public static final String NS_PREFIX_XMLNS = "xmlns";
    public static final String UTF_8 = "utf-8";
    private static final String DEFER_NODE_EXPANSION = "http://apache.org/xml/features/dom/defer-node-expansion";
    private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String LOAD_DTD_GRAMMAR = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
    private static final String DISALLOW_DOCTYPE_DEC1 = "http://apache.org/xml/features/disallow-doctype-decl";
    public static final String NS_PREFIX_EXTENSIONS = "xqe-fn";
    public static final String NS_URI_XQUERY_EXTENSIONS = "http://www.ibm.com/xqe";
    private static DocumentBuilder builder;
    public static final Pattern XMLDECL_PATTERN;

    private XMLUtils() {
    }

    public static Document newDocument() {
        return builder.newDocument();
    }

    private static void recursiveAddTextContent(org.w3c.dom.Node n, StringBuilder buffer) {
        if (n != null) {
            if (n.getNodeType() == 3 || n.getNodeType() == 4) {
                buffer.append(n.getNodeValue());
            }
            NodeList nodes = n.getChildNodes();
            int ct = nodes.getLength();
            for (int i = 0; i < ct; ++i) {
                org.w3c.dom.Node child = nodes.item(i);
                XMLUtils.recursiveAddTextContent(child, buffer);
            }
        }
    }

    public static String getTextContent(org.w3c.dom.Node n) {
        StringBuilder buffer = new StringBuilder();
        XMLUtils.recursiveAddTextContent(n, buffer);
        return buffer.toString();
    }

    public static String toString(Node node) throws IOException {
        StringWriter stringWriter = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)stringWriter, OutputFormat.createPrettyPrint());
        writer.write(node);
        writer.close();
        return stringWriter.toString();
    }

    public static void write(List<org.dom4j.Element> elements, StringWriter writer) throws IOException {
        for (org.dom4j.Element element : elements) {
            element.write((Writer)writer);
        }
    }

    public static String declareNamespace(org.dom4j.Element element, String namespaceUri, String prefix) {
        String nsDeclAttrName = null;
        nsDeclAttrName = prefix != null ? "xmlns:" + prefix : "xmlns";
        Attribute attr = DocumentHelper.createAttribute((org.dom4j.Element)element, (String)nsDeclAttrName, (String)namespaceUri);
        attr.setNamespace(DocumentHelper.createNamespace((String)prefix, (String)namespaceUri));
        return prefix;
    }

    public static String declareNamespace(org.dom4j.Element element, String namespaceUri) {
        return XMLUtils.declareNamespace(element, namespaceUri, null);
    }

    public static String getNamespaceURIFromPrefix(org.w3c.dom.Node node, String prefix) {
        short type = node.getNodeType();
        switch (type) {
            case 2: {
                node = ((Attr)node).getOwnerElement();
                break;
            }
            case 1: {
                break;
            }
            default: {
                node = node.getParentNode();
            }
        }
        while (node != null && node.getNodeType() == 1) {
            Element e = (Element)node;
            String namespaceURI = prefix == null ? XMLUtils.getAttribute(e, "xmlns") : XMLUtils.getAttribute(e, "xmlns:" + prefix);
            if (namespaceURI != null) {
                return namespaceURI;
            }
            node = e.getParentNode();
        }
        return null;
    }

    public static String getAttribute(org.w3c.dom.Node node, String localName) {
        return XMLUtils.getAttributeNS(node, localName, null);
    }

    public static String getAttributeNS(org.w3c.dom.Node node, String localName, String namespaceURI) {
        if (!(node instanceof Element)) {
            return null;
        }
        Attr attr = namespaceURI == null ? ((Element)node).getAttributeNode(localName) : ((Element)node).getAttributeNodeNS(namespaceURI, localName);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static Document parse(String s, boolean namespaceAware, boolean validating) {
        return XMLUtils.parse(new InputSource(new StringReader(s)), namespaceAware, validating);
    }

    public static Document parse(InputSource iSource, boolean namespaceAware, boolean validating) {
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        try {
            f.setNamespaceAware(namespaceAware);
            f.setValidating(validating);
            f.setAttribute(DEFER_NODE_EXPANSION, Boolean.FALSE);
            f.setAttribute(LOAD_DTD_GRAMMAR, Boolean.FALSE);
            f.setAttribute(LOAD_EXTERNAL_DTD, Boolean.FALSE);
            f.setFeature(DISALLOW_DOCTYPE_DEC1, true);
            DocumentBuilder b = f.newDocumentBuilder();
            return b.parse(iSource);
        }
        catch (ParserConfigurationException e) {
            throw new XQERuntimeException(e);
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    public static String extractIDAttribute(org.dom4j.Element element) {
        String id;
        if (null != element) {
            id = element.attributeValue(ID);
            if (null == id) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "null == id");
            }
            if (0 == id.length()) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "0 == id.length()");
            }
        } else {
            id = null;
        }
        return id;
    }

    public static String xPathLiteral(String value) {
        StringBuilder stringBuilder = new StringBuilder();
        if (value.indexOf(SINGLE_QUOTE) == -1) {
            stringBuilder.append(SINGLE_QUOTE).append(value).append(SINGLE_QUOTE);
        } else if (value.indexOf(DOUBLE_QUOTE) == -1) {
            stringBuilder.append(DOUBLE_QUOTE).append(value).append(DOUBLE_QUOTE);
        } else {
            stringBuilder.append(SINGLE_QUOTE).append(value.replaceAll(SINGLE_QUOTE, "&apos;")).append(SINGLE_QUOTE);
        }
        return stringBuilder.toString();
    }

    static {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        builderFactory.setValidating(false);
        builderFactory.setAttribute(LOAD_DTD_GRAMMAR, Boolean.FALSE);
        builderFactory.setAttribute(LOAD_EXTERNAL_DTD, Boolean.FALSE);
        try {
            builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XQERuntimeException(e);
        }
        XMLDECL_PATTERN = Pattern.compile("\\A\\s*<\\?\\s*[xX][mM][lL]\\s*.*\\?>\\s*(.*)", 32);
    }
}

