/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.xml.serializer;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.xml.serializer.ClassAccessor;
import com.cognos.xqe.util.xml.serializer.FieldAccessor;
import com.cognos.xqe.util.xml.serializer.XMLAttribute;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import com.cognos.xqe.util.xml.serializer.XMLElementCollection;
import com.cognos.xqe.util.xml.serializer.XMLElementMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class Serializer {
    private static final String XML_ATTR_SCALE = "scale";
    private static final String XML_ATTR_PRECISION = "precision";
    private static final String VALUE_TYPE_DEFAULT_METHOD = "getString";
    private static final String OBJECT_TYPE = "objType";
    private static final String ENUM_TYPE = "enumType";
    private static final String VALUE_INFO = "valInfo";
    private final Stack<Object> context = new Stack();
    private final Map<Class<?>, List<Field>> classFields = new HashMap();
    private final Map<Field, String> fieldNameCache = new HashMap<Field, String>();
    private final Map<Class<?>, Boolean> basicTypeCache = new HashMap();
    private final Map<Field, String> methodNameCache = new HashMap<Field, String>();
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "XMLSerializer", LogLevel.ERROR);
    private final boolean includeType;
    private List<String> fieldMask = new LinkedList<String>();

    Serializer() {
        this(false);
    }

    Serializer(boolean setIncludeType) {
        this.includeType = setIncludeType;
    }

    void reset() {
        this.context.clear();
        this.classFields.clear();
        this.fieldNameCache.clear();
        this.fieldNameCache.clear();
        this.methodNameCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Object obj, XMLStreamWriter output) throws XMLStreamException, IllegalAccessException {
        if (obj == null) {
            return;
        }
        try {
            output.writeStartDocument();
            if (obj instanceof Collection) {
                String rootName = "Collection";
                output.writeStartElement(rootName);
                this.writeObjectType(obj, output);
                this.writeCollection(FieldAccessor.castToCollection(obj), output);
            } else {
                String rootName = ClassAccessor.getLocalName(obj.getClass());
                output.writeStartElement(rootName);
                this.writeObjectType(obj, output);
                this.writeFields(obj, output);
            }
            output.writeEndElement();
            output.writeEndDocument();
        }
        finally {
            output.flush();
            output.close();
            this.reset();
        }
    }

    void writeCollection(Collection<Object> coll, XMLStreamWriter output) throws XMLStreamException, IllegalAccessException {
        if (!coll.isEmpty()) {
            for (Object obj : coll) {
                String itemName = ClassAccessor.getLocalName(obj.getClass());
                output.writeStartElement(itemName);
                this.writeObjectType(coll, output);
                this.writeWrappedObject(obj, output, false);
                output.writeEndElement();
            }
        }
    }

    private void writeFields(Object obj, XMLStreamWriter output) throws XMLStreamException, IllegalAccessException {
        if (this.context.contains(obj)) {
            return;
        }
        List<Field> fields = this.getCachedFields(obj.getClass());
        this.context.push(obj);
        for (Field f : fields) {
            String fieldName = f.getName();
            if (!this.fieldMask.isEmpty() && this.fieldMask.contains(fieldName)) continue;
            Object fieldObj = FieldAccessor.getFieldAsObject(obj, f);
            this.writeField(fieldObj, f, output, "");
        }
        this.context.pop();
    }

    private void writeField(Object obj, Field field, XMLStreamWriter output, String fieldName) throws XMLStreamException, IllegalAccessException {
        if (obj == null || field == null) {
            return;
        }
        if (fieldName == null || fieldName.equals("")) {
            fieldName = this.getFieldName(field);
        }
        String methodToCall = this.getMethodToCall(field);
        if (this.isBasicType(obj)) {
            this.writeBasicField(obj, field, output, fieldName);
        } else if (field.isAnnotationPresent(XMLAttribute.class) && !methodToCall.equals("")) {
            this.writeBasicField(obj, field, output, fieldName);
        } else if (field.isAnnotationPresent(XMLElement.class) || obj.getClass().isAnnotationPresent(XMLElement.class)) {
            if (!methodToCall.equals("")) {
                this.writeBasicField(obj, field, output, fieldName);
            } else {
                this.writeComplexField(obj, output, fieldName);
            }
        } else if (field.isAnnotationPresent(XMLElementCollection.class)) {
            this.writeCollectionField(FieldAccessor.castToCollection(obj), field, output, fieldName);
        } else if (field.isAnnotationPresent(XMLElementMap.class)) {
            this.writeMapField(FieldAccessor.castToMap(obj), field, output, fieldName);
        }
    }

    private void writeBasicField(Object obj, Field field, XMLStreamWriter output, String fieldName) throws XMLStreamException, IllegalAccessException {
        String textToWrite = this.getTextFromField(obj, field);
        if (field.isAnnotationPresent(XMLAttribute.class)) {
            output.writeAttribute(fieldName, textToWrite);
        } else if (field.isAnnotationPresent(XMLElement.class) || field.isAnnotationPresent(XMLElementCollection.class) || field.isAnnotationPresent(XMLElementMap.class) || obj.getClass().isAnnotationPresent(XMLElement.class)) {
            output.writeStartElement(fieldName);
            if (obj instanceof IDataType) {
                this.handleIDataType(obj, output);
            }
            this.writeObjectType(obj, output);
            this.writeText(output, textToWrite, FieldAccessor.isCDATA(field));
            output.writeEndElement();
        }
    }

    private void writeComplexField(Object obj, XMLStreamWriter output, String fieldName) throws XMLStreamException, IllegalAccessException {
        output.writeStartElement(fieldName);
        this.writeObjectType(obj, output);
        this.writeFields(obj, output);
        output.writeEndElement();
    }

    private void writeCollectionField(Collection<Object> collection, Field field, XMLStreamWriter output, String fieldName) throws XMLStreamException, IllegalAccessException {
        boolean callMethod;
        XMLElementCollection annotation = field.getAnnotation(XMLElementCollection.class);
        boolean bl = callMethod = !this.getMethodToCall(field).equals("");
        if (!collection.isEmpty()) {
            output.writeStartElement(fieldName);
            this.writeObjectType(collection, output);
            String itemName = annotation.itemName();
            boolean isCDATA = annotation.cdata();
            for (Object item : collection) {
                output.writeStartElement(itemName);
                this.writeObjectType(item, output);
                if (item instanceof IDataType) {
                    this.handleIDataType(item, output);
                }
                if (callMethod) {
                    this.writeText(output, this.getTextFromField(item, field), isCDATA);
                } else {
                    this.writeWrappedObject(item, output, isCDATA);
                }
                output.writeEndElement();
            }
            output.writeEndElement();
        }
    }

    private void writeMapField(Map<Object, Object> map, Field field, XMLStreamWriter output, String fieldName) throws XMLStreamException, IllegalAccessException {
        boolean callMethod;
        XMLElementMap annotation = field.getAnnotation(XMLElementMap.class);
        boolean bl = callMethod = !this.getMethodToCall(field).equals("");
        if (!map.isEmpty()) {
            output.writeStartElement(fieldName);
            this.writeObjectType(map, output);
            String itemName = annotation.itemName();
            String keyName = annotation.keyName();
            String valName = annotation.valName();
            boolean isCDATA = annotation.cdata();
            for (Object key : map.keySet()) {
                Object val = map.get(key);
                output.writeStartElement(itemName);
                output.writeStartElement(keyName);
                this.writeObjectType(key, output);
                if (key instanceof IDataType) {
                    this.handleIDataType(key, output);
                }
                this.writeWrappedObject(key, output, false);
                output.writeEndElement();
                output.writeStartElement(valName);
                this.writeObjectType(val, output);
                if (val instanceof IDataType) {
                    this.handleIDataType(val, output);
                }
                if (callMethod) {
                    this.writeText(output, this.getTextFromField(val, field), isCDATA);
                } else {
                    this.writeWrappedObject(val, output, isCDATA);
                }
                output.writeEndElement();
                output.writeEndElement();
            }
            output.writeEndElement();
        }
    }

    private void writeWrappedObject(Object obj, XMLStreamWriter output, boolean isCDATA) throws XMLStreamException, IllegalAccessException {
        if (this.isBasicType(obj)) {
            String text = "";
            text = obj instanceof Value ? ((Value)obj).getString() : (obj instanceof Enum ? ((Enum)obj).name() : obj.toString());
            this.writeText(output, text, isCDATA);
        } else {
            this.writeFields(obj, output);
        }
    }

    private void writeText(XMLStreamWriter output, String item, boolean isCDATA) throws XMLStreamException {
        if (isCDATA) {
            output.writeCData(item);
        } else {
            output.writeCharacters(item);
        }
    }

    private List<Field> getCachedFields(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        List<Field> cachedFields = this.classFields.get(clazz);
        if (cachedFields == null) {
            cachedFields = this.getFields(clazz);
            this.classFields.put(clazz, cachedFields);
        }
        return cachedFields;
    }

    private List<Field> getFields(Class<?> clazz) {
        LinkedList<Field> fields = new LinkedList<Field>();
        while (clazz != null) {
            Field[] fs;
            for (Field f : fs = clazz.getDeclaredFields()) {
                fields.add(f);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    private String getFieldName(Field field) {
        if (!this.fieldNameCache.containsKey(field)) {
            String name = FieldAccessor.getLocalName(field);
            this.fieldNameCache.put(field, name);
            return name;
        }
        return this.fieldNameCache.get(field);
    }

    private boolean isBasicType(Object obj) {
        Class<?> clazz = obj.getClass();
        Boolean isBasicType = this.basicTypeCache.get(clazz);
        if (isBasicType == null) {
            isBasicType = FieldAccessor.isBasicType(obj);
            this.basicTypeCache.put(clazz, isBasicType);
        }
        return isBasicType;
    }

    private String getMethodToCall(Field field) {
        String methodName = this.methodNameCache.get(field);
        if (methodName == null) {
            XMLElement element = field.getAnnotation(XMLElement.class);
            if (element != null) {
                methodName = element.callMethod();
            } else {
                XMLAttribute attr = field.getAnnotation(XMLAttribute.class);
                if (attr != null) {
                    methodName = attr.callMethod();
                } else {
                    XMLElementCollection coll = field.getAnnotation(XMLElementCollection.class);
                    if (coll != null) {
                        methodName = coll.callMethod();
                    } else {
                        XMLElementMap map = field.getAnnotation(XMLElementMap.class);
                        if (map != null) {
                            methodName = map.callMethod();
                        }
                    }
                }
            }
            if (methodName == null) {
                methodName = "";
            }
            this.methodNameCache.put(field, methodName);
        }
        return methodName;
    }

    private String getTextFromField(Object obj, Field field) {
        String methodToCall = this.getMethodToCall(field);
        if (obj instanceof Value) {
            methodToCall = VALUE_TYPE_DEFAULT_METHOD;
        }
        String textToWrite = "";
        if (methodToCall.equals("")) {
            textToWrite = obj.toString();
        } else {
            Class[] args = new Class[]{};
            Method method = null;
            try {
                method = obj.getClass().getMethod(methodToCall, args);
            }
            catch (Throwable e) {
                if (LOGGER.isOn()) {
                    LOGGER.log(methodToCall + "() doesn't exist in class " + obj.getClass().getName());
                }
                method = null;
            }
            Object[] params = new Object[]{};
            if (method != null) {
                try {
                    Object result = method.invoke(obj, params);
                    if (result != null) {
                        textToWrite = result.toString();
                    }
                }
                catch (Throwable e) {
                    if (LOGGER.isOn()) {
                        LOGGER.log(methodToCall + "() in class " + obj.getClass().getName() + " cannot be invoked.");
                    }
                    textToWrite = "";
                }
            }
        }
        return textToWrite;
    }

    private void writeObjectType(Object obj, XMLStreamWriter output) throws XMLStreamException {
        if (obj != null && this.includeType) {
            EnumSet set;
            output.writeAttribute(OBJECT_TYPE, obj.getClass().getName());
            if (obj instanceof Value) {
                Value val = (Value)obj;
                output.writeAttribute(VALUE_INFO, val.getDataType().toString());
            } else if (obj instanceof EnumSet && !(set = (EnumSet)obj).isEmpty()) {
                Iterator itr = set.iterator();
                Object enumObj = itr.next();
                output.writeAttribute(ENUM_TYPE, enumObj.getClass().getName());
            }
        }
    }

    private void handleIDataType(Object obj, XMLStreamWriter output) throws XMLStreamException {
        IDataType dataType = (IDataType)obj;
        if (dataType.hasPrecision()) {
            output.writeAttribute(XML_ATTR_PRECISION, String.valueOf(dataType.getPrecision()));
        }
        if (dataType.hasScale()) {
            output.writeAttribute(XML_ATTR_SCALE, String.valueOf(dataType.getScale()));
        }
    }

    void removeSerializerMask() {
        this.fieldMask.clear();
    }

    void setSerializerMask(List<String> mask) {
        this.fieldMask.clear();
        if (mask != null) {
            this.fieldMask.addAll(mask);
        }
    }
}

