/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.xml.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ForwardingChildElementIterator {
    private final XMLStreamReader reader;
    private final QName parentName;
    private int depth = 0;
    private boolean reachedEnd = false;

    public ForwardingChildElementIterator(XMLStreamReader theReader) throws XMLStreamException {
        if (1 != theReader.getEventType()) {
            throw new IllegalStateException("The XMLStreamReader was not positioned at a START_ELEMENT");
        }
        this.reader = theReader;
        this.parentName = theReader.getName();
    }

    public boolean next() throws XMLStreamException {
        if (this.reachedEnd) {
            return false;
        }
        this.moveToNextChild();
        return !this.reachedEnd;
    }

    public void skipToEnd() throws XMLStreamException {
        while (this.next()) {
        }
    }

    private void moveToNextChild() throws XMLStreamException {
        int eventType = this.reader.getEventType();
        if (this.depth > 0 && 2 == eventType) {
            --this.depth;
        }
        while (8 != eventType) {
            eventType = this.reader.next();
            if (1 == eventType) {
                ++this.depth;
                if (this.depth != 1) continue;
                return;
            }
            if (2 != eventType) continue;
            --this.depth;
            if (this.depth != -1 || !this.reader.getName().equals(this.parentName)) continue;
            this.reachedEnd = true;
            return;
        }
        this.reachedEnd = true;
    }
}

