/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqeapi.jdbc;

import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.BinaryValue;
import com.cognos.xqe.data.values.BlobValue;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.ClobValue;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqeapi.DQResultSet;
import com.cognos.xqeapi.jdbc.DQJDBCResultSetMetaData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;

public class DQJDBCResultSet
implements ResultSet {
    private static final String CANNOT_CONVERT_COLUMN = "Cannot convert column ";
    private static final String ILLEGAL_CONVERSION = "Illegal conversion";
    private DQResultSet dqResultSet;
    private boolean wasNull = false;
    private IRow aRow = null;

    public DQJDBCResultSet(DQResultSet dResultSet) {
        this.dqResultSet = dResultSet;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.dqResultSet != null) {
                this.dqResultSet.release();
                this.dqResultSet = null;
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj == null || NullValue.class.isInstance(obj)) {
                return null;
            }
            if (ArrayValue.class.isInstance(obj)) {
                return (Array)((ArrayValue)obj).getObject();
            }
            throw new Exception(ILLEGAL_CONVERSION);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMsg = CANNOT_CONVERT_COLUMN + columnIndex + " to array. ";
            throw new SQLException(errorMsg + e.getMessage(), e);
        }
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj == null || NullValue.class.isInstance(obj)) {
                return null;
            }
            if (NumericValue.class.isInstance(obj)) {
                return ((NumericValue)obj).getBigDecimal();
            }
            if (String.class.isInstance(obj)) {
                BigDecimal bd;
                DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
                df.setParseBigDecimal(true);
                String aBigDecimalString = (String)obj;
                aBigDecimalString = aBigDecimalString.trim();
                if (aBigDecimalString.charAt(0) == '+') {
                    aBigDecimalString = aBigDecimalString.substring(1);
                }
                try {
                    bd = (BigDecimal)df.parse(aBigDecimalString);
                }
                catch (Exception e) {
                    throw new Exception(ILLEGAL_CONVERSION);
                }
                return bd;
            }
            throw new Exception(ILLEGAL_CONVERSION);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMsg = CANNOT_CONVERT_COLUMN + columnIndex + " to bigDecimal. ";
            throw new SQLException(errorMsg + e.getMessage(), e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj == null) {
                return null;
            }
            if (NumericValue.class.isInstance(obj)) {
                return ((NumericValue)obj).getBigDecimal();
            }
            if (String.class.isInstance(obj)) {
                BigDecimal bd;
                DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
                df.setParseBigDecimal(true);
                String aBigDecimalString = (String)obj;
                aBigDecimalString = aBigDecimalString.trim();
                if (aBigDecimalString.charAt(0) == '+') {
                    aBigDecimalString = aBigDecimalString.substring(1);
                }
                try {
                    bd = (BigDecimal)df.parse(aBigDecimalString);
                }
                catch (Exception e) {
                    throw new Exception(ILLEGAL_CONVERSION);
                }
                return bd.setScale(scale, 1);
            }
            throw new Exception(ILLEGAL_CONVERSION);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMsg = CANNOT_CONVERT_COLUMN + columnIndex + " to bigDecimal with scale. ";
            throw new SQLException(errorMsg + e.getMessage(), e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj == null || NullValue.class.isInstance(obj)) {
                return null;
            }
            if (BlobValue.class.isInstance(obj)) {
                return (Blob)((BlobValue)obj).getObject();
            }
            throw new Exception(ILLEGAL_CONVERSION);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMsg = CANNOT_CONVERT_COLUMN + columnIndex + " to blob. ";
            throw new SQLException(errorMsg + e.getMessage(), e);
        }
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj == null || NullValue.class.isInstance(obj)) {
                return false;
            }
            if (BooleanValue.class.isInstance(obj)) {
                return ((BooleanValue)obj).getBoolean();
            }
            if (NumericValue.class.isInstance(obj)) {
                return !((NumericValue)obj).isZero();
            }
            if (String.class.isInstance(obj)) {
                return !((String)obj).toString().equals("0");
            }
            throw new Exception(ILLEGAL_CONVERSION);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMsg = CANNOT_CONVERT_COLUMN + columnIndex + " to boolean. ";
            throw new SQLException(errorMsg + e.getMessage(), e);
        }
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return 0;
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj == null || NullValue.class.isInstance(obj)) {
                return null;
            }
            if (BinaryValue.class.isInstance(obj)) {
                return ((BinaryValue)obj).getByteArray();
            }
            if (NumericValue.class.isInstance(obj)) {
                return ((NumericValue)obj).getByteArray();
            }
            throw new Exception(ILLEGAL_CONVERSION);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMsg = CANNOT_CONVERT_COLUMN + columnIndex + " to byte array. ";
            throw new SQLException(errorMsg + e.getMessage(), e);
        }
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj == null || NullValue.class.isInstance(obj)) {
                return null;
            }
            if (ClobValue.class.isInstance(obj)) {
                return (ClobValue)obj;
            }
            throw new Exception(ILLEGAL_CONVERSION);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMsg = CANNOT_CONVERT_COLUMN + columnIndex + " to clob. ";
            throw new SQLException(errorMsg + e.getMessage(), e);
        }
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj == null || NullValue.class.isInstance(obj)) {
                return null;
            }
            if (DateValue.class.isInstance(obj)) {
                return ((DateValue)obj).getJdbcDate();
            }
            if (String.class.isInstance(obj)) {
                return Date.valueOf((String)obj);
            }
            throw new Exception(ILLEGAL_CONVERSION);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMsg = CANNOT_CONVERT_COLUMN + columnIndex + " to date. ";
            throw new SQLException(errorMsg + e.getMessage(), e);
        }
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj == null || NullValue.class.isInstance(obj)) {
                return 0.0;
            }
            if (NumericValue.class.isInstance(obj)) {
                return ((NumericValue)obj).getDouble();
            }
            if (String.class.isInstance(obj)) {
                return Double.valueOf((String)obj);
            }
            throw new Exception(ILLEGAL_CONVERSION);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMsg = CANNOT_CONVERT_COLUMN + columnIndex + " to double. ";
            throw new SQLException(errorMsg + e.getMessage(), e);
        }
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj == null || NullValue.class.isInstance(obj)) {
                return 0.0f;
            }
            if (NumericValue.class.isInstance(obj)) {
                return ((NumericValue)obj).getFloat();
            }
            if (String.class.isInstance(obj)) {
                return Float.valueOf((String)obj).floatValue();
            }
            throw new Exception(ILLEGAL_CONVERSION);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMsg = CANNOT_CONVERT_COLUMN + columnIndex + " to float. ";
            throw new SQLException(errorMsg + e.getMessage(), e);
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj == null || NullValue.class.isInstance(obj)) {
                return 0;
            }
            if (NumericValue.class.isInstance(obj)) {
                return ((NumericValue)obj).getInteger();
            }
            if (String.class.isInstance(obj)) {
                return Integer.valueOf((String)obj);
            }
            throw new Exception(ILLEGAL_CONVERSION);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMsg = CANNOT_CONVERT_COLUMN + columnIndex + " to int. ";
            throw new SQLException(errorMsg + e.getMessage(), e);
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj == null || NullValue.class.isInstance(obj)) {
                return 0L;
            }
            if (NumericValue.class.isInstance(obj)) {
                return ((NumericValue)obj).getLong();
            }
            if (String.class.isInstance(obj)) {
                return Long.valueOf((String)obj);
            }
            throw new Exception(ILLEGAL_CONVERSION);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMsg = CANNOT_CONVERT_COLUMN + columnIndex + " to long. ";
            throw new SQLException(errorMsg + e.getMessage(), e);
        }
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new DQJDBCResultSetMetaData(this.dqResultSet.getMetadata());
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            this.aRow = this.dqResultSet.next();
            if (this.aRow == null) {
                throw new SQLException("No row found.");
            }
            if (columnIndex > this.aRow.getNumColumns()) {
                throw new SQLException("Invalid columnIndex: " + columnIndex);
            }
            this.wasNull = false;
            if (this.aRow.getColumn(columnIndex - 1).isNull()) {
                this.wasNull = true;
            }
            return this.aRow.getColumn(columnIndex - 1);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public int getRow() throws SQLException {
        return 0;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj == null || NullValue.class.isInstance(obj)) {
                return 0;
            }
            if (NumericValue.class.isInstance(obj)) {
                return ((NumericValue)obj).getShort();
            }
            if (String.class.isInstance(obj)) {
                return Short.valueOf((String)obj);
            }
            throw new Exception(ILLEGAL_CONVERSION);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMsg = CANNOT_CONVERT_COLUMN + columnIndex + " to short. ";
            throw new SQLException(errorMsg + e.getMessage(), e);
        }
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Value) {
                return ((Value)obj).getString();
            }
            return obj.toString();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMsg = CANNOT_CONVERT_COLUMN + columnIndex + " to string. ";
            throw new SQLException(errorMsg + e.getMessage(), e);
        }
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj == null || NullValue.class.isInstance(obj)) {
                return null;
            }
            if (TimeValue.class.isInstance(obj)) {
                return ((TimeValue)obj).getTime();
            }
            if (String.class.isInstance(obj)) {
                return Time.valueOf((String)obj);
            }
            throw new Exception(ILLEGAL_CONVERSION);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMsg = CANNOT_CONVERT_COLUMN + columnIndex + " to time. ";
            throw new SQLException(errorMsg + e.getMessage(), e);
        }
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj == null || NullValue.class.isInstance(obj)) {
                return null;
            }
            if (TimestampValue.class.isInstance(obj)) {
                return ((TimestampValue)obj).getTimestamp();
            }
            if (String.class.isInstance(obj)) {
                return Timestamp.valueOf((String)obj);
            }
            throw new Exception(ILLEGAL_CONVERSION);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMsg = CANNOT_CONVERT_COLUMN + columnIndex + " to timestamp. ";
            throw new SQLException(errorMsg + e.getMessage(), e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public int getType() throws SQLException {
        return 0;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public boolean next() throws SQLException {
        try {
            return this.dqResultSet.hasNext();
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }
}

