/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.commandlineutility;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.LogIPFControl;
import com.cognos.xqe.bibushandler.XQEService;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqebifw.adminconsole.server.JmxUtils;
import com.cognos.xqebifw.config.CCLConfigurationFactoryImpl;
import com.cognos.xqebifw.management.XqeAgent;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public final class QueryServiceAdminTask {
    private static final String ERRMSG_QS_INSTANCE = " for query service instance ";
    private static final String FLUSH_OPERATION = "flush";
    private static final String DUMP_OPERATION = "dump";
    private static final String ERR_MSG_PERFRM_SECURED_CACHE_TASK = "Error performing operation: performSecuredCacheTask";
    private static final String ERR_MSG_GET_DISP_HESSIAN_CONN = "Error performing operation: getDispatcherHessianConnection";
    private static final String ERR_MSG_GET_XQE_MBEAN_CONN = "Error performing operation: getXqeMBeanServerConnection";
    private static final String EMPTY_STRING = "";
    private static final String QUOTES = "\"";
    private static final String ASTRIK = "*";
    private static final String XQE_SALMETRIC_MBEAN_PATTERN = "com.cognos:type=salMetrics,service=xqeMetricsService";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static String[] xqeJmxUrl = null;
    private static final String DATASOURCENAME = "DATASOURCENAME";
    private static final String CATALOGNAME = "CATALOGNAME";
    private static final String CUBENAME = "CUBENAME";
    private static ICCLConfiguration cclConfig = null;
    private static String dispatcherAddr = null;
    private static String dispatcherPassword = null;
    private static final String STR_SLASH = "/";
    private static final int INT_TWO = 2;
    private static final int INT_ZERO = 0;
    private static final int INT_ONE = 1;
    private int taskId = -1;
    private String taskParameter = "";
    private static final String COLON = " : ";

    public QueryServiceAdminTask(int tId, String tParam) {
        this.taskId = tId;
        this.taskParameter = tParam;
    }

    private static void initializeSystem() {
        try {
            LogIPFControl.start();
        }
        catch (Exception e) {
            System.out.println("error performing initializeSystem.");
        }
    }

    private static void terminate() {
        LogIPFControl.stop();
        if (XQEService.isInitialized()) {
            XQEService.terminate();
        }
    }

    private String fetchObjectNames(String desiredOutputObject) {
        String dsName = null;
        String catalogName = null;
        String cubeName = null;
        try {
            int firstIndexOfSlash = this.taskParameter.indexOf(STR_SLASH);
            int secondIndexOfSlash = this.taskParameter.indexOf(STR_SLASH, firstIndexOfSlash + 1);
            if (firstIndexOfSlash == -1 || secondIndexOfSlash == -1) {
                throw new RuntimeException("Invalid value passed for TaskParameter. Actual format should be: <DataSourceName>/<CatalogName>/<CubeName>");
            }
            dsName = this.taskParameter.substring(0, firstIndexOfSlash);
            if (desiredOutputObject.equalsIgnoreCase(DATASOURCENAME)) {
                return dsName;
            }
            catalogName = this.taskParameter.substring(firstIndexOfSlash + 1, secondIndexOfSlash);
            if (desiredOutputObject.equalsIgnoreCase(CATALOGNAME)) {
                return catalogName;
            }
            cubeName = this.taskParameter.substring(secondIndexOfSlash + 1, this.taskParameter.length());
            if (desiredOutputObject.equalsIgnoreCase(CUBENAME)) {
                return cubeName;
            }
        }
        catch (Exception e) {
            System.out.println("An error encountered while fetching " + desiredOutputObject + " from second input parameter.");
        }
        return null;
    }

    private JMXConnector getDispatcherHessianConnection() {
        String connectionUrl = null;
        String error = "Error performing operation: getDispatcherHessianConnection : Unable to determine dispatcher JMX URL from dispatcher URL ";
        try {
            URL url;
            if (cclConfig == null) {
                cclConfig = CCLConfigurationFactory.getInstance();
                cclConfig.init();
            }
            if (dispatcherAddr == null) {
                dispatcherAddr = cclConfig.getValue("internalDispatcher", false);
            }
            if (dispatcherPassword == null) {
                dispatcherPassword = cclConfig.getValue("disp_sharedsecret", false);
            }
            if ((connectionUrl = XqeAgent.makeDispatcherJmxUrl(url = new URL(dispatcherAddr), false)) == null) {
                System.out.println(error + dispatcherAddr);
                return null;
            }
            byte[] token = CryptoProvider.getToken((byte[])dispatcherPassword.getBytes());
            JMXConnector cntor = XqeAgent.getDispatcherJMXConnection(connectionUrl, token);
            if (cntor == null && url.getHost().equalsIgnoreCase("localhost")) {
                connectionUrl = XqeAgent.makeDispatcherJmxUrl(url, true);
                if (connectionUrl == null) {
                    System.out.println(error + dispatcherAddr);
                    return null;
                }
                cntor = XqeAgent.getDispatcherJMXConnection(connectionUrl, token);
            }
            return cntor;
        }
        catch (SecurityException x) {
            System.out.println("Error performing operation: getDispatcherHessianConnection : " + x.getMessage());
        }
        catch (CCLConfigurationException e) {
            System.out.println("Error performing operation: getDispatcherHessianConnection : " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("Error performing operation: getDispatcherHessianConnection : " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("Error performing operation: getDispatcherHessianConnection : " + e.getMessage());
        }
        return null;
    }

    private JMXConnector getJMXConnector(String xqeUrl, String credentials) {
        try {
            JMXServiceURL url = new JMXServiceURL(xqeUrl);
            HashMap<String, Object> environment = new HashMap<String, Object>();
            environment.put("jmx.remote.credentials", credentials);
            environment.put("request.waiting.timeout", 300000);
            return JMXConnectorFactory.connect(url, environment);
        }
        catch (MalformedURLException e) {
            System.out.println("Error performing operation: getXqeMBeanServerConnection : " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("Error performing operation: getXqeMBeanServerConnection : " + e.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performSecuredCacheTask(int tId, String dsName, String ctlgName, String cbName) {
        Object[] resultArray = null;
        JMXConnector connector = this.getDispatcherHessianConnection();
        try {
            String operatioName;
            if (this.taskId == 1) {
                operatioName = FLUSH_OPERATION;
            } else if (this.taskId == 2) {
                operatioName = DUMP_OPERATION;
            } else {
                throw new RuntimeException("Invalid Operation Name.");
            }
            MBeanServerConnection conn = null;
            if (connector != null) {
                conn = connector.getMBeanServerConnection();
            }
            if (conn == null) {
                throw new RuntimeException("getDispatcherHessianConnection returned null");
            }
            if (xqeJmxUrl == null) {
                xqeJmxUrl = JmxUtils.getAllXqeJMXURls(null, conn);
            }
            resultArray = new Object[xqeJmxUrl.length];
            for (int i = 0; i < xqeJmxUrl.length; ++i) {
                String jmxUrl = null;
                try (JMXConnector xqeConnection = null;){
                    Object result;
                    jmxUrl = xqeJmxUrl[i];
                    String credential = JmxUtils.getPassword(null, jmxUrl, conn);
                    xqeConnection = this.getJMXConnector(jmxUrl, credential);
                    MBeanServerConnection mbeanServerConnection = xqeConnection.getMBeanServerConnection();
                    StringBuilder objNameBuilder = new StringBuilder();
                    objNameBuilder.append(XQE_SALMETRIC_MBEAN_PATTERN);
                    ObjectName obName = new ObjectName(objNameBuilder.toString());
                    resultArray[i] = result = mbeanServerConnection.invoke(obName, operatioName, new Object[]{dsName, ctlgName, cbName}, new String[]{JAVA_LANG_STRING, JAVA_LANG_STRING, JAVA_LANG_STRING});
                    continue;
                }
            }
            conn = null;
        }
        catch (Exception e) {
            System.out.println("Error performing operation: performSecuredCacheTask : " + e.getMessage());
        }
        finally {
            if (connector != null) {
                try {
                    connector.close();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        boolean executionStatus = true;
        for (Object obj : resultArray) {
            Boolean flag;
            if (obj == null) {
                executionStatus = false;
            } else if (this.taskId == 1 && !(flag = (Boolean)obj).booleanValue()) {
                executionStatus = false;
            }
            if (executionStatus) break;
        }
        return executionStatus;
    }

    public boolean performTask() {
        boolean executionSucceeded = false;
        String datasourceName = null;
        String catalogName = null;
        String cubeName = null;
        if (this.taskParameter.equals(EMPTY_STRING)) {
            datasourceName = ASTRIK;
            catalogName = ASTRIK;
            cubeName = ASTRIK;
        } else {
            datasourceName = this.fetchObjectNames(DATASOURCENAME);
            catalogName = this.fetchObjectNames(CATALOGNAME);
            cubeName = this.fetchObjectNames(CUBENAME);
        }
        if (datasourceName == null || catalogName == null || cubeName == null) {
            return false;
        }
        executionSucceeded = this.performSecuredCacheTask(this.taskId, datasourceName, catalogName, cubeName);
        return executionSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        boolean executionSucceeded = false;
        try {
            QueryServiceAdminTask.initializeSystem();
            int taskId = Integer.valueOf(args[0]);
            String taskParameters = null;
            if (args.length > 1) {
                StringBuilder buffTaskParams = new StringBuilder(args[1]);
                if (buffTaskParams.indexOf(QUOTES) == 0) {
                    buffTaskParams.deleteCharAt(0);
                }
                int indexOfLastChar = buffTaskParams.length() - 1;
                if (buffTaskParams.lastIndexOf(QUOTES) == indexOfLastChar) {
                    buffTaskParams.deleteCharAt(indexOfLastChar);
                }
                taskParameters = buffTaskParams.toString();
            } else {
                taskParameters = EMPTY_STRING;
            }
            XQECCLConfigurationFactory.initialize(new CCLConfigurationFactoryImpl());
            XQEService.initialize();
            QueryServiceAdminTask queryServiceTask = new QueryServiceAdminTask(taskId, taskParameters);
            executionSucceeded = queryServiceTask.performTask();
            if (executionSucceeded) {
                System.out.println("Operation performed.");
            } else {
                System.out.println("Operation Failed.");
            }
        }
        catch (Exception e) {
            System.out.println("Could not perform requested operation : " + e.getMessage());
            e.printStackTrace();
        }
        catch (Error e) {
            System.out.println("Error performing requested operation : " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            QueryServiceAdminTask.terminate();
        }
    }
}

