/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen;

import com.cognos.portal.utils.XMLString;
import com.cognos.portal.xml.stream.XMLRecorderStreamWriter;
import com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen.QNameFactory;
import com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen.StringUtils;
import java.io.Writer;
import java.util.Locale;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class StaxBurner {
    private static final String STR_DOT = "'.";
    protected Locale mlocale = null;
    protected XMLStreamWriter mxmlWriter = null;
    protected Stack<QName> mnameStack = null;
    protected boolean mbThrowExceptionOnNameError = false;
    protected boolean mbUseNameStack = false;
    protected static final String DOCUMENT_ROOT_QNAME = "$DocumentRoot$";
    public static final String SPECIAL_MARKUP_NAME = "Markup_CDATA";
    public static final String SPECIAL_MARKUP_WITH_CDATA_START = "<Markup_CDATA><![CDATA[";
    public static final String SPECIAL_MARKUP_WITH_CDATA_END = "]]></Markup_CDATA>";

    public StaxBurner(Writer writer, Locale locale) throws XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        this.init(outputFactory.createXMLStreamWriter(writer), locale);
    }

    public StaxBurner(XMLStreamWriter xmlStreamWriter, Locale locale) throws XMLStreamException {
        this.init(xmlStreamWriter, locale);
    }

    protected void init(XMLStreamWriter xmlStreamWriter, Locale locale) {
        this.mlocale = locale;
        this.mxmlWriter = xmlStreamWriter;
        this.setUseNameStack(true);
    }

    public void setThrowExceptionOnNameError(boolean bThrowExceptionOnNameError) {
        this.mbThrowExceptionOnNameError = bThrowExceptionOnNameError;
    }

    public boolean getThrowExceptionOnNameError() {
        return this.mbThrowExceptionOnNameError;
    }

    public void setUseNameStack(boolean bUseNameStack) {
        this.mbUseNameStack = bUseNameStack;
        this.mnameStack = bUseNameStack ? new Stack() : null;
    }

    public boolean getUseNameStack() {
        return this.mbUseNameStack;
    }

    public XMLStreamWriter getWriter() {
        return this.mxmlWriter;
    }

    public void closeWriter() throws XMLStreamException {
        if (this.mxmlWriter != null) {
            this.mxmlWriter.flush();
            this.mxmlWriter.close();
        }
        if (this.mbUseNameStack) {
            QName qNameFromStack = this.stackPop();
            this.checkTagNames(null, qNameFromStack);
        }
    }

    public void documentStart() throws XMLStreamException {
        this.mxmlWriter.writeStartDocument("UTF-8", "1.0");
        if (this.mbUseNameStack) {
            QName qDocumentName = QNameFactory.newInstance(DOCUMENT_ROOT_QNAME);
            this.stackPush(qDocumentName);
        }
    }

    public void documentEnd() throws XMLStreamException {
        this.mxmlWriter.writeEndDocument();
        if (this.mbUseNameStack) {
            QName qDocumentName = QNameFactory.newInstance(DOCUMENT_ROOT_QNAME);
            QName qNameFromStack = this.stackPop();
            this.checkTagNames(qDocumentName, qNameFromStack);
        }
        this.closeWriter();
    }

    public void addDefaultNamespace(String sNamespaceURI) throws XMLStreamException {
        if (sNamespaceURI != null && sNamespaceURI.length() > 0) {
            this.mxmlWriter.setDefaultNamespace(sNamespaceURI);
        }
    }

    public void addDefaultNamespace(QName qName) throws XMLStreamException {
        String sNamespaceURI;
        if (qName != null && (sNamespaceURI = qName.getNamespaceURI()) != null && sNamespaceURI.length() > 0) {
            this.mxmlWriter.setDefaultNamespace(sNamespaceURI);
        }
    }

    public void addNamespace(String sPrefix, String sNamespaceURI) throws XMLStreamException {
        if (sPrefix != null && sPrefix.length() > 0 && sNamespaceURI != null && sNamespaceURI.length() > 0) {
            this.mxmlWriter.writeNamespace(sPrefix, sNamespaceURI);
        }
    }

    public void addNamespace(QName qName) throws XMLStreamException {
        if (qName != null) {
            String sPrefix = qName.getPrefix();
            String sNamespaceURI = qName.getNamespaceURI();
            if (sPrefix != null && sPrefix.length() > 0 && sNamespaceURI != null && sNamespaceURI.length() > 0) {
                this.mxmlWriter.writeNamespace(sPrefix, sNamespaceURI);
            }
        }
    }

    public void elementStart(String sTagName) throws XMLStreamException {
        if (sTagName != null && sTagName.length() > 0) {
            this.mxmlWriter.writeStartElement(sTagName);
            if (this.mbUseNameStack) {
                QName qTagName = QNameFactory.newInstance(sTagName);
                this.stackPush(qTagName);
            }
        }
    }

    public void elementStart(QName qName) throws XMLStreamException {
        String sLocalName;
        if (qName != null && (sLocalName = qName.getLocalPart()) != null && sLocalName.length() > 0) {
            if (qName.getNamespaceURI() == null || qName.getNamespaceURI().length() == 0) {
                this.mxmlWriter.writeStartElement(qName.getLocalPart());
            } else if (qName.getPrefix() == null || qName.getPrefix().length() == 0) {
                this.mxmlWriter.writeStartElement(qName.getNamespaceURI(), qName.getLocalPart());
            } else {
                this.mxmlWriter.writeStartElement(qName.getPrefix(), qName.getLocalPart(), qName.getNamespaceURI());
            }
            if (this.mbUseNameStack) {
                this.stackPush(qName);
            }
        }
    }

    public void addAttribute(String sName, String sValue) throws XMLStreamException {
        if (sName != null && sName.length() > 0 && sValue != null) {
            this.mxmlWriter.writeAttribute(sName, sValue);
        }
    }

    public void addAttribute(String sName, int nValue) throws XMLStreamException {
        this.addAttribute(sName, Integer.toString(nValue));
    }

    public void addText(String sText) throws XMLStreamException {
        if (sText != null && sText.length() > 0) {
            this.mxmlWriter.writeCharacters(sText);
        }
    }

    public void addTextMarkup(String sText) throws XMLStreamException {
        if (sText != null && sText.length() > 0) {
            this.elementStart(SPECIAL_MARKUP_NAME);
            this.addCDATA(sText);
            this.elementEnd(SPECIAL_MARKUP_NAME);
        }
    }

    public void elementEnd(String sTagName) throws XMLStreamException {
        this.mxmlWriter.writeEndElement();
        if (this.mbUseNameStack) {
            QName qTagName = QNameFactory.newInstance(sTagName);
            QName qNameFromStack = this.stackPop();
            this.checkTagNames(qTagName, qNameFromStack);
        }
    }

    public void elementEnd(QName qTagName) throws XMLStreamException {
        this.mxmlWriter.writeEndElement();
        if (this.mbUseNameStack) {
            QName qNameFromStack = this.stackPop();
            this.checkTagNames(qTagName, qNameFromStack);
        }
    }

    public void elementEnd() throws XMLStreamException {
        this.mxmlWriter.writeEndElement();
        if (this.mbUseNameStack) {
            this.stackPop();
        }
    }

    public String getElementName() throws XMLStreamException {
        QName qName = this.getElementQName();
        if (qName == null) {
            return null;
        }
        return qName.getLocalPart();
    }

    public QName getElementQName() throws XMLStreamException {
        QName qName = this.stackPeek();
        return qName;
    }

    public void addSimpleElement(String sName, String sValue) throws XMLStreamException {
        this.elementStart(sName);
        this.addText(sValue);
        this.elementEnd(sName);
    }

    public void addSimpleElement(String sName, int nValue) throws XMLStreamException {
        this.addSimpleElement(sName, Integer.toString(nValue));
    }

    public void addEmptyElement(String sName) throws XMLStreamException {
        this.elementStart(sName);
        this.elementEnd(sName);
    }

    public void addCDATA(String sInput) throws XMLStreamException {
        if (sInput == null || sInput.length() == 0) {
            return;
        }
        this.mxmlWriter.writeCData(sInput);
    }

    public static String removeTextMarkup(String sSource) {
        return StaxBurner.removeTextMarkup(sSource, false);
    }

    public static String removeTextMarkup(String sSource, boolean bRemoveXMLEscaping) {
        if (sSource == null) {
            return null;
        }
        StringBuilder sbResult = new StringBuilder();
        String sRemainder = sSource;
        int nStartMarkup = sRemainder.indexOf(SPECIAL_MARKUP_WITH_CDATA_START);
        while (nStartMarkup >= 0) {
            int nStartContent = nStartMarkup + SPECIAL_MARKUP_WITH_CDATA_START.length();
            int nEndContent = sRemainder.indexOf(SPECIAL_MARKUP_WITH_CDATA_END);
            if (nStartMarkup > 0) {
                sbResult.append(sRemainder.substring(0, nStartMarkup));
            }
            if (nEndContent < 0) {
                sbResult.append(sRemainder.substring(nStartContent));
                sRemainder = "";
            } else {
                String sContent = sRemainder.substring(nStartContent, nEndContent);
                if (bRemoveXMLEscaping) {
                    sContent = StringUtils.replaceMarkup(sContent);
                }
                sbResult.append(sContent);
                int nEndTag = nEndContent + SPECIAL_MARKUP_WITH_CDATA_END.length();
                sRemainder = nEndTag < sRemainder.length() ? sRemainder.substring(nEndTag) : "";
            }
            nStartMarkup = sRemainder.indexOf(SPECIAL_MARKUP_WITH_CDATA_START);
        }
        if (sRemainder.length() > 0) {
            sbResult.append(sRemainder);
        }
        return sbResult.toString();
    }

    public static String asString(XMLRecorderStreamWriter writer) {
        String sResults;
        try {
            XMLString xmlString = new XMLString(writer.toXMLStreamReader());
            sResults = xmlString.toString();
        }
        catch (XMLStreamException e) {
            sResults = "";
        }
        return sResults;
    }

    protected void checkTagNames(QName qExpectedName, QName qNameFromStack) throws XMLStreamException {
        if (!this.mbUseNameStack) {
            return;
        }
        if (qExpectedName == null && qNameFromStack == null) {
            return;
        }
        if (qExpectedName == null || qNameFromStack == null || !qExpectedName.equals(qNameFromStack)) {
            String sMessage = null;
            sMessage = qExpectedName == null ? "Non-Empty Atom Stack: " + qNameFromStack.toString() + STR_DOT : (qNameFromStack == null ? "Expected from Atom Stack: '" + qExpectedName.toString() + STR_DOT : "Atom Stack mismatch. Expected '" + qExpectedName.toString() + "' but got '" + qNameFromStack.toString() + STR_DOT);
            this.reportTagNameError(sMessage);
        }
    }

    protected QName stackPop() {
        QName qNameFromStack;
        if (!this.mbUseNameStack) {
            return null;
        }
        try {
            qNameFromStack = this.mnameStack.pop();
        }
        catch (Exception e) {
            qNameFromStack = null;
        }
        return qNameFromStack;
    }

    protected QName stackPeek() {
        if (!this.mbUseNameStack) {
            return null;
        }
        QName qNameAtTopOfStack = null;
        try {
            if (!this.mnameStack.empty()) {
                qNameAtTopOfStack = this.mnameStack.peek();
            }
        }
        catch (Exception e) {
            qNameAtTopOfStack = null;
        }
        return qNameAtTopOfStack;
    }

    protected void stackPush(QName qName) {
        if (!this.mbUseNameStack) {
            return;
        }
        if (qName == null || qName.getLocalPart() == null || qName.getLocalPart().length() == 0) {
            return;
        }
        this.mnameStack.push(qName);
    }

    protected void reportTagNameError(String sMessage) throws XMLStreamException {
        if (this.mbThrowExceptionOnNameError) {
            throw new XMLStreamException(sMessage);
        }
    }

    public void errorMessage(String sTitle, String sSummary) throws XMLStreamException {
        String sError = sTitle;
        if (sSummary != null && sSummary.length() > 0) {
            sError = sError + ": " + sSummary;
        }
        this.elementStart("div");
        this.mxmlWriter.writeCharacters(sError);
        this.elementEnd("div");
        this.mxmlWriter.close();
    }
}

