/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen;

import com.cognos.mfw4j.utilities.ThreadSafeDateFormat;
import com.cognos.xqe.util.LocaleConverter;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class StringUtils {
    private static final String STR_LT = "&lt;";
    private static final String STR_GT = "&gt;";
    private static final String STR_AMP = "&amp;";
    private static final String STR_APOS = "&apos;";
    private static final String STR_QUOT = "&quot;";
    private static final String STR_TAB = "&tab;";
    private static final String STR_EQUALS = "=";
    private static final String STR_START_TAG = "<";
    private static final String STR_END_TAG = ">";
    private static final String STR_AMP_TAG = "&";
    private static final String STR_QUOTE_TAG = "'";
    private static final String STR_SLASH_TAG = "\"";
    private static final String STR_TAB_TAG = "\t";
    protected static final ThreadSafeDateFormat ZULU = new ThreadSafeDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public static double getDouble(String sSrc, double dDefault) {
        if (sSrc == null || sSrc.length() == 0) {
            return dDefault;
        }
        double dValue = dDefault;
        try {
            dValue = new Double(sSrc.trim());
        }
        catch (NumberFormatException e) {
            dValue = dDefault;
        }
        return dValue;
    }

    public static int getInt(String sSrc, int nDefault) {
        int nValue;
        if (sSrc == null || sSrc.length() == 0) {
            return nDefault;
        }
        try {
            nValue = new Integer(sSrc);
        }
        catch (Exception e) {
            nValue = nDefault;
        }
        return nValue;
    }

    public static boolean getBoolean(String sSrc, boolean bDefault) {
        boolean bValue;
        if (sSrc == null || sSrc.length() == 0) {
            return bDefault;
        }
        try {
            bValue = Boolean.valueOf(sSrc);
        }
        catch (Exception e) {
            bValue = bDefault;
        }
        return bValue;
    }

    public static String getString(String sSrc, String sDefault) {
        if (sSrc == null || sSrc.length() == 0) {
            return sDefault;
        }
        return sSrc;
    }

    public static String intToString(int nSrc) {
        try {
            return Integer.toString(nSrc);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String getCookieValueFromString(String sSrc, String sName) {
        int nPosName = sSrc.indexOf(sName + STR_EQUALS);
        if (nPosName >= 0) {
            int nPosValue = nPosName + sName.length() + 1;
            int nPosEnd = sSrc.indexOf(59, nPosValue);
            if (nPosEnd > 0) {
                return sSrc.substring(nPosValue, nPosEnd);
            }
            return sSrc.substring(nPosValue);
        }
        return null;
    }

    public static String escapeMarkup(String sSrc) {
        char[] sFind = new char[]{'<', '>', '&', '\'', '\"', '\t'};
        String[] sReplace = new String[]{STR_LT, STR_GT, STR_AMP, STR_APOS, STR_QUOT, STR_TAB};
        StringBuilder sResult = new StringBuilder();
        for (int i = 0; i < sSrc.length(); ++i) {
            char ch = sSrc.charAt(i);
            boolean bMatch = false;
            for (int j = 0; j < sFind.length; ++j) {
                if (sFind[j] != ch) continue;
                sResult.append(sReplace[j]);
                bMatch = true;
                break;
            }
            if (bMatch) continue;
            sResult.append(ch);
        }
        return sResult.toString();
    }

    public static String replaceMarkup(String sSrc) {
        String[] saFind = new String[]{STR_LT, STR_GT, STR_AMP, STR_APOS, STR_QUOT, STR_TAB};
        String[] saReplace = new String[]{STR_START_TAG, STR_END_TAG, STR_AMP_TAG, STR_QUOTE_TAG, STR_SLASH_TAG, STR_TAB_TAG};
        String sResult = sSrc;
        for (int i = 0; i < saFind.length; ++i) {
            sResult = StringUtils.stringReplaceAll(sResult, saFind[i], saReplace[i]);
        }
        return sResult;
    }

    public static String replaceMarkupEX(String sSrc) {
        String[] saFind = new String[]{STR_LT, STR_GT, STR_AMP, STR_APOS, STR_QUOT, STR_TAB, "%20", "%3d"};
        String[] saReplace = new String[]{STR_START_TAG, STR_END_TAG, STR_AMP_TAG, STR_QUOTE_TAG, STR_SLASH_TAG, STR_TAB_TAG, " ", STR_EQUALS};
        String sResult = sSrc;
        for (int i = 0; i < saFind.length; ++i) {
            sResult = StringUtils.stringReplaceAll(sResult, saFind[i], saReplace[i]);
        }
        return sResult;
    }

    public static String stringReplaceAll(String sSrc, String sSearch, String sReplace) {
        int nPos;
        String sResult = sSrc;
        int nSearchSize = sSearch.length();
        while ((nPos = sResult.indexOf(sSearch)) >= 0) {
            sResult = sResult.substring(0, nPos) + sReplace + sResult.substring(nPos + nSearchSize);
        }
        return sResult;
    }

    public static char firstChar(String s) {
        if (s == null || s.length() == 0) {
            return '\u0000';
        }
        return s.charAt(0);
    }

    public static char firstCharLower(String s) {
        return Character.toLowerCase(StringUtils.firstChar(s));
    }

    public static int stringDiff(String sSrc1, String sSrc2) {
        if (sSrc1 == null || sSrc2 == null) {
            return 0;
        }
        int nLen1 = sSrc1.length();
        int nLen2 = sSrc2.length();
        for (int i = 0; i < nLen1 && i < nLen2; ++i) {
            if (sSrc1.charAt(i) == sSrc2.charAt(i)) continue;
            return i;
        }
        return nLen1;
    }

    public static int indexOneOf(String sSrc, int nOffset, String sFindOneOf) {
        try {
            for (int i = nOffset; i < sSrc.length(); ++i) {
                char c = sSrc.charAt(i);
                if (sFindOneOf.indexOf(c) == -1) continue;
                return i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return -1;
    }

    public static int indexBackwardOneOf(String sSrc, int nOffset, String sFindOneOf) {
        try {
            for (int i = nOffset; i >= 0; --i) {
                char c = sSrc.charAt(i);
                if (sFindOneOf.indexOf(c) == -1) continue;
                return i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return -1;
    }

    public static int skipToChar(String sSrc, int nOffset, String sChars) {
        if (sSrc == null || nOffset < 0 || nOffset >= sSrc.length() || sChars == null) {
            return -1;
        }
        try {
            for (int i = nOffset; i < sSrc.length(); ++i) {
                char c = sSrc.charAt(i);
                if (sChars.indexOf(c) == -1) continue;
                return i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return -1;
    }

    public static int skipBackwardToChar(String sSrc, int nOffset, String sChars) {
        if (sSrc == null || nOffset < 0 || nOffset >= sSrc.length() || sChars == null) {
            return -1;
        }
        try {
            for (int i = nOffset; i >= 0; --i) {
                char c = sSrc.charAt(i);
                if (sChars.indexOf(c) == -1) continue;
                return i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return -1;
    }

    public static String getStringBetween(String sSrc, String sStart, String sEnd) {
        if (sSrc == null || sSrc.length() == 0) {
            return null;
        }
        int idxStart = sSrc.indexOf(sStart);
        if (idxStart == -1) {
            return null;
        }
        int idxEnd = sSrc.indexOf(sEnd, idxStart += sStart.length());
        if (idxEnd == -1) {
            return null;
        }
        if (idxEnd < idxStart) {
            return null;
        }
        return sSrc.substring(idxStart, idxEnd);
    }

    public static Locale parseLocale(String compactLocale) {
        if (compactLocale == null || compactLocale.length() == 0) {
            return null;
        }
        int pos = compactLocale.indexOf(95);
        if (pos == -1) {
            pos = compactLocale.indexOf(45);
        }
        String lang = null;
        lang = pos == -1 ? compactLocale : compactLocale.substring(0, pos);
        String country = null;
        country = pos == -1 ? "" : compactLocale.substring(pos + 1);
        return new Locale(lang, country);
    }

    public static String getISOLanguageCode(String sLocale) {
        Locale locale = StringUtils.parseLocale(sLocale);
        if (locale == null) {
            return null;
        }
        return LocaleConverter.getLanguage(locale);
    }

    public static String getISOCountryCode(String sLocale) {
        Locale locale = StringUtils.parseLocale(sLocale);
        if (locale == null) {
            return null;
        }
        return locale.getCountry();
    }

    public static boolean findStringInArray(String sSrc, String[] asStrings) {
        if (sSrc == null || asStrings.length == 0) {
            return false;
        }
        for (int i = 0; i < asStrings.length; ++i) {
            if (!sSrc.equals(asStrings[i])) continue;
            return true;
        }
        return false;
    }

    public static String formatDateAsZulu(Date date) {
        String formattedDate = ZULU.format(date);
        return formattedDate;
    }

    public static Date parseDateFromZuluFormat(String formattedDate) throws ParseException {
        return ZULU.parse(formattedDate);
    }

    static {
        ZULU.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

