/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.fragmentproducer.jest;

import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqebifw.adminconsole.fragmentproducer.c8.C8GlobalVars;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class TemplatePage {
    public static final String BACK_DIR = "../";
    public static final String JEST_CONTENT_TAG = "jest:content";
    public static final String JEST_STRING_TAG = "jest:string";
    public static final String JEST_ID_ATTRIBUTE = "id";
    protected String msBaseDirectory = null;
    protected Locale mlocale = Locale.getDefault();
    protected String msPage = null;
    protected Vector<ResourceBundle> mvBundles = new Vector();
    private static String startTag = "<";
    private static String endTag = ">";

    public String getPage() {
        return this.msPage;
    }

    public void setPage(String sPage) {
        this.msPage = sPage;
    }

    public void addResourceBundle(ResourceBundle bundle) {
        this.mvBundles.add(bundle);
    }

    public void setBaseDirectory(String sBaseDirectory) {
        String path = "/";
        String baseDirectory = sBaseDirectory;
        if (baseDirectory != null && baseDirectory.length() != 0 && !(baseDirectory = baseDirectory.replaceAll("\\\\", path)).endsWith(path)) {
            baseDirectory = baseDirectory + path;
        }
        this.msBaseDirectory = baseDirectory;
    }

    public void setLocale(Locale locale) {
        this.mlocale = locale;
    }

    public void loadTemplate(String sPath) throws IOException {
        String sInputLine;
        String sRelativeFilePath = null;
        sRelativeFilePath = this.msBaseDirectory != null ? this.msBaseDirectory + sPath : "" + sPath;
        File fh = new File(sRelativeFilePath);
        fh = new File(fh.getCanonicalPath());
        FileReader fileReader = new FileReader(fh);
        BufferedReader in = new BufferedReader(fileReader);
        StringBuilder sbResult = new StringBuilder();
        while ((sInputLine = in.readLine()) != null) {
            sbResult.append(sInputLine);
        }
        in.close();
        fileReader.close();
        this.msPage = sbResult.toString();
    }

    public int replaceTag(String sTagName, String sId, String sNewContent) {
        int nTagEnd;
        if (sNewContent == null) {
            sNewContent = "";
        }
        int nReplacements = 0;
        int nLastPosn = 0;
        int nCurrentPosn = 0;
        StringBuilder sbResult = new StringBuilder();
        int nTagStart = this.findStartTagInPage(sTagName, sId, nCurrentPosn);
        while (nTagStart != -1 && (nTagEnd = this.findEndTagInPage(sTagName, nTagStart)) != -1) {
            ++nReplacements;
            sbResult.append(this.msPage.substring(nLastPosn, nTagStart));
            sbResult.append(sNewContent);
            nLastPosn = nTagEnd;
            nCurrentPosn = nTagEnd;
            nTagStart = this.findStartTagInPage(sTagName, sId, nCurrentPosn);
        }
        if (nReplacements > 0) {
            if (nLastPosn < this.msPage.length()) {
                sbResult.append(this.msPage.substring(nLastPosn));
            }
            this.msPage = sbResult.toString();
        }
        return nReplacements;
    }

    public int replaceResourceStrings() {
        return this.replaceResourceStrings(false);
    }

    public int replaceResourceStrings(boolean decorate) {
        int nTagEnd;
        if (this.mvBundles == null) {
            return 0;
        }
        int nReplacements = 0;
        int nLastPosn = 0;
        int nCurrentPosn = 0;
        StringBuilder sbResult = new StringBuilder();
        int nTagStart = this.findStartTagInPage(JEST_STRING_TAG, null, nCurrentPosn);
        while (nTagStart != -1 && (nTagEnd = this.findEndTagInPage(JEST_STRING_TAG, nTagStart)) != -1) {
            String sNewContent;
            String sId = this.getAttributeWithinTag(JEST_ID_ATTRIBUTE, nTagStart);
            if (sId != null && sId.length() > 0 && (sNewContent = this.getResourceString(sId, decorate)) != null && sNewContent.length() > 0) {
                ++nReplacements;
                sbResult.append(this.msPage.substring(nLastPosn, nTagStart));
                sbResult.append(sNewContent);
                nLastPosn = nTagEnd;
            }
            nCurrentPosn = nTagEnd;
            nTagStart = this.findStartTagInPage(JEST_STRING_TAG, null, nCurrentPosn);
        }
        if (nReplacements > 0) {
            if (nLastPosn < this.msPage.length()) {
                sbResult.append(this.msPage.substring(nLastPosn));
            }
            this.msPage = sbResult.toString();
        }
        return nReplacements;
    }

    public void removeAllTags() {
        this.msPage = TemplatePage.removeAllTags(this.msPage);
    }

    public static String removeAllTags(String sourceText) {
        if (sourceText == null || sourceText.length() == 0) {
            return "";
        }
        Field[] fields = TemplatePage.class.getFields();
        if (fields == null || fields.length == 0) {
            return "";
        }
        TemplatePage dummy = new TemplatePage();
        dummy.msPage = sourceText;
        for (int f = 0; f < fields.length; ++f) {
            String name = fields[f].getName();
            if (!name.startsWith("JEST_") || !name.endsWith("_TAG")) continue;
            try {
                String value = (String)fields[f].get(null);
                dummy.replaceTag(value, null, "");
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return dummy.toString();
    }

    public String toString() {
        return this.msPage;
    }

    protected int findStartTagInPage(String sTagName, String sId, int nCurrentPosn) {
        if (this.msPage == null || sTagName == null || sTagName.length() == 0 || nCurrentPosn < 0) {
            return -1;
        }
        String sStartTag = startTag + sTagName;
        int nStart = this.msPage.indexOf(sStartTag, nCurrentPosn);
        while (nStart != -1) {
            String sIdValue;
            int nNextChar = nStart + sStartTag.length();
            if (nNextChar >= this.msPage.length() - 1) {
                nStart = -1;
                break;
            }
            char ch = this.msPage.charAt(nNextChar);
            if ((ch == '/' || ch == '>' || Character.isWhitespace(ch)) && (sId == null || sId.length() == 0 || (sIdValue = this.getAttributeWithinTag(JEST_ID_ATTRIBUTE, nStart)) != null && sIdValue.equals(sId))) break;
            nStart = this.msPage.indexOf(sStartTag, nNextChar);
        }
        if (nStart == -1) {
            return -1;
        }
        return nStart;
    }

    protected int findEndTagInPage(String sTagName, int nCurrentPosn) {
        if (this.msPage == null || sTagName == null || sTagName.length() == 0 || nCurrentPosn < 0) {
            return -1;
        }
        int nEndSingleTag = this.findSingleTagEndingTag(sTagName, nCurrentPosn);
        if (nEndSingleTag != -1) {
            return nEndSingleTag;
        }
        String sEndTag = "</" + sTagName + endTag;
        int nStart = this.msPage.indexOf(sEndTag, nCurrentPosn);
        if (nStart == -1) {
            return -1;
        }
        return nStart + sEndTag.length();
    }

    private int findSingleTagEndingTag(String sTagName, int nCurrentPosn) {
        String tagName = sTagName.substring(0, sTagName.length() - 1);
        String sSingleTag = startTag + tagName;
        int nStart = this.msPage.indexOf(sSingleTag, nCurrentPosn);
        if (nStart != nCurrentPosn) {
            return -1;
        }
        int maxLen = this.msPage.length();
        int limitPos = maxLen - 2;
        for (int pos = nStart + sSingleTag.length(); pos < limitPos; ++pos) {
            char ch = this.msPage.charAt(pos);
            if (ch == '/' && pos < maxLen - 1) {
                if ((ch = this.msPage.charAt(++pos)) != '>') continue;
                return ++pos;
            }
            if (ch != '<' && ch != '>') continue;
            return -1;
        }
        return -1;
    }

    protected String getAttributeWithinTag(String sName, int nTagStartPosn) {
        try {
            int nPosValue;
            char cQuote;
            int nPosEndValue;
            int nPosName = this.msPage.indexOf(sName + "=", nTagStartPosn);
            int nPosEndTag = this.msPage.indexOf(endTag, nTagStartPosn);
            if (nPosName >= 0 && nPosName < nPosEndTag && (nPosEndValue = this.msPage.indexOf(cQuote = this.msPage.charAt(nPosValue = nPosName + sName.length() + 1), nPosValue + 1)) >= nPosValue + 2) {
                return this.msPage.substring(nPosValue + 1, nPosEndValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    protected String getResourceString(String sId, boolean decorate) {
        String sResult = null;
        Iterator<ResourceBundle> iBundles = this.mvBundles.iterator();
        while (iBundles.hasNext() && sResult == null) {
            try {
                ResourceBundle bundle = iBundles.next();
                sResult = bundle.getString(sId);
                if (!decorate) continue;
                Locale bundleLocale = bundle.getLocale();
                sResult = sResult + " - " + LocaleConverter.toString(bundleLocale);
            }
            catch (Exception e) {
                sResult = null;
            }
        }
        return sResult;
    }

    public static String getSystemTemplateBaseDirectory(String qsatTemplatePath) {
        String templatePath = null;
        templatePath = qsatTemplatePath == null ? C8GlobalVars.resolveEffectivePath("../webcontent/fragments/V5QueryService") : C8GlobalVars.resolveEffectivePath(BACK_DIR + qsatTemplatePath);
        return templatePath;
    }
}

