/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.fragmentproducer.registration;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.autoregistration.IAutoRegistrationPlugin;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqebifw.adminconsole.fragmentproducer.registration.AdminConsoleContentManagerAddCommand;
import com.cognos.xqebifw.adminconsole.fragmentproducer.registration.MLString;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration.StringResources;
import com.cognos.xqebifw.management.XqeJMXURLHolder;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.dom4j.Element;

public class AdminConsoleAutoRegistration
implements IAutoRegistrationPlugin {
    private static final String PAGELET_SEARCH_PATH = "/portal/portalPackage[@name='Administration']/pageletFolder[@name='Pagelets']/pageletFolder[@name='Console']/pageletFolder[@name='Configuration']";
    private static final String LOCALE_EN = "en";
    static final String V5QS_SEARCH_PATH = "/portal/portalPackage[@name='Administration']/pageletFolder[@name='Pagelets']/pageletFolder[@name='Console']";
    static final String V5QS_PORTLET_SEARCH_PATH = "/portal/portalPackage[@name='Administration']/portletFolder[@name='Portlets']/portletProducer[@name='V5QueryService']/portlet[@name='V5QueryService']";

    public boolean execute(ServiceLogger serviceLogger) {
        boolean success = true;
        try {
            String pageletSearchPath = this.addPagelet(PAGELET_SEARCH_PATH, "XQE_UI_xqePortletName", "icon_query_service_caching.gif");
            this.addPorletInstance(pageletSearchPath, V5QS_PORTLET_SEARCH_PATH);
        }
        catch (SoapFaultException e) {
            serviceLogger.error("Unable to add folder to CM. SOAPFault, " + e.getMessage() + " -- " + e.getDetail(), (Throwable)e);
            success = false;
        }
        catch (CommandExecutionException e) {
            serviceLogger.error("Unable to add folder to CM. " + e.getMessage(), (Throwable)e);
            success = false;
        }
        return success;
    }

    protected MLString createMLString(String strID) {
        Map supportedLocales;
        MLString mlString = new MLString();
        try {
            ICCLConfiguration config = CCLConfigurationFactory.getInstance();
            if (config == null) {
                config = CCLConfigurationFactory.createConfiguration();
                config.init();
            }
            supportedLocales = config.getProductLocaleList(null);
        }
        catch (CCLConfigurationException e) {
            throw new RuntimeException(e.getMessage());
        }
        Set localKeys = supportedLocales.keySet();
        for (Object key : localKeys) {
            Locale locale = new Locale((String)key);
            String localizedValue = StringResources.getString(locale, strID, null);
            mlString.add(localizedValue, LocaleConverter.getLanguage(locale));
        }
        return mlString;
    }

    protected String executeCommand(AdminConsoleContentManagerAddCommand addCmd) throws CommandExecutionException {
        addCmd.execute();
        String searchPath = addCmd.getResponseSearchPath();
        return searchPath;
    }

    protected AdminConsoleContentManagerAddCommand createCommand(String parentSearchPath) {
        AdminConsoleContentManagerAddCommand addCmd = new AdminConsoleContentManagerAddCommand();
        addCmd.setSearch(parentSearchPath);
        addCmd.setUpdateAction("update");
        addCmd.setDoTrustedRequest(true, "CPS");
        return addCmd;
    }

    public String addPageletFolder(String parentSearchPath, String objName) throws CommandExecutionException {
        AdminConsoleContentManagerAddCommand addCmd = this.createCommand(parentSearchPath);
        Element currentObject = addCmd.addObject("pageletFolder");
        MLString name = new MLString();
        name.add(objName, LOCALE_EN);
        addCmd.setName(currentObject, name);
        addCmd.setDisabled(currentObject, false);
        String searchPath = this.executeCommand(addCmd);
        return searchPath;
    }

    public String addPagelet(String parentSearchPath, String objName, String iconName) throws CommandExecutionException {
        AdminConsoleContentManagerAddCommand addCmd = this.createCommand(parentSearchPath);
        Element currentObject = addCmd.addObject("pagelet");
        MLString name = this.createMLString(objName);
        addCmd.setName(currentObject, name);
        addCmd.setDisabled(currentObject, false);
        String layout = "<layout version=\"1\"><portletOptions hideBorders=\"true\" hideTitleBars=\"true\" hideEditMode=\"true\"/><column width=\"100\"><portlet id=\"content\"/></column></layout>";
        addCmd.setLayout(currentObject, layout);
        addCmd.setIconURI(currentObject, iconName);
        String metadata = "<meta><requiredCapabilities>canUseQueryServiceTool</requiredCapabilities></meta>";
        addCmd.setMetadata(currentObject, metadata);
        String searchPath = this.executeCommand(addCmd);
        return searchPath;
    }

    public String addPorletInstance(String parentSearchPath, String portletSearchPath) throws CommandExecutionException {
        AdminConsoleContentManagerAddCommand addCmd = this.createCommand(parentSearchPath);
        Element currentObject = addCmd.addObject("portletInstance");
        addCmd.setDefaultName(currentObject, "content");
        addCmd.setDisabled(currentObject, false);
        addCmd.setPortlet(currentObject, portletSearchPath);
        String searchPath = this.executeCommand(addCmd);
        return searchPath;
    }

    public static void addXqeJMXMBean() {
        try {
            XqeJMXURLHolder xqeJmx = new XqeJMXURLHolder();
            ObjectName obName = new ObjectName("com.cognos:type=config,service=XqeJMXConfigMBean");
            PogoMBeanServer.getInstance().getServer().registerMBean(xqeJmx, obName);
            PogoMBeanServer.getInstance().getProxyMBeanServer().registerMBean(xqeJmx, obName);
        }
        catch (MBeanException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException(e);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new RuntimeException(e);
        }
    }
}

