/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration;

import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqebifw.adminconsole.fragmentproducer.messages.Message;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class StringResources {
    private static Locale glLocale;
    private static String gsResourceName;
    private static HashMap<Locale, ResourceBundle> ghResources;
    private static boolean languageDecorator;

    public static String getGsResourceName() {
        return gsResourceName;
    }

    public static synchronized void setLocale(String lang, String cn) {
        StringResources.setLocale(new Locale(lang, cn));
    }

    public static synchronized void setLocale(Locale locale) {
        glLocale = locale;
        if (!ghResources.containsKey(glLocale)) {
            ResourceBundle rb = StringResources.getResourceBundle(gsResourceName, glLocale);
            ghResources.put(glLocale, rb);
        }
    }

    public static String getString(Locale locale, String key, Object[] params) {
        try {
            ResourceBundle rb = StringResources.getResourceBundle(gsResourceName, locale);
            String str = rb.getString(key);
            if (params != null) {
                str = new MessageFormat(str).format(params);
            }
            if (languageDecorator) {
                str = "(" + LocaleConverter.toString(rb.getLocale()) + ") " + str;
            }
            return str;
        }
        catch (Exception e) {
            return "(Id: " + key + ", Locale: " + locale + ")";
        }
    }

    public static String getString(Locale locale, Message message) {
        return StringResources.getString(locale, message.getId(), message.getParameters());
    }

    public static ResourceBundle getResourceBundle(String sResourceName, Locale locale) {
        ResourceBundle r;
        try {
            r = ResourceBundle.getBundle(gsResourceName, locale);
        }
        catch (Exception e) {
            if (e.getMessage() == null) {
                throw new RuntimeException("NullPointerException");
            }
            throw new RuntimeException(e.getMessage());
        }
        return r;
    }

    static {
        gsResourceName = "xqejavamsgs";
        ghResources = new HashMap();
        StringResources.setLocale(Locale.getDefault());
    }
}

