/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control;

import com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen.HtmlBurner;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration.Action;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control.Control;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class CheckBoxControl
implements Control {
    protected String name;
    protected String value = "";
    protected boolean checked;
    protected String classType;
    protected int width = 0;
    protected String vAlign;
    protected String hAlign = this.vAlign = "right";
    protected String style;
    protected List<Action> actions = new ArrayList<Action>();
    protected boolean enabled = true;

    public CheckBoxControl(String nm, boolean chked) {
        this.name = nm;
        this.checked = chked;
    }

    public CheckBoxControl(String nm, String val, boolean chked) {
        this.name = nm;
        this.value = val;
        this.checked = chked;
    }

    public void setName(String nm) {
        this.name = nm;
    }

    public void setValue(String val) {
        this.value = val;
    }

    public String getName() {
        return this.name;
    }

    public void setChecked(boolean chked) {
        this.checked = chked;
    }

    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public void draw(HtmlBurner burner) throws XMLStreamException {
        burner.elementStart("input");
        burner.addAttribute("name", this.name);
        burner.addAttribute("value", this.value);
        burner.addAttribute("title", this.value);
        burner.addAttribute("type", "checkbox");
        burner.addAttribute("halign", "center");
        burner.addAttribute("valign", "center");
        burner.addAttribute("align", "center");
        for (Action action : this.actions) {
            burner.addAttribute(action.getActionName(), action.getOperation());
        }
        if (this.checked) {
            burner.addAttribute("checked", "checked");
        }
        if (!this.enabled) {
            burner.addAttribute("disabled", "true");
        }
        burner.elementEnd("input");
    }

    public String getClassType() {
        return this.classType;
    }

    public void setClassType(String cType) {
        this.classType = cType;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int wdth) {
        this.width = wdth;
    }

    public String getVAlign() {
        return this.vAlign;
    }

    public void setVAlign(String align) {
        this.vAlign = align;
    }

    public String getHAlign() {
        return this.hAlign;
    }

    public void setHAlign(String align) {
        this.hAlign = align;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String stle) {
        this.style = stle;
    }

    public void addAction(String actionName, String operation) {
        Action action = new Action(actionName, operation);
        this.addAction(action);
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public void setEnabled(boolean enbld) {
        this.enabled = enbld;
    }
}

