/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control;

import com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen.HtmlBurner;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control.Control;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control.ControlHelper;
import com.cognos.xqebifw.adminconsole.server.AbstractXqeUIBean;
import com.cognos.xqebifw.adminconsole.server.XqeConfigEnum;
import com.cognos.xqebifw.adminconsole.server.XqeConfigurationElementBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class CommonPropertyTableEditorControl
implements Control {
    private static final String EMPTY_STRING = "";
    private static final String JAVASCRIPT_HIDEANDSHOW = "javascript:hideAndShow(document.getElementById('_THIS_pform'), '";
    private static final String ROWID = "ROWID";
    private static final String STR_CURLY_CLOSING_BRACE = "}";
    private static final String STR_CLOSING_BRACE = ")";
    private static final String STR_UNDERSCORE = "_";
    private static final String STR_SINGLE_QUOTE = "'";
    private static final int INT_HUNDRED = 100;
    private static final int INT_FIFTY = 50;
    private static final String STR_ZERO = "0";
    private static final String STR_ONE = "1";
    private static final String STR_TWO = "2";
    private static final String STR_TEN = "10";
    private static final String STR_FIFTEEN = "15";
    protected String elementNameStartsWith = null;
    protected final boolean isModifiable;
    protected List<String> columnHeaders = new ArrayList<String>();
    protected List<String> types = new ArrayList<String>();
    public static final String EDIT_BOX = "editBox";
    public static final String DDLIST = "dropDownList";
    public static final String LABEL = "label";
    public static final String ACTION = "action";
    public static final String OTHER = "other";
    protected List<? extends AbstractXqeUIBean> data = null;

    public CommonPropertyTableEditorControl(List<? extends AbstractXqeUIBean> dt, boolean modifiable, String nameStartsWith) {
        this.isModifiable = modifiable;
        this.elementNameStartsWith = nameStartsWith;
        this.data = dt;
    }

    public void addColumnHeader(String headerName, String type) {
        this.columnHeaders.add(headerName);
        this.types.add(type);
    }

    @Override
    public void draw(HtmlBurner burner) throws XMLStreamException {
        burner.elementStart("table");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ONE);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("width", "100%");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("valign", "top");
        burner.addAttribute("width", "100%");
        burner.addAttribute("colspan", STR_TWO);
        burner.addEmptyElement("div");
        burner.elementStart("table");
        burner.addAttribute("width", "100%");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("cellpadding", STR_TWO);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("class", "cogstyle-table");
        burner.elementStart("thead");
        burner.addAttribute("id", "Header");
        burner.elementStart("tr");
        burner.addAttribute("class", "dialogHeader");
        burner.elementStart("td");
        burner.addAttribute("height", STR_FIFTEEN);
        burner.addAttribute("width", STR_ONE);
        burner.elementStart("table");
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("border", STR_ZERO);
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("class", "tableHeaderDivider");
        burner.elementStart("img");
        burner.addAttribute("width", STR_ONE);
        burner.addAttribute("height", STR_FIFTEEN);
        burner.addAttribute("src", "$WEB$/ps/images/space.gif");
        burner.addAttribute("alt", EMPTY_STRING);
        burner.elementEnd("img");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        burner.elementEnd("td");
        int width = 100 / this.columnHeaders.size();
        for (int i = 0; i < this.columnHeaders.size(); ++i) {
            String columnHeader = this.columnHeaders.get(i);
            burner.elementStart("td");
            burner.addAttribute("height", STR_TEN);
            burner.addAttribute("class", "dialogHeader");
            burner.addAttribute("style", "padding-left:2px;padding-top:2px;");
            burner.addAttribute("width", width + "%");
            burner.addAttribute("valign", "center");
            burner.addAttribute("halign", "left");
            ControlHelper.addLocalizedString(burner, columnHeader);
            burner.elementEnd("td");
            if (i + 1 >= this.columnHeaders.size()) continue;
            burner.elementStart("td");
            burner.addAttribute("height", STR_FIFTEEN);
            burner.addAttribute("width", STR_ONE);
            burner.elementStart("table");
            burner.addAttribute("cellpadding", STR_ZERO);
            burner.addAttribute("cellspacing", STR_ZERO);
            burner.addAttribute("border", STR_ZERO);
            burner.elementStart("tr");
            burner.elementStart("td");
            burner.addAttribute("class", "tableHeaderDivider");
            burner.elementStart("img");
            burner.addAttribute("width", STR_ONE);
            burner.addAttribute("height", STR_FIFTEEN);
            burner.addAttribute("src", "$WEB$/ps/images/space.gif");
            burner.elementEnd("img");
            burner.elementEnd("td");
            burner.elementEnd("tr");
            burner.elementEnd("table");
        }
        burner.elementEnd("tr");
        burner.elementEnd("thead");
        burner.elementStart("tbody");
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", "xqeMetric_resetfield");
        burner.addAttribute("value", EMPTY_STRING);
        burner.elementEnd("input");
        int rowIndex = 1;
        if (this.data != null) {
            Iterator<? extends AbstractXqeUIBean> iter = this.data.iterator();
            AbstractXqeUIBean bean = null;
            while (iter.hasNext()) {
                bean = iter.next();
                this.drawTableEntry(burner, bean, rowIndex++);
            }
        }
        burner.elementEnd("tbody");
        burner.elementStart("tfoot");
        burner.addAttribute("id", "Footer");
        burner.elementEnd("tfoot");
        burner.elementEnd("table");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
    }

    private void drawTableEntry(HtmlBurner burner, AbstractXqeUIBean bean, int rowIndex) throws XMLStreamException {
        XqeConfigurationElementBean bn;
        String rowId = this.elementNameStartsWith + STR_UNDERSCORE + bean.getName() + STR_UNDERSCORE + ROWID;
        burner.elementStart("tr");
        burner.addAttribute("name", rowId);
        burner.addAttribute("id", rowId);
        if (this.elementNameStartsWith.equals("xqeConfiguration") && (bn = (XqeConfigurationElementBean)((XqeConfigurationElementBean)bean).getMDependingParent()) != null) {
            if (!bn.getValue().toString().equals(bn.getDependentValue())) {
                burner.addAttribute("style", "display:none");
            } else {
                burner.addAttribute("style", "display");
            }
        }
        burner.elementStart("td");
        burner.addAttribute("height", STR_FIFTEEN);
        burner.addAttribute("width", STR_ONE);
        burner.elementEnd("td");
        for (int colIndex = 0; colIndex < this.columnHeaders.size(); ++colIndex) {
            burner.elementStart("td");
            burner.addAttribute("height", STR_TEN);
            String textName = bean.getName();
            String textLabel = bean.getLabel();
            String textValue = bean.getValue().toString();
            String controlType = this.types.get(colIndex);
            String identifierName = this.elementNameStartsWith + STR_UNDERSCORE + textName;
            if (LABEL.equals(controlType)) {
                burner.addAttribute("class", "portlet-form-field-label");
                burner.addAttribute("style", "padding-left:2px;padding-top:2px;");
                burner.addAttribute("width", "50%");
                burner.addAttribute("valign", "center");
                if (colIndex == 0) {
                    ControlHelper.addLocalizedString(burner, textLabel);
                } else {
                    ControlHelper.addLocalizedString(burner, textValue);
                }
            } else if (ACTION.equals(controlType)) {
                burner.addAttribute("class", "portlet-form-field-label");
                burner.addAttribute("style", "padding-left:2px;padding-top:2px;");
                burner.addAttribute("align", "left");
                burner.addAttribute("class", "tableText");
                burner.addAttribute("width", "2%");
                burner.addAttribute("nowrap", "true");
                burner.elementStart("a");
                textName = STR_SINGLE_QUOTE + textName + STR_SINGLE_QUOTE;
                String addRowStr = "javascript:resetadminform(document.getElementById('_THIS_pform'), " + textName + STR_CLOSING_BRACE;
                burner.addAttribute("href", addRowStr);
                ControlHelper.addLocalizedString(burner, "XQE_ADMIN_UI_xqeMetricResetTitle");
                burner.elementEnd("a");
            } else if (OTHER.equals(controlType)) {
                List<XqeConfigEnum> enums = bean.getEnumerations();
                if (enums != null && enums.size() > 0) {
                    burner.addAttribute("class", "portlet-form-input-field");
                    this.addDropDownList(burner, identifierName, enums, textValue, bean);
                } else {
                    this.addEditBox(burner, identifierName, textValue, bean);
                }
            }
            burner.elementEnd("td");
            if (colIndex + 1 >= this.columnHeaders.size()) continue;
            burner.elementStart("td");
            burner.addAttribute("height", STR_FIFTEEN);
            burner.addAttribute("width", STR_ONE);
            burner.elementEnd("td");
        }
        burner.elementEnd("tr");
    }

    private void addEditBox(HtmlBurner burner, String identifierName, String textValue, AbstractXqeUIBean bean) throws XMLStreamException {
        boolean isNumberOnly = false;
        if (bean instanceof XqeConfigurationElementBean && ((XqeConfigurationElementBean)bean).getType().equals((Object)XqeConfigurationElementBean.XqeConfigurationElementType.Numeric)) {
            isNumberOnly = true;
        }
        burner.elementStart("input");
        if (identifierName.toLowerCase().indexOf("pwd") >= 0) {
            burner.addAttribute("type", "password");
        } else {
            burner.addAttribute("type", "text");
        }
        burner.addAttribute("class", "formText");
        burner.addAttribute("style", "width:95%");
        burner.addAttribute("name", identifierName);
        if (textValue.trim().equals(EMPTY_STRING)) {
            burner.addAttribute("value", "**********");
        } else {
            burner.addAttribute("value", textValue);
        }
        if (isNumberOnly) {
            burner.addAttribute("onKeyPress", "return allowNumbersOnly(this, event)");
        }
        burner.elementEnd("input");
    }

    private void addDropDownList(HtmlBurner burner, String identifierName, List<XqeConfigEnum> enumValue, String active, AbstractXqeUIBean bean) throws XMLStreamException {
        String onChangeEvent = EMPTY_STRING;
        String dependentValue = EMPTY_STRING;
        String s = null;
        String dependentRowId = EMPTY_STRING;
        Set<Object> dependents = ((XqeConfigurationElementBean)bean).getMDependentChildren();
        Object var11_11 = null;
        for (XqeConfigurationElementBean xqeConfigurationElementBean : dependents) {
            dependentValue = xqeConfigurationElementBean.getDependentValue();
            dependentRowId = this.elementNameStartsWith + STR_UNDERSCORE + xqeConfigurationElementBean.getName() + STR_UNDERSCORE + ROWID;
            onChangeEvent = onChangeEvent + "if (this.options[this.selectedIndex].title=='" + dependentValue + STR_SINGLE_QUOTE + STR_CLOSING_BRACE;
            onChangeEvent = onChangeEvent + "{" + this.elementNameStartsWith + STR_UNDERSCORE + xqeConfigurationElementBean.getName() + ".disabled=false;" + JAVASCRIPT_HIDEANDSHOW + dependentRowId + "', 'show');" + STR_CURLY_CLOSING_BRACE;
            onChangeEvent = onChangeEvent + " else{";
            if (xqeConfigurationElementBean.getType().equals((Object)XqeConfigurationElementBean.XqeConfigurationElementType.Enumeration)) {
                s = this.elementNameStartsWith + STR_UNDERSCORE + xqeConfigurationElementBean.getName();
                onChangeEvent = onChangeEvent + "for ( var i = 0; i < " + s + ".options.length; i++ ) {if ( " + s + ".options[i].title == '" + xqeConfigurationElementBean.getValue().toString() + "'){" + s + ".options[i].selected = true;break;" + STR_CURLY_CLOSING_BRACE + STR_CURLY_CLOSING_BRACE;
            } else {
                String depChildValue = xqeConfigurationElementBean.getValue().toString();
                onChangeEvent = depChildValue == null || depChildValue.trim().equals(EMPTY_STRING) ? onChangeEvent + this.elementNameStartsWith + STR_UNDERSCORE + xqeConfigurationElementBean.getName() + ".value='';" : onChangeEvent + this.elementNameStartsWith + STR_UNDERSCORE + xqeConfigurationElementBean.getName() + ".value='" + depChildValue + "';";
            }
            onChangeEvent = onChangeEvent + this.elementNameStartsWith + STR_UNDERSCORE + xqeConfigurationElementBean.getName() + ".disabled=true;";
            onChangeEvent = onChangeEvent + JAVASCRIPT_HIDEANDSHOW + dependentRowId + "', 'hide');";
            onChangeEvent = onChangeEvent + STR_CURLY_CLOSING_BRACE;
        }
        burner.elementStart("select");
        burner.addAttribute("name", identifierName);
        burner.addAttribute("class", "formText");
        burner.addAttribute("style", "width:95%");
        burner.addAttribute("onchange", onChangeEvent);
        XqeConfigurationElementBean bn = (XqeConfigurationElementBean)((XqeConfigurationElementBean)bean).getMDependingParent();
        if (bn != null && !bn.getValue().toString().equals(bn.getDependentValue())) {
            burner.addAttribute("disabled", "true");
        }
        for (int i = 0; i < enumValue.size(); ++i) {
            XqeConfigEnum entry = enumValue.get(i);
            String value = entry.getValue();
            String displayName = entry.getDisplayName();
            burner.elementStart("option");
            burner.addAttribute("value", displayName);
            burner.addAttribute("title", value);
            if (value.equals(active)) {
                burner.addAttribute("selected", EMPTY_STRING);
            }
            ControlHelper.addLocalizedString(burner, displayName);
            burner.elementEnd("option");
        }
        burner.elementEnd("select");
    }

    public class DropDownListEntry {
        protected final String value;
        protected final String text;

        public DropDownListEntry(String val) {
            this(val, val);
        }

        public DropDownListEntry(String val, String txt) {
            this.value = val;
            this.text = txt;
        }

        public String getValue() {
            return this.value;
        }

        public String getText() {
            return this.text;
        }
    }
}

