/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control;

import com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen.HtmlBurner;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration.Action;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control.Control;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.page.Page;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class DropdownList
implements Control {
    protected final String name;
    protected List<Page> items = new ArrayList<Page>();
    protected Page selectedPage = null;
    protected List<Action> actions = new ArrayList<Action>();
    boolean disabled = false;
    protected String classType;
    protected String vAlign = "center";
    protected String hAlign = "left";

    public DropdownList(String nm) {
        this.name = nm;
    }

    @Override
    public void draw(HtmlBurner burner) throws XMLStreamException {
        burner.elementStart("select");
        burner.addAttribute("name", this.name);
        burner.addAttribute("id", this.name);
        for (Action action : this.actions) {
            burner.addAttribute(action.getActionName(), action.getOperation());
        }
        if (this.disabled) {
            burner.addAttribute("disabled", "true");
        }
        for (Page page : this.items) {
            burner.elementStart("option");
            burner.addAttribute("id", page.getHref());
            burner.addAttribute("value", page.getValue());
            burner.addAttribute("title", page.getTitle());
            if (page.equals(this.selectedPage)) {
                burner.addAttribute("selected", "");
            }
            burner.addText(page.getTitle());
            burner.elementEnd("option");
        }
    }

    public void setDisabled(boolean dsbld) {
        this.disabled = dsbld;
    }

    public void setSelected(Page page) {
        this.selectedPage = page;
    }

    public void setSelected(int pos) {
        this.selectedPage = this.items.get(pos);
    }

    public Page getSelected() {
        return this.selectedPage;
    }

    public void addAction(String actionName, String operation) {
        Action action = new Action(actionName, operation);
        this.addAction(action);
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public void add(Page page) {
        this.items.add(page);
    }

    public String getClassType() {
        return this.classType;
    }

    public void setClassType(String cType) {
        this.classType = cType;
    }

    public String getVAlign() {
        return this.vAlign;
    }

    public void setVAlign(String align) {
        this.vAlign = align;
    }

    public String getHAlign() {
        return this.hAlign;
    }

    public void setHAlign(String align) {
        this.hAlign = align;
    }
}

