/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.fragmentproducer.ui.page;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen.HtmlBurner;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration.Parameter;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration.RequestContext;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control.CheckBoxControl;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control.ControlHelper;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control.DropdownList;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.page.Page;
import com.cognos.xqebifw.adminconsole.fragmentproducer.utilities.Utils;
import com.cognos.xqebifw.adminconsole.qsat.server.OptionsXMLProcessor;
import com.cognos.xqebifw.adminconsole.server.JmxUtils;
import com.cognos.xqebifw.adminconsole.server.QueryServerGroupCMCommand;
import com.cognos.xqebifw.management.XqeRESTAdminOperations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class SecuredAccessLayerPage
extends Page {
    private static final String MSG_FAILURE = "Failed";
    private static final String MSG_SUCCESS = "Succeeded";
    private static final String COMMA = ", ";
    private Set<String> commandFailedForServerGroups = new HashSet<String>();
    private String lastCommandExecuted = "";
    private static final String EMPTY_STRING = " ";
    private String mode = "display";
    private static final int INT_TEN = 10;
    private static final int INT_ONE = 1;
    private static final int INT_HUNDRED = 100;
    private static final String STR_SIXTEEN = "16";
    private static final String STR_TWO = "2";
    private static final String STR_ASTRIK = "*";
    public static final String DEFAULT_SERVER_GROUP = "Default Server Group";
    private Map<String, String> dispatcherToServerGroupMap = null;
    private Map<String, String> dispatcherDefaultnameToDispatcherPathMap = null;
    private List<String> selectedServerGroupsFormFieldNames = new ArrayList<String>();
    private List<String> selectedServerGroups = new ArrayList<String>();
    private static final String ALL_DISPATCHER_XPATH = "/configuration/descendant::dispatcher";
    private static final String XQE_SERVERGROUP_CHECKBOX = "xqe_servergroup_checkbox";
    protected List<String> columnHeaders = new ArrayList<String>();
    protected List<String> responseColumnHeaders = new ArrayList<String>();
    private static final int INT_FIFTY = 50;
    private static final String STR_TEN = "10";
    private static final String STR_FIFTEEN = "15";
    private static final String STR_ZERO = "0";
    private static final String STR_ELEVEN = "11";
    private static final String STR_ONE = "1";
    public static final String ID = "xqeSecuredAccessLayer";
    public static final String LABEL = "label";
    public static final String CHECKBOX = "checkbox";
    public static final String EDIT_BOX = "editBox";
    public static final String ACTION = "action";
    public static final String COLUMN_ID_PREFIX = "col";
    XQELogger errorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static final String ERR_MSG_MESSAGE = "ERROR: Message is ";
    String[] serverGroups = null;
    private static final String ERR_MSG_SALPAGE_SERVERGROUPS_LOAD = "ERROR: Failure while loading list of server groups on SecuredAccessLayerPage ";
    protected RequestContext context;
    DropdownList ddlist = null;
    String activePage = null;

    public SecuredAccessLayerPage(RequestContext ctxt, String title, String href, String md) {
        super(title, href);
        this.mode = md;
        if (this.mode.equals("flush")) {
            this.lastCommandExecuted = "Clear cache";
        } else if (this.mode.equals("dump")) {
            this.lastCommandExecuted = "Write cache state";
        }
        try {
            QueryServerGroupCMCommand command = new QueryServerGroupCMCommand(ALL_DISPATCHER_XPATH);
            command.setDoTrustedRequest(true);
            command.execute();
            this.dispatcherToServerGroupMap = command.getDispatcherDefaultNameToServerGroupMap();
            this.dispatcherDefaultnameToDispatcherPathMap = command.getDispatcherDefaultNameToPathMap();
        }
        catch (Exception e) {
            this.errorLogger.log(ERR_MSG_SALPAGE_SERVERGROUPS_LOAD);
            if (e.getMessage() == null) {
                this.errorLogger.log("ERROR: Message is NullPointerException");
            }
            this.errorLogger.log(ERR_MSG_MESSAGE + e.getMessage());
        }
        this.context = ctxt;
        List<Parameter> params = this.context.getRequestParameters();
        for (Parameter param : params) {
            if (param.getName().indexOf(XQE_SERVERGROUP_CHECKBOX) < 0 || param.getName().indexOf("HIDDEN") >= 0) continue;
            this.selectedServerGroupsFormFieldNames.add(param.getName() + "HIDDEN");
        }
        params = null;
        for (String serverGroupCheckBoxFormField : this.selectedServerGroupsFormFieldNames) {
            this.selectedServerGroups.add(this.context.getParameter(serverGroupCheckBoxFormField));
        }
        String tempDispatcherPath = null;
        if (this.selectedServerGroups != null && this.selectedServerGroups.size() > 0) {
            for (String serverGroup : this.selectedServerGroups) {
                Set<String> dispatcherNames = this.getDispatchersUnderServerGroup(serverGroup);
                Set<String> currentActiveDispatcherPaths = JmxUtils.getDispatcherNames();
                for (String dispatcherName : dispatcherNames) {
                    tempDispatcherPath = this.dispatcherDefaultnameToDispatcherPathMap.get(dispatcherName);
                    if (!currentActiveDispatcherPaths.contains(tempDispatcherPath)) continue;
                    String camPassport = this.context.getCAMPassport();
                    if (this.mode.equals("flush")) {
                        if (XqeRESTAdminOperations.flush(dispatcherName, camPassport, STR_ASTRIK, STR_ASTRIK, STR_ASTRIK)) continue;
                        this.commandFailedForServerGroups.add(serverGroup);
                        continue;
                    }
                    if (!this.mode.equals("dump") || XqeRESTAdminOperations.dump(dispatcherName, camPassport, STR_ASTRIK, STR_ASTRIK, STR_ASTRIK)) continue;
                    this.commandFailedForServerGroups.add(serverGroup);
                }
            }
        }
        this.columnHeaders.add("XQE_UI_xqeSALServerGroupColumnHeader");
        this.responseColumnHeaders.add("XQE_UI_xqeSALCommandColumnHeader");
        this.responseColumnHeaders.add("XQE_UI_xqeSALStatusColumnHeader");
        this.responseColumnHeaders.add("XQE_UI_xqeSALMessageColumnHeader");
    }

    @Override
    public void draw(HtmlBurner burner) throws XMLStreamException {
        boolean serverGroupsLoadSucceeded = false;
        this.drawTitleBar(burner);
        this.setPageID(burner, ID);
        if (this.mode.equals("flush") || this.mode.equals("dump")) {
            this.addVerticalSpace(burner);
            this.drawResponseDialog(burner);
        } else {
            this.setPageHeader(burner, "XQE_UI_xqeSALHeaderText");
            this.addVerticalSpace(burner);
            serverGroupsLoadSucceeded = this.loadServerGroups(burner);
            if (serverGroupsLoadSucceeded) {
                this.drawTable(burner, this.serverGroups);
                this.addVerticalSpace(burner);
                this.drawActions(burner);
            }
        }
    }

    @Override
    public String getStateParameters() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("page=").append(ID);
        return buffer.toString();
    }

    private void addVerticalSpace(HtmlBurner burner) throws XMLStreamException {
        burner.elementStart("table");
        burner.addAttribute("width", "100%");
        burner.addAttribute("height", STR_ELEVEN);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("role", "presentation");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addEmptyElement("br");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
    }

    private boolean loadServerGroups(HtmlBurner burner) throws XMLStreamException {
        try {
            this.serverGroups = null;
            Set<String> serverGroupSet = this.getServerGroups();
            this.serverGroups = serverGroupSet.toArray(new String[0]);
            Arrays.sort(this.serverGroups);
            return true;
        }
        catch (Exception e) {
            this.errorLogger.log(ERR_MSG_SALPAGE_SERVERGROUPS_LOAD);
            if (e.getMessage() == null) {
                this.errorLogger.log("ERROR: Message is NullPointerException");
            } else {
                this.errorLogger.log(ERR_MSG_MESSAGE + e.getMessage());
            }
            burner.errorMessage(ERR_MSG_SALPAGE_SERVERGROUPS_LOAD, e.getMessage());
            return false;
        }
    }

    private void drawTable(HtmlBurner burner, String[] sg) throws XMLStreamException {
        int col = 0;
        this.addVerticalSpace(burner);
        burner.elementStart("table");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ONE);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("width", "100%");
        burner.addAttribute("role", "presentation");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("valign", "top");
        burner.addAttribute("width", "100%");
        burner.addAttribute("colspan", STR_TWO);
        burner.addEmptyElement("div");
        burner.elementStart("table");
        burner.addAttribute("width", "100%");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("cellpadding", STR_TWO);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("class", "cogstyle-xqe-table");
        burner.addAttribute("summary", XQEMessages.getMessage(XQEMessageKeys.UI_xqeSALHeaderText, this.context.getProductLocale()));
        burner.elementStart("thead");
        burner.addAttribute("id", "Header");
        burner.elementStart("tr");
        burner.addAttribute("class", "dialogHeader");
        burner.elementStart("th");
        burner.addAttribute("height", STR_TEN);
        burner.addAttribute("class", "dialogHeader");
        burner.addAttribute("style", "padding-left:2px;padding-top:2px;");
        burner.addAttribute("width", STR_SIXTEEN);
        burner.addAttribute("valign", "center");
        burner.addAttribute("id", COLUMN_ID_PREFIX + col++);
        burner.elementStart("input");
        burner.addAttribute("type", CHECKBOX);
        burner.addAttribute("id", "control_checkbox");
        burner.addAttribute("title", XQEMessages.getMessage(XQEMessageKeys.UI_xqeROLAPQSATSelectAllCubes, this.context.getProductLocale()));
        burner.addAttribute("onclick", "toggleChecks(document._THIS_pform, 'xqe_servergroup_checkbox', checked)");
        burner.elementEnd("input");
        burner.elementEnd("th");
        burner.elementStart("th");
        burner.addAttribute("height", STR_FIFTEEN);
        burner.addAttribute("width", STR_ONE);
        burner.addAttribute("class", "dialogHeader");
        burner.addAttribute("id", COLUMN_ID_PREFIX + col++);
        burner.elementStart("table");
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("role", "presentation");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("class", "tableHeaderDivider");
        burner.elementStart("img");
        burner.addAttribute("width", STR_ONE);
        burner.addAttribute("height", STR_FIFTEEN);
        burner.addAttribute("src", "$WEB$/ps/images/space.gif");
        burner.addAttribute("alt", "");
        burner.elementEnd("img");
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("height", STR_FIFTEEN);
        burner.addAttribute("width", STR_ONE);
        ControlHelper.addSpace(burner, 1, 10);
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("class", "tableHeaderDivider");
        burner.elementStart("img");
        burner.addAttribute("width", STR_ONE);
        burner.addAttribute("height", STR_FIFTEEN);
        burner.addAttribute("src", "$WEB$/ps/images/space.gif");
        burner.addAttribute("alt", "");
        burner.elementEnd("img");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        burner.elementEnd("th");
        int width = 100 / this.columnHeaders.size();
        for (int i = 0; i < this.columnHeaders.size(); ++i) {
            String columnHeader = this.columnHeaders.get(i);
            burner.elementStart("th");
            burner.addAttribute("height", STR_TEN);
            burner.addAttribute("class", "dialogHeader");
            burner.addAttribute("style", "padding-left:2px;padding-top:2px;");
            burner.addAttribute("style", "text-align:left");
            burner.addAttribute("width", width + "%");
            burner.addAttribute("id", COLUMN_ID_PREFIX + col++);
            ControlHelper.addLocalizedString(burner, columnHeader);
            burner.elementEnd("th");
            if (i + 1 >= this.columnHeaders.size()) continue;
            burner.elementStart("th");
            burner.addAttribute("height", STR_FIFTEEN);
            burner.addAttribute("width", STR_ONE);
            burner.elementStart("table");
            burner.addAttribute("cellpadding", STR_ZERO);
            burner.addAttribute("cellspacing", STR_ZERO);
            burner.addAttribute("border", STR_ZERO);
            burner.addAttribute("role", "presentation");
            burner.elementStart("tr");
            burner.elementStart("td");
            burner.addAttribute("class", "tableHeaderDivider");
            burner.elementStart("img");
            burner.addAttribute("width", STR_ONE);
            burner.addAttribute("height", STR_FIFTEEN);
            burner.addAttribute("src", "$WEB$/ps/images/space.gif");
            burner.addAttribute("alt", "");
            burner.elementEnd("img");
            burner.elementEnd("td");
            burner.elementEnd("tr");
            burner.elementEnd("table");
            burner.elementEnd("th");
        }
        burner.elementStart("th");
        burner.addAttribute("height", STR_TEN);
        burner.addAttribute("class", "dialogHeader");
        burner.addAttribute("style", "padding-left:2px;padding-top:2px;");
        burner.addAttribute("width", STR_SIXTEEN);
        burner.addAttribute("valign", "center");
        burner.addAttribute("id", COLUMN_ID_PREFIX + col++);
        ControlHelper.addLocalizedString(burner, "");
        burner.elementEnd("th");
        burner.elementEnd("tr");
        burner.elementEnd("thead");
        burner.elementStart("tbody");
        if (sg != null) {
            String groupName = null;
            for (int i = 0; i < sg.length; ++i) {
                groupName = sg[i];
                this.drawTableEntry(burner, groupName, i + 1, this.containsOnlyDefaultServerGroup(groupName, sg));
            }
        } else {
            this.drawEmptyMessage(burner);
        }
        burner.elementEnd("tbody");
        burner.elementStart("tfoot");
        burner.addAttribute("id", "Footer");
        burner.elementEnd("tfoot");
        burner.elementEnd("table");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
    }

    private void drawTableEntry(HtmlBurner burner, String bean, int rowIndex, boolean setChecked) throws XMLStreamException {
        boolean isChecked = false;
        int col = 0;
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("height", STR_TEN);
        burner.addAttribute("class", "tableText");
        burner.addAttribute("halign", "right");
        burner.addAttribute("valign", "right");
        burner.addAttribute("align", "right");
        burner.addAttribute("headers", COLUMN_ID_PREFIX + col++);
        for (String selectedServerGroupName : this.selectedServerGroups) {
            if (!selectedServerGroupName.equals(bean)) continue;
            isChecked = true;
            break;
        }
        if (setChecked && !isChecked) {
            isChecked = true;
        }
        CheckBoxControl checkBox = new CheckBoxControl(XQE_SERVERGROUP_CHECKBOX + rowIndex, OptionsXMLProcessor.xmlEncode(bean), isChecked);
        checkBox.setEnabled(true);
        checkBox.draw(burner);
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("height", STR_TEN);
        burner.addAttribute("width", STR_SIXTEEN);
        burner.addAttribute("valign", "center");
        burner.addAttribute("headers", COLUMN_ID_PREFIX + col++);
        burner.elementStart("img");
        burner.addAttribute("src", "$WEB$/ps/cogadmin/images/icon_server_group.gif");
        burner.addAttribute("alt", bean);
        burner.elementEnd("img");
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("height", STR_TEN);
        burner.addAttribute("class", "portlet-form-field");
        burner.addAttribute("style", "padding-left:2px;padding-top:2px;");
        burner.addAttribute("width", "50%");
        burner.addAttribute("valign", "left");
        burner.addAttribute("halign", "left");
        burner.addAttribute("headers", COLUMN_ID_PREFIX + col++);
        if (bean.equalsIgnoreCase(DEFAULT_SERVER_GROUP)) {
            ControlHelper.addLocalizedString(burner, "XQE_UI_xqeSALDefaultServerGroup");
        } else {
            ControlHelper.addLocalizedString(burner, bean);
        }
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("headers", COLUMN_ID_PREFIX + col++);
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", XQE_SERVERGROUP_CHECKBOX + rowIndex + "HIDDEN");
        burner.addAttribute("value", bean);
        burner.elementEnd("input");
        burner.elementEnd("td");
        burner.elementEnd("tr");
    }

    private void drawActions(HtmlBurner burner) throws XMLStreamException {
        burner.elementStart("table");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("role", "presentation");
        burner.addAttribute("width", "100%");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("width", "90%");
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("align", "right");
        burner.addAttribute("class", "portlet-form-field");
        burner.addAttribute("nowrap", "true");
        burner.elementStart("a");
        String addRowStr = this.getJSFunctionScript("flushadminform");
        burner.addAttribute("href", addRowStr);
        ControlHelper.addLocalizedString(burner, "XQE_UI_xqeClearCacheLink");
        burner.elementEnd("a");
        burner.elementEnd("td");
        ControlHelper.addSpace(burner, 1, 10);
        burner.elementStart("td");
        burner.addAttribute("align", "right");
        burner.addAttribute("class", "portlet-form-field");
        burner.addAttribute("nowrap", "true");
        burner.elementStart("a");
        addRowStr = this.getJSFunctionScript("dumpadminform");
        burner.addAttribute("href", addRowStr);
        ControlHelper.addLocalizedString(burner, "XQE_UI_xqeWriteCacheStateLink");
        burner.elementEnd("a");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
    }

    private String getJSFunctionScript(String functionName) {
        String alertMsg = Utils.javascriptencode(XQEMessages.getMessage(XQEMessageKeys.UI_xqeCubeMsgChooseCacheEntry, LocaleConverter.strToLocale(this.context.getProductLocale().toString())));
        return "javascript:" + functionName + "(document.getElementById('_THIS_pform'),'" + alertMsg + "')";
    }

    private Set<String> getServerGroups() {
        HashSet<String> sgs = new HashSet<String>();
        Set<String> dispPaths = this.dispatcherToServerGroupMap.keySet();
        for (String dispPath : dispPaths) {
            sgs.add(this.dispatcherToServerGroupMap.get(dispPath));
        }
        return sgs;
    }

    private Set<String> getDispatchersUnderServerGroup(String sg) {
        HashSet<String> associatedDispatchers = new HashSet<String>();
        Set<String> allDispatchers = this.dispatcherToServerGroupMap.keySet();
        String sgMappedToDispatcher = null;
        for (String dispatcher : allDispatchers) {
            sgMappedToDispatcher = this.dispatcherToServerGroupMap.get(dispatcher);
            if (!sgMappedToDispatcher.equalsIgnoreCase(sg)) continue;
            associatedDispatchers.add(dispatcher);
        }
        return associatedDispatchers;
    }

    private boolean containsOnlyDefaultServerGroup(String currentSg, String[] sgArray) {
        return sgArray.length == 1 && currentSg.equalsIgnoreCase(DEFAULT_SERVER_GROUP);
    }

    private void drawEmptyMessage(HtmlBurner burner) throws XMLStreamException {
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("height", STR_TEN);
        burner.addAttribute("class", "tableText");
        burner.addAttribute("halign", "right");
        burner.addAttribute("valign", "right");
        burner.addAttribute("align", "right");
        ControlHelper.addLocalizedString(burner, "");
        this.addVerticalSpace(burner);
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("height", STR_FIFTEEN);
        burner.addAttribute("width", STR_ONE);
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("height", STR_TEN);
        burner.addAttribute("width", STR_SIXTEEN);
        burner.addAttribute("valign", "center");
        ControlHelper.addLocalizedString(burner, "");
        this.addVerticalSpace(burner);
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("height", STR_TEN);
        burner.addAttribute("class", "portlet-form-field-label");
        burner.addAttribute("style", "padding-left:2px;padding-top:2px;");
        burner.addAttribute("width", "50%");
        burner.addAttribute("valign", "center");
        burner.addAttribute("halign", "center");
        ControlHelper.addLocalizedString(burner, "");
        this.addVerticalSpace(burner);
        burner.elementEnd("td");
        burner.elementStart("td");
        ControlHelper.addLocalizedString(burner, "");
        this.addVerticalSpace(burner);
        burner.elementEnd("td");
        burner.elementEnd("tr");
    }

    private void drawResponseDialog(HtmlBurner burner) throws XMLStreamException {
        this.addVerticalSpace(burner);
        burner.elementStart("table");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ONE);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("role", "presentation");
        burner.addAttribute("width", "100%");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("valign", "top");
        burner.addAttribute("width", "100%");
        burner.addAttribute("colspan", STR_TWO);
        burner.addEmptyElement("div");
        burner.elementStart("table");
        burner.addAttribute("width", "100%");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("cellpadding", STR_TWO);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("class", "cogstyle-xqe-table");
        burner.elementStart("thead");
        burner.addAttribute("id", "Header2");
        burner.elementStart("tr");
        burner.addAttribute("class", "dialogHeader");
        burner.elementStart("td");
        burner.addAttribute("class", "dialogHeader");
        burner.addAttribute("height", STR_FIFTEEN);
        burner.addAttribute("width", STR_ONE);
        ControlHelper.addLocalizedString(burner, EMPTY_STRING);
        ControlHelper.addLocalizedString(burner, EMPTY_STRING);
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("height", STR_FIFTEEN);
        burner.addAttribute("width", STR_ONE);
        burner.addAttribute("class", "dialogHeader");
        burner.elementStart("table");
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("role", "presentation");
        burner.elementStart("tr");
        burner.elementStart("td");
        ControlHelper.addSpace(burner, 1, 10);
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("class", "tableHeaderDivider");
        burner.elementStart("img");
        burner.addAttribute("width", STR_ONE);
        burner.addAttribute("height", STR_FIFTEEN);
        burner.addAttribute("src", "$WEB$/ps/images/space.gif");
        burner.addAttribute("alt", "");
        burner.elementEnd("img");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        burner.elementEnd("td");
        int width = 0;
        for (int i = 0; i < this.responseColumnHeaders.size(); ++i) {
            String columnHeader = this.responseColumnHeaders.get(i);
            burner.elementStart("td");
            burner.addAttribute("height", STR_TEN);
            burner.addAttribute("class", "dialogHeader");
            burner.addAttribute("style", "padding-left:2px;padding-top:2px;");
            switch (i) {
                case 0: {
                    width = 30;
                    break;
                }
                case 1: {
                    width = 5;
                    break;
                }
                case 2: {
                    width = 65;
                    break;
                }
                default: {
                    width = 33;
                }
            }
            burner.addAttribute("width", width + "%");
            ControlHelper.addLocalizedString(burner, columnHeader);
            burner.elementEnd("td");
            if (i + 1 >= this.responseColumnHeaders.size()) continue;
            burner.elementStart("td");
            burner.addAttribute("height", STR_FIFTEEN);
            burner.addAttribute("width", STR_ONE);
            burner.addAttribute("class", "dialogHeader");
            burner.elementStart("table");
            burner.addAttribute("cellpadding", STR_ZERO);
            burner.addAttribute("cellspacing", STR_ZERO);
            burner.addAttribute("border", STR_ZERO);
            burner.addAttribute("role", "presentation");
            burner.elementStart("tr");
            burner.elementStart("td");
            burner.addAttribute("class", "tableHeaderDivider");
            burner.elementStart("img");
            burner.addAttribute("width", STR_ONE);
            burner.addAttribute("height", STR_FIFTEEN);
            burner.addAttribute("src", "$WEB$/ps/images/space.gif");
            burner.addAttribute("alt", "");
            burner.elementEnd("img");
            burner.elementEnd("td");
            burner.elementEnd("tr");
            burner.elementEnd("table");
            burner.elementEnd("td");
        }
        burner.elementStart("td");
        burner.addAttribute("height", STR_TEN);
        burner.addAttribute("class", "dialogHeader");
        burner.addAttribute("style", "padding-left:2px;padding-top:2px;");
        burner.addAttribute("width", STR_SIXTEEN);
        burner.addAttribute("valign", "center");
        ControlHelper.addLocalizedString(burner, "");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("thead");
        burner.elementStart("tbody");
        if (this.commandFailedForServerGroups != null && this.commandFailedForServerGroups.size() > 0) {
            String commaSeparatedListOfErrServergroups = "";
            for (String erroneousServerGroup : this.commandFailedForServerGroups) {
                commaSeparatedListOfErrServergroups = commaSeparatedListOfErrServergroups + erroneousServerGroup + COMMA;
            }
            if (commaSeparatedListOfErrServergroups.endsWith(COMMA)) {
                int lastIndex = commaSeparatedListOfErrServergroups.lastIndexOf(COMMA);
                commaSeparatedListOfErrServergroups = commaSeparatedListOfErrServergroups.substring(0, lastIndex);
            }
            this.drawCommandResponse(burner, this.lastCommandExecuted, MSG_FAILURE, commaSeparatedListOfErrServergroups);
        } else {
            this.drawCommandResponse(burner, this.lastCommandExecuted, MSG_SUCCESS, "");
        }
        burner.elementEnd("tbody");
        burner.elementStart("tfoot");
        burner.addAttribute("id", "Footer");
        burner.elementEnd("tfoot");
        burner.elementEnd("table");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        this.addVerticalSpace(burner);
        this.addVerticalSpace(burner);
        burner.elementStart("div");
        burner.addAttribute("class", "cogstyle-dialog-commandbar");
        burner.elementStart("table");
        burner.addAttribute("cellspacing", 0);
        burner.addAttribute("cellpadding", 0);
        burner.addAttribute("width", "100%");
        burner.addAttribute("border", 0);
        burner.elementStart("tbody");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("align", "left");
        burner.elementStart("button");
        burner.addAttribute("type", "button");
        burner.addAttribute("width", "73");
        burner.addAttribute("height", "18");
        burner.addAttribute("class", "cogstyle-dialog-button");
        burner.addAttribute("onclick", "javascript:performClose(document.getElementById('_THIS_pform'))");
        ControlHelper.addLocalizedString(burner, "XQE_UI_xqeCloseButtonCaption");
        burner.elementEnd("button");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("tbody");
        burner.elementEnd("table");
        burner.elementEnd("div");
    }

    private void drawCommandResponse(HtmlBurner burner, String commandName, String status, String message) throws XMLStreamException {
        burner.elementStart("tr");
        burner.elementStart("td");
        ControlHelper.addLocalizedString(burner, EMPTY_STRING);
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("height", STR_TEN);
        burner.addAttribute("class", "tableText");
        burner.addAttribute("halign", "right");
        burner.addAttribute("valign", "right");
        burner.addAttribute("align", "right");
        ControlHelper.addLocalizedString(burner, EMPTY_STRING);
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("height", STR_FIFTEEN);
        burner.addAttribute("width", STR_ONE);
        burner.elementStart("table");
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("border", STR_ZERO);
        burner.elementStart("tr");
        burner.elementStart("td");
        ControlHelper.addSpace(burner, 1, 10);
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("width", STR_ONE);
        burner.addAttribute("height", STR_FIFTEEN);
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("height", STR_TEN);
        burner.addAttribute("valign", "center");
        burner.addAttribute("halign", "center");
        if (this.lastCommandExecuted.equals("Write cache state")) {
            ControlHelper.addLocalizedString(burner, "XQE_UI_xqeWriteCacheResponse");
        } else {
            ControlHelper.addLocalizedString(burner, "XQE_UI_xqeClearCacheResponse");
        }
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("height", STR_FIFTEEN);
        burner.addAttribute("width", STR_ONE);
        burner.elementStart("table");
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("border", STR_ZERO);
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("width", STR_ONE);
        burner.addAttribute("height", STR_FIFTEEN);
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("height", STR_TEN);
        burner.addAttribute("valign", "center");
        burner.addAttribute("halign", "center");
        if (status.equals(MSG_FAILURE)) {
            ControlHelper.addLocalizedString(burner, "XQE_UI_xqeFailureResponse");
        } else {
            ControlHelper.addLocalizedString(burner, "XQE_UI_xqeSuccessResponse");
        }
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("height", STR_FIFTEEN);
        burner.addAttribute("width", STR_ONE);
        burner.elementStart("table");
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("border", STR_ZERO);
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("width", STR_ONE);
        burner.addAttribute("height", STR_FIFTEEN);
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("height", STR_TEN);
        burner.addAttribute("valign", "center");
        burner.addAttribute("halign", "center");
        if (message != null && !message.equals("")) {
            ControlHelper.addLocalizedString(burner, "XQE_UI_xqeFailureMessage");
            ControlHelper.addLocalizedString(burner, EMPTY_STRING);
        }
        ControlHelper.addLocalizedString(burner, message);
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementStart("tr");
        burner.elementStart("td");
        ControlHelper.addLocalizedString(burner, EMPTY_STRING);
        burner.elementEnd("td");
        burner.elementEnd("tr");
    }

    private void drawTitleBar(HtmlBurner burner) throws XMLStreamException {
        burner.elementStart("table");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("width", "100%");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("valign", "top");
        burner.addAttribute("width", "100%");
        burner.addAttribute("class", "cogstyle-fragmentHeader-title");
        burner.elementStart("span");
        burner.addAttribute("width", "100%");
        burner.addAttribute("class", "cogstyle-breadcrumbs-pathLeafNode");
        if (this.mode.equals("flush") || this.mode.equals("dump")) {
            ControlHelper.addLocalizedString(burner, "XQE_UI_xqeDialogResultTitleText");
        } else {
            ControlHelper.addLocalizedString(burner, "XQE_UI_xqeDialogTitleText");
        }
        burner.elementEnd("span");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
    }
}

