/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.fragmentproducer.ui.page;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen.HtmlBurner;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration.RequestContext;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control.ControlHelper;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control.DropdownList;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control.TabControl;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.page.BlankPage;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.page.LightWeightConfigCategoryPage;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.page.Page;
import com.cognos.xqebifw.adminconsole.server.XqeAdministrator;
import com.cognos.xqebifw.adminconsole.server.XqeConfigEnum;
import com.cognos.xqebifw.adminconsole.server.XqeConfigurationBean;
import com.cognos.xqebifw.adminconsole.server.XqeConfigurationCategoryBean;
import com.cognos.xqebifw.adminconsole.server.XqeConfigurationElementBean;
import com.cognos.xqebifw.adminconsole.server.XqeService;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class XqeConfigurationPage
extends Page {
    private static final String SINGLE_QUOTE = "'";
    private static final String COMMA = ",";
    private static final String EMPTY_STRING = "";
    private static final int PAGE_SIZE = 100;
    private TabControl tabControl = null;
    private static final String STR_ELEVEN = "11";
    private static final String STR_ZERO = "0";
    private static final String STR_ONE = "1";
    private static final String STR_DISP_DDL_NAME = "xqeConfiguration_dispatchers";
    public static final String ID = "xqeConfiguration";
    public static final String LABEL = "label";
    public static final String EDIT_BOX = "editBox";
    public static final String OTHER = "other";
    private static final String ERR_MSG_DISP_NAME = "ERROR: Dispatcher is ";
    private static final String ERR_MSG_MODE = "ERROR: Mode/Action is ";
    private static final String ERR_MSG_MESSAGE = "ERROR: Message is ";
    private static final String ERR_MSG_CONFIGPAGE = "ERROR: Failure occurred on XqeConfigurationPage ";
    private static final String ERR_MSG_CONFIGPAGE_CONFIG_LOAD = "ERROR: Failure while loading configuration parameters on XqeConfigurationPage ";
    private static final String ERR_MSG_CONFIGPAGE_DISP_LOAD = "ERROR: Failure while loading list of dispatchers on XqeConfigurationPage ";
    XQELogger errorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    protected RequestContext context;
    protected Map<String, Map<String, List<XqeConfigurationElementBean>>> configData = new LinkedHashMap<String, Map<String, List<XqeConfigurationElementBean>>>();
    DropdownList ddlist = null;
    String activePage = null;
    String[] dispatchers = null;

    public XqeConfigurationPage(RequestContext ctxt, String title, String href, String mode) {
        super(title, href);
        this.context = ctxt;
        String disp = null;
        try {
            XqeService service = null;
            XqeConfigurationBean configBean = null;
            disp = this.context.getParameter(STR_DISP_DDL_NAME);
            if (mode.equals("save")) {
                XQEDebugLog.out.println("save DispatcherNAAM is " + disp);
                service = XqeAdministrator.getInstance().getXqeService(disp);
                configBean = service.getConfiguration();
                this.updateSettings(configBean);
            } else if (mode.equals("reload")) {
                XQEDebugLog.out.println("RELOAD");
            }
        }
        catch (Exception e) {
            this.errorLogger.log(ERR_MSG_CONFIGPAGE);
            this.errorLogger.log(ERR_MSG_DISP_NAME + disp);
            this.errorLogger.log(ERR_MSG_MODE + mode);
            this.errorLogger.log(ERR_MSG_MESSAGE + e.getMessage());
        }
        this.tabControl = new TabControl();
    }

    @Override
    public void draw(HtmlBurner burner) throws XMLStreamException {
        boolean dispatchersLoadSucceeded = false;
        boolean configParamsLoadSucceeded = false;
        this.setPageID(burner, ID);
        this.setPageHeader(burner, "XQE_ADMIN_UI_xqeConfigurationHeaderText");
        this.addVerticalSpace(burner);
        this.addVerticalSpace(burner);
        this.addVerticalSpace(burner);
        dispatchersLoadSucceeded = this.loadDispatchers(burner);
        this.activePage = this.getActivePage();
        if (dispatchersLoadSucceeded) {
            this.drawDispatcherDropdownList(burner, this.dispatchers);
            this.addVerticalSpace(burner);
            this.addVerticalSpace(burner);
            this.addVerticalSpace(burner);
            configParamsLoadSucceeded = this.loadConfigurations(this.activePage, burner);
            if (configParamsLoadSucceeded) {
                Map<String, List<XqeConfigurationElementBean>> categoryMap = null;
                List<XqeConfigurationElementBean> categoryList = null;
                String categoryName2 = null;
                categoryMap = this.configData.get(this.activePage);
                Set<String> categorySet = categoryMap.keySet();
                for (String categoryName2 : categorySet) {
                    categoryList = categoryMap.get(categoryName2);
                    LightWeightConfigCategoryPage page = new LightWeightConfigCategoryPage(this.context, categoryName2, "javascript:changeConfigurationSubCategory(document.getElementById('_THIS_pform'),'" + categoryName2 + SINGLE_QUOTE + COMMA + SINGLE_QUOTE + this.activePage + SINGLE_QUOTE + ")", categoryName2, categoryList);
                    page.setSize(100);
                    this.tabControl.addPage(page);
                }
                List<Page> list = this.tabControl.getAllPages();
                String aPage = this.context.getParameter("configurationcategory");
                if ((aPage == null || aPage.equals(EMPTY_STRING)) && ((aPage = this.context.getParameter("xqeConfiguration_ConfigCategory")) == null || aPage.equals(EMPTY_STRING))) {
                    this.tabControl.setActivePage((LightWeightConfigCategoryPage)list.get(0));
                }
                if (aPage != null && !aPage.equals(EMPTY_STRING)) {
                    for (int i = 0; i < list.size(); ++i) {
                        LightWeightConfigCategoryPage pg = (LightWeightConfigCategoryPage)list.get(i);
                        if (!pg.getId().equals(aPage)) continue;
                        this.tabControl.setActivePage(pg);
                        break;
                    }
                }
                this.tabControl.draw(burner);
            }
        }
        this.addVerticalSpace(burner);
        this.addVerticalSpace(burner);
        this.addVerticalSpace(burner);
    }

    @Override
    public String getStateParameters() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("page=").append(ID);
        return buffer.toString();
    }

    public String getReloadParameters() {
        Page page = this.tabControl.getActivePage();
        String stateParameters = page.getStateParameters();
        return stateParameters;
    }

    public void addVerticalSpace(HtmlBurner burner) throws XMLStreamException {
        burner.elementStart("table");
        burner.addAttribute("width", "100%");
        burner.addAttribute("height", STR_ELEVEN);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("border", STR_ZERO);
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addEmptyElement("br");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
    }

    public void drawDispatcherDropdownList(HtmlBurner burner, String[] disps) throws XMLStreamException {
        burner.elementStart("table");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("width", "100%");
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("style", "padding-left:10px;");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("class", "portlet-form-field-label");
        burner.addAttribute("align", "left");
        ControlHelper.addLocalizedString(burner, "XQE_ADMIN_UI_xqeInstances");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("width", STR_ONE);
        burner.addAttribute("height", STR_ONE);
        burner.elementStart("img");
        burner.addAttribute("height", STR_ONE);
        burner.addAttribute("src", "$WEB$/ps/images/space.gif");
        burner.addAttribute("alt", EMPTY_STRING);
        burner.elementEnd("img");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementStart("tr");
        burner.elementStart("td");
        this.ddlist = this.getDropdownlist(disps);
        this.ddlist.draw(burner);
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("width", STR_ONE);
        burner.addAttribute("height", STR_ONE);
        burner.elementStart("img");
        burner.addAttribute("height", "10");
        burner.addAttribute("src", "$WEB$/ps/images/space.gif");
        burner.addAttribute("alt", EMPTY_STRING);
        burner.elementEnd("img");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
    }

    protected DropdownList getDropdownlist(String[] disps) {
        DropdownList ddlst = new DropdownList(STR_DISP_DDL_NAME);
        ddlst.addAction("onchange", "javascript:changeDispatcher(document.getElementById('_THIS_pform'))");
        boolean setSelected = false;
        for (int i = 0; i < disps.length; ++i) {
            String value = disps[i];
            BlankPage page = new BlankPage(value, value, "_THIS?page=xqeConfiguration&xqeConfiguration_dispatchers=" + value + "/THIS_");
            ddlst.add(page);
            if (this.activePage == null && !setSelected) {
                setSelected = true;
                ddlst.setSelected(page);
                continue;
            }
            if (this.activePage == null || setSelected || !this.activePage.equals(value)) continue;
            setSelected = true;
            ddlst.setSelected(page);
        }
        return ddlst;
    }

    protected String getActivePage() {
        String aPage = this.context.getParameter("dispatcher");
        if (aPage == null && (aPage = this.context.getParameter("amp;dispatcher")) == null && (aPage = this.context.getParameter("amp;xqeConfiguration_dispatchers")) == null && (aPage = this.context.getParameter(STR_DISP_DDL_NAME)) == null) {
            aPage = this.dispatchers[0];
        }
        return aPage;
    }

    public void updateSettings(XqeConfigurationBean bean) {
        List<XqeConfigurationCategoryBean> categories = bean.getCategories();
        for (XqeConfigurationCategoryBean catg : categories) {
            List<XqeConfigurationElementBean> list = catg.getConfigElements();
            String parameterName = EMPTY_STRING;
            String parameterValue = EMPTY_STRING;
            for (int i1 = 0; i1 < list.size(); ++i1) {
                XqeConfigurationElementBean element = list.get(i1);
                parameterName = "xqeConfiguration_" + element.getName();
                parameterValue = this.context.getParameter(parameterName);
                List<XqeConfigEnum> enums = element.getEnumerations();
                if (parameterValue == null) continue;
                if (enums != null && enums.size() > 0) {
                    for (int i = 0; i < enums.size(); ++i) {
                        XqeConfigEnum en = enums.get(i);
                        if (!en.getDisplayName().equals(parameterValue)) continue;
                        element.setValue(en.getValue());
                    }
                    continue;
                }
                if (element.getName().toLowerCase().indexOf("pwd") > 0 && (parameterValue == null || parameterValue.equals("**********") || parameterValue.trim().equals(EMPTY_STRING))) {
                    parameterValue = EMPTY_STRING;
                }
                element.setValue(parameterValue);
            }
        }
        bean.save();
    }

    private boolean loadConfigurations(String dispatcher, HtmlBurner burner) throws XMLStreamException {
        try {
            XqeService service = null;
            XqeConfigurationBean configBean = null;
            LinkedHashMap<String, List<XqeConfigurationElementBean>> map = null;
            map = new LinkedHashMap<String, List<XqeConfigurationElementBean>>();
            service = XqeAdministrator.getInstance().getXqeService(dispatcher);
            configBean = service.getConfiguration();
            List<XqeConfigurationCategoryBean> cats = configBean.getCategories();
            XqeConfigurationCategoryBean catBean = null;
            List<XqeConfigurationElementBean> list = null;
            for (int ii = 0; ii < cats.size(); ++ii) {
                catBean = cats.get(ii);
                list = catBean.getConfigElements();
                map.put(catBean.getLabel(), list);
            }
            this.configData.put(dispatcher, map);
            return true;
        }
        catch (Exception e) {
            this.errorLogger.log(ERR_MSG_CONFIGPAGE_CONFIG_LOAD);
            this.errorLogger.log(ERR_MSG_DISP_NAME + dispatcher);
            this.errorLogger.log(ERR_MSG_MESSAGE + e.getMessage());
            burner.errorMessage(ERR_MSG_CONFIGPAGE_CONFIG_LOAD, e.getMessage());
            return false;
        }
    }

    private boolean loadDispatchers(HtmlBurner burner) throws XMLStreamException {
        try {
            this.dispatchers = null;
            Set<String> dispatcherSet = XqeAdministrator.getInstance().getDispatchers();
            this.dispatchers = new String[dispatcherSet.size()];
            Iterator<String> iter = dispatcherSet.iterator();
            int i = 0;
            while (iter.hasNext()) {
                this.dispatchers[i] = iter.next();
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            this.errorLogger.log(ERR_MSG_CONFIGPAGE_DISP_LOAD);
            this.errorLogger.log(ERR_MSG_MESSAGE + e.getMessage());
            burner.errorMessage(ERR_MSG_CONFIGPAGE_DISP_LOAD, e.getMessage());
            return false;
        }
    }
}

