/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.fragmentproducer.utilities;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.BitSet;

public class Utils {
    private static final int INT_FIVE = 5;
    private static final int INT_1024 = 1024;
    private static final int INT_256 = 256;
    private static final int INT_THREE = 3;
    private static final char BACKSPACE = '\b';
    private static final char HORIZONTAL_TAB = '\t';
    private static final char NEWLINE = '\n';
    private static final char VERTICAL_TAB = '\u000b';
    private static final char FORM_FEED = '\f';
    private static final char CARRIAGE_RETURN = '\r';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char BACKSLASH = '\\';
    private static final char LEFT_ANGLE_BRACKET = '<';
    private static final char RIGHT_ANGLE_BRACKET = '>';
    static BitSet dontNeedEncoding;
    static final int CASEDIFF = 32;
    static String dfltEncName;

    public static String trimToIndexChars(String sSrc) {
        int i;
        if (sSrc == null) {
            return null;
        }
        int nSrc = sSrc.length();
        int nStart = 0;
        int nEnd = nSrc - 1;
        for (i = 0; i < nSrc; ++i) {
            if (!Character.isJavaIdentifierPart(sSrc.charAt(i))) continue;
            nStart = i;
            break;
        }
        if (i >= nSrc) {
            return null;
        }
        for (i = nSrc - 1; i >= 0; --i) {
            if (!Character.isJavaIdentifierPart(sSrc.charAt(i))) continue;
            nEnd = i + 1;
            break;
        }
        if (i < 0) {
            return null;
        }
        return sSrc.substring(nStart, nEnd).toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToString(String sFile) {
        FileInputStream fs = null;
        StringWriter sw = new StringWriter();
        try {
            fs = new FileInputStream(sFile);
            int c = fs.read();
            while (c != -1) {
                sw.write(c);
                c = fs.read();
            }
        }
        catch (EOFException e) {
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            String string = "File '" + sFile + "' not found";
            return string;
        }
        catch (Exception e) {
            String string = "Error reading file '" + sFile + "'. " + e.getMessage();
            return string;
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return sw.toString();
    }

    public static char[] extractCharsFromReader(Reader inReader) throws IOException {
        if (inReader == null) {
            throw new NullPointerException();
        }
        int numRead = 1024;
        int totalCount = 0;
        char[] buffer = new char[5120];
        char[] tmpBuf = new char[1024];
        if ((totalCount = inReader.read(buffer, totalCount, buffer.length - totalCount)) != -1 && (numRead = inReader.read(tmpBuf, 0, tmpBuf.length)) != -1) {
            if (totalCount + numRead > buffer.length) {
                char[] tmp = new char[buffer.length + 3 * numRead + 1];
                System.arraycopy(buffer, 0, tmp, 0, totalCount);
                System.arraycopy(tmpBuf, 0, tmp, totalCount, numRead);
                buffer = tmp;
                tmp = null;
            } else {
                System.arraycopy(tmpBuf, 0, buffer, totalCount, numRead);
            }
            totalCount += numRead;
            while ((numRead = inReader.read(buffer, totalCount, buffer.length - totalCount)) != -1) {
                if ((totalCount += numRead) < buffer.length) continue;
                tmpBuf = new char[buffer.length + 3 * numRead + 1];
                System.arraycopy(buffer, 0, tmpBuf, 0, totalCount);
                buffer = tmpBuf;
                tmpBuf = null;
            }
        }
        if (totalCount < buffer.length && totalCount != -1) {
            tmpBuf = new char[totalCount];
            System.arraycopy(buffer, 0, tmpBuf, 0, totalCount);
            buffer = tmpBuf;
            tmpBuf = null;
        }
        return buffer;
    }

    public static String javascriptencode(String value) {
        String prev;
        do {
            prev = value;
        } while (!(value = value.replaceAll("<\\/[sS][cC][rR][iI][pP][tT]", "")).equals(prev));
        int rsize = value.length() * 2;
        StringBuilder sbuf = new StringBuilder(rsize);
        block14: for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            switch (x) {
                case '\b': {
                    sbuf.append("\\b");
                    continue block14;
                }
                case '\t': {
                    sbuf.append("\\t");
                    continue block14;
                }
                case '\n': {
                    sbuf.append("\\n");
                    continue block14;
                }
                case '\u000b': {
                    sbuf.append("\\v");
                    continue block14;
                }
                case '\f': {
                    sbuf.append("\\f");
                    continue block14;
                }
                case '\r': {
                    sbuf.append("\\r");
                    continue block14;
                }
                case '\"': {
                    sbuf.append("\\\"");
                    continue block14;
                }
                case '\'': {
                    sbuf.append("\\'");
                    continue block14;
                }
                case '\\': {
                    sbuf.append("\\\\");
                    continue block14;
                }
                case '<': {
                    sbuf.append("\\<");
                    continue block14;
                }
                case '>': {
                    sbuf.append("\\>");
                    continue block14;
                }
                default: {
                    sbuf.append(x);
                }
            }
        }
        return sbuf.toString();
    }

    static {
        int i;
        dfltEncName = null;
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

