/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.qsat.fragmentproducer.ui.page;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerMultipleQueryCommand;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.XMLString;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.xml.XMLUtils;
import com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen.HtmlBurner;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control.CheckBoxControl;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control.ControlHelper;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control.DropdownList;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.page.BlankPage;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.page.Page;
import com.cognos.xqebifw.adminconsole.fragmentproducer.utilities.Utils;
import com.cognos.xqebifw.adminconsole.qsat.fragmentproducer.ui.control.StringOnlyDDList;
import com.cognos.xqebifw.adminconsole.qsat.rolap.server.QueryROLAPCubesCMCommand;
import com.cognos.xqebifw.adminconsole.qsat.server.OptionsXMLProcessor;
import com.cognos.xqebifw.adminconsole.server.QueryServerGroupCMCommand;
import com.cognos.xqebifw.management.XqeSALMetrics;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class XqeQSATPage
extends Page {
    private static final String FLUSH = "FLUSH";
    private static final String DUMP = "DUMP";
    public static final String ROLAP_DATASOURCE_TYPE = "ROLAP";
    public static final String LOLAP_DATASOURCE_TYPE = "LOLAP";
    public static final String DMR_DATASOURCE_TYPE = "DMR";
    public static final String ESSBASE_DATASOURCE_TYPE = "ESSBASE";
    public static final String SAPBW_DATASOURCE_TYPE = "SAPBW";
    private static final String STR_TRUE = "true";
    private static final String UTF8 = "UTF-8";
    private static final String XQE_CUBES_CHECKBOX = "xqe_cubes_checkbox";
    XQELogger errorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    protected List<String> columnHeaders = new ArrayList<String>();
    private static final String ALL_DISPATCHER_XPATH = "/configuration/descendant::dispatcher";
    private static final String PAGEURL = "_THIS?page=xqeQSATPage&";
    private static final String EQUALS = "=";
    private static final String THISPAGEURL = "/THIS_";
    private List<Cube> cubeList = new ArrayList<Cube>();
    private Map<String, String> rolapCubeDatasourceNameToHiddenStatusMap = null;
    private Map<String, String> rolapDispatcherDefaultNameToServerGroupMap = null;
    private Map<String, String> rolapDispatcherDefaultNameToIDMap = null;
    private String selectedROLAPDispatcher = "";
    private String selectedROLAPServerGroup = "";
    private String selectedROLAPOperation = "";
    private static final String SAVED_OPTIONS_FIELD_NAME = "xqeROLAPQSATPage_savedOptions";
    private static final String SAVED_CANWRITE_FIELD_NAME = "xqeROLAPQSATPage_savedCanWrite";
    private static final String SELECTED_OPERATION_FIELD_NAME = "xqeROLAPQSATPage_selectedOperation";
    private static final String SELECTED_SG_FIELD_NAME = "xqeROLAPQSATPage_selectedSG";
    private static final String SELECTED_DISPATCHER_FIELD_NAME = "xqeROLAPQSATPage_selectedDispatcher";
    private static final String DATASOURCE_TYPE = "DATASOURCE_TYPE";
    public static final String LOCALIZED_DS_CAPTION = "XQE_UI_xqeDatasourceCaption";
    public static final String LOCALIZED_TYPE_CAPTION = "XQE_UI_xqeDMRType";
    public static final String LOCALIZED_CATALOG_CAPTION = "XQE_UI_xqeCatalogCaption";
    public static final String LOCALIZED_PACKAGE_CAPTION = "XQE_UI_xqePackageCaption";
    public static final String LOCALIZED_CUBE_CAPTION = "XQE_UI_xqeCubeCaption";
    public static final String LOCALIZED_OPERATION_CAPTION = "XQE_UI_xqeOperationCaption";
    public static final String ROLAP_OM_OPERATIONS_PREFIX = "http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#";
    public static final String CLEARCACHE_CM_INTERNAL_CODE = "http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#clearCache";
    public static final String DUMPCACHE_CM_INTERNAL_CODE = "http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#DumpCacheState";
    private List<String> selectedROLAPCubes = new ArrayList<String>();
    private String dataSourceType = null;
    String inputDs = null;
    String inputPackage = null;
    String inputCtlg = null;
    String inputCube = null;
    String inputOperation = null;
    String inputDispatcherForROLAPType = null;
    String[] inputCubeNames = null;
    String options = null;
    private static final String COLON = ":";
    private static final String UNDERSCORE = "_";
    private static final String HIDDEN = "Hidden";
    public static final String DATASOURCE = "Datasource";
    public static final String CATALOG = "Catalog";
    public static final String PACKAGE = "Package";
    public static final String CUBE = "Cube";
    public static final String OPERATION = "Operation";
    public static final String DS_HTML_DDLIST_NAME = "DataSources";
    public static final String CATALOGS_HTML_DDLIST_NAME = "Catalogs";
    public static final String PACKAGE_HTML_DDLIST_NAME = "Package";
    public static final String CUBES_HTML_DDLIST_NAME = "Cubes";
    public static final String OPERATION_HTML_DDLIST_NAME = "Operations";
    private static final String STR_PORTAL_TABLE_HEADER = "portlet-form-field-label";
    public static final String ID = "xqeQSATPage";
    private static final String STR_ZERO = "0";
    private String canWrite = "false";
    StringOnlyDDList ddlistDatasources = null;
    StringOnlyDDList ddlistCatalogs = null;
    StringOnlyDDList ddlistCubes = null;
    StringOnlyDDList ddlistOperations = null;
    String[] cachedDs = null;
    String[] cachedCatalogs = null;
    String[] cachedCubes = null;
    private String productLocale = "";
    protected StageContext context;
    Map<String, String> rolapOperationsMap = new LinkedHashMap<String, String>();
    Map<String, String> cacheOperationsMap = new HashMap<String, String>();

    public static String getFullyQualifiedOMCubeOperation(String operation) {
        if (operation != null) {
            operation = operation.replace(ROLAP_OM_OPERATIONS_PREFIX, "");
            for (OMOperation cubeOperation : OMOperation.values()) {
                if (!operation.equalsIgnoreCase(cubeOperation.getName())) continue;
                return ROLAP_OM_OPERATIONS_PREFIX + cubeOperation.getName();
            }
        }
        return null;
    }

    private static String hiddenCubeOperationFieldsArrayJavaScript() {
        StringBuilder script = new StringBuilder();
        for (OMOperation op : OMOperation.values()) {
            if (script.length() != 0) {
                script.append(',');
            }
            script.append("'").append(SELECTED_OPERATION_FIELD_NAME).append(op.getName()).append("hidden").append("'");
        }
        script.insert(0, "_THIS_.hiddenOperationFields = [");
        script.append("];");
        return script.toString();
    }

    private static String cubeOptionNamesArrayJavaScript() {
        StringBuilder script = new StringBuilder();
        for (OMOperation op : OMOperation.values()) {
            if (script.length() != 0) {
                script.append(',');
            }
            script.append("'").append(op.getName()).append("'");
        }
        script.insert(0, "_THIS_.optionNames = [");
        script.append("];");
        return script.toString();
    }

    private String i18nJavaScript() {
        String script = "_THIS_.i18n = {";
        script = script + this.createJSONElement(XQEMessageKeys.UI_xqeCubeMsgEnterValidDataSourceCatalogCube, false);
        script = script + this.createJSONElement(XQEMessageKeys.UI_xqeCubeMsgEnterValidDataSourceOrPackageName, false);
        script = script + this.createJSONElement(XQEMessageKeys.UI_xqeCubeMsgSelectAtleastOneCube, true);
        script = script + "};";
        return script;
    }

    private String createJSONElement(IMessageKey.Param0 param, boolean lastOne) {
        String encodedMsg = Utils.javascriptencode(XQEMessages.getMessage(param, LocaleConverter.strToLocale(this.getProductLocale())));
        String element = "'" + param.getName() + "'" + " : " + "'" + encodedMsg + "'";
        if (!lastOne) {
            element = element + ',';
        }
        return element;
    }

    public XqeQSATPage(StageContext ctxt, String title, String href) {
        super(title, href);
        this.context = ctxt;
        this.productLocale = this.context.getEnv().getProductLocale();
        this.productLocale = this.tweakInputProductLocaleString(this.productLocale);
        this.options = this.context.getRequestParameters().getValue("ui.options");
        if (this.options == null || this.options.equals("")) {
            this.options = this.context.getRequestParameters().getValue(SAVED_OPTIONS_FIELD_NAME);
        }
        this.dataSourceType = this.context.getRequestParameters().getValue("ui.dataSourceType");
        if (this.dataSourceType == null || this.dataSourceType.equals("")) {
            this.dataSourceType = this.context.getRequestParameters().getValue("xqeQSATPage_DATASOURCE_TYPE_Hidden");
        }
        this.setDatasourceType();
        this.loadDatasourceSpecificFormFieldData(this.dataSourceType);
        this.canWrite = this.context.getRequestParameters().getValue("ui.canWrite");
        if (this.canWrite == null || this.canWrite.equals("")) {
            this.canWrite = this.context.getRequestParameters().getValue(SAVED_CANWRITE_FIELD_NAME);
            if (this.canWrite == null || this.canWrite.equals("")) {
                this.canWrite = STR_TRUE;
            }
        }
        this.columnHeaders.add("XQE_UI_xqeROLAPQSATNameCaption");
    }

    @Override
    public void draw(HtmlBurner burner) throws XMLStreamException {
        this.setPageID(burner, ID);
        burner.elementStart("script");
        burner.addAttribute("type", "text/javascript");
        String javaScript = XqeQSATPage.cubeOptionNamesArrayJavaScript();
        javaScript = javaScript + XqeQSATPage.hiddenCubeOperationFieldsArrayJavaScript();
        javaScript = javaScript + this.i18nJavaScript();
        burner.addText(javaScript);
        burner.elementEnd("script");
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", "xqeQSATPage_DATASOURCE_TYPE_Hidden");
        burner.addAttribute("value", this.dataSourceType);
        burner.elementEnd("input");
        if (this.dataSourceType.equals(ROLAP_DATASOURCE_TYPE)) {
            this.drawROLAPQSATPage(burner);
        } else if (this.dataSourceType.equals(DMR_DATASOURCE_TYPE)) {
            this.drawDMRQSATPage(burner);
        } else if (this.dataSourceType.equals(ESSBASE_DATASOURCE_TYPE) || this.dataSourceType.equals(SAPBW_DATASOURCE_TYPE) || this.dataSourceType.equals(LOLAP_DATASOURCE_TYPE)) {
            this.drawLOLAPQSATPage(burner);
        } else {
            this.drawLOLAPQSATPage(burner);
        }
    }

    @Override
    public String getStateParameters() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("page=").append(ID);
        return buffer.toString();
    }

    public void addVerticalSpace(HtmlBurner burner) throws XMLStreamException {
        burner.elementStart("table");
        burner.addAttribute("width", "98%");
        burner.addAttribute("height", "5");
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("border", STR_ZERO);
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addEmptyElement("br");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
    }

    public void drawDDList(HtmlBurner burner, String inputted, String categoryName) throws XMLStreamException {
        String componentName = "xqeQSATPage_" + categoryName;
        this.ddlistOperations = this.getDropdownlist(inputted, componentName);
        this.ddlistOperations.draw(burner);
    }

    protected StringOnlyDDList getDropdownlist(String inputFetched, String name) {
        StringOnlyDDList ddlst = new StringOnlyDDList(name, this.canWrite);
        if (!this.canWrite.equalsIgnoreCase(STR_TRUE)) {
            ddlst.setDisabled(true);
        }
        Object[] objects = this.cacheOperationsMap.keySet().toArray(new String[0]);
        Arrays.sort(objects);
        String localizedName = "";
        for (int i = 0; i < objects.length; ++i) {
            localizedName = this.cacheOperationsMap.get(objects[i]);
            ddlst.add(localizedName);
        }
        if (inputFetched.toLowerCase().indexOf("Clear cache".toLowerCase()) >= 0) {
            ddlst.setSelected(0);
        } else if (inputFetched.toLowerCase().indexOf("Write cache state".toLowerCase()) >= 0) {
            ddlst.setSelected(1);
        } else {
            ddlst.setSelected(0);
        }
        return ddlst;
    }

    private void addEditBox(HtmlBurner burner, String identifierName, String textValue, String displayName, boolean isDisabled) throws XMLStreamException {
        burner.elementStart("input");
        burner.addAttribute("type", "text");
        burner.addAttribute("style", "width:95%");
        burner.addAttribute("height", "200px;");
        burner.addAttribute("name", identifierName);
        burner.addAttribute("id", identifierName);
        burner.addAttribute("value", textValue);
        if (!this.canWrite.equalsIgnoreCase(STR_TRUE)) {
            burner.addAttribute("disabled", STR_TRUE);
        } else if (isDisabled) {
            burner.addAttribute("disabled", STR_TRUE);
        }
        burner.addAttribute("height", "20");
        burner.elementEnd("input");
    }

    private void drawCachedObject(HtmlBurner burner, String cachedObjectType, String value) throws XMLStreamException {
        String formFieldId = null;
        String formFieldName = null;
        String formFieldWidth = null;
        String cachedObjectDisplayCaption = null;
        if (cachedObjectType.equals("Datasource:")) {
            formFieldId = "xqeQSATPage_DataSources";
            formFieldName = DS_HTML_DDLIST_NAME;
            formFieldWidth = "40%";
            cachedObjectDisplayCaption = LOCALIZED_DS_CAPTION;
        } else if (cachedObjectType.equals("Catalog:")) {
            formFieldId = "xqeQSATPage_Catalogs";
            formFieldName = CATALOGS_HTML_DDLIST_NAME;
            formFieldWidth = "40%";
            cachedObjectDisplayCaption = LOCALIZED_CATALOG_CAPTION;
        } else if (cachedObjectType.equals("Cube:")) {
            formFieldId = "xqeQSATPage_Cubes";
            formFieldName = CUBES_HTML_DDLIST_NAME;
            formFieldWidth = "40%";
            cachedObjectDisplayCaption = LOCALIZED_CUBE_CAPTION;
        } else if (cachedObjectType.equals("Operation:")) {
            formFieldWidth = "25%";
            cachedObjectDisplayCaption = LOCALIZED_OPERATION_CAPTION;
        }
        burner.elementStart("table");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("width", formFieldWidth);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("style", "padding-left:10px;");
        burner.addAttribute("role", "presentation");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("align", "left");
        burner.addAttribute("class", STR_PORTAL_TABLE_HEADER);
        burner.addAttribute("nowrap", STR_TRUE);
        burner.elementStart("label");
        String fieldNameSuffix = formFieldName;
        if (cachedObjectType.equals("Operation:")) {
            fieldNameSuffix = OPERATION_HTML_DDLIST_NAME;
        }
        burner.addAttribute("for", "xqeQSATPage_" + fieldNameSuffix);
        ControlHelper.addLocalizedString(burner, cachedObjectDisplayCaption);
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("align", "left");
        burner.addAttribute("class", "tableText");
        burner.addAttribute("nowrap", STR_TRUE);
        if (cachedObjectType.equals("Operation:")) {
            this.drawDDList(burner, value, OPERATION_HTML_DDLIST_NAME);
        } else {
            this.addEditBox(burner, formFieldId, value, formFieldName, false);
        }
        burner.elementEnd("td");
        burner.elementEnd("tr");
    }

    private void drawLOLAPQSATPage(HtmlBurner burner) throws XMLStreamException {
        this.setPageHeader(burner, "XQE_UI_xqeQSATIntroductionText");
        this.addVerticalSpace(burner);
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", "xqeQSATPage_DataSources_Hidden");
        burner.addAttribute("value", this.inputDs);
        burner.elementEnd("input");
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", "xqeQSATPage_Catalogs_Hidden");
        burner.addAttribute("value", this.inputCtlg);
        burner.elementEnd("input");
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", "xqeQSATPage_Cubes_Hidden");
        burner.addAttribute("value", this.inputCube);
        burner.elementEnd("input");
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", "xqeQSATPage_Operations_Hidden");
        burner.addAttribute("value", this.inputOperation);
        burner.elementEnd("input");
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", "xqeQSATPage_FLUSH_Hidden");
        burner.addAttribute("value", "Clear cache");
        burner.elementEnd("input");
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", "xqeQSATPage_DUMP_Hidden");
        burner.addAttribute("value", "Write cache state");
        burner.elementEnd("input");
        this.drawCachedObject(burner, "Operation:", this.inputOperation);
        this.addVerticalSpace(burner);
        this.drawCachedObject(burner, "Datasource:", this.inputDs);
        this.addVerticalSpace(burner);
        this.drawCachedObject(burner, "Catalog:", this.inputCtlg);
        this.addVerticalSpace(burner);
        this.drawCachedObject(burner, "Cube:", this.inputCube);
        this.addVerticalSpace(burner);
    }

    private void drawDMRQSATPage(HtmlBurner burner) throws XMLStreamException {
        this.setPageHeader(burner, "XQE_UI_xqeDMRQSATIntroductionText");
        this.addVerticalSpace(burner);
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", "xqeQSATPage_DataSources_Hidden");
        burner.addAttribute("value", this.inputDs);
        burner.elementEnd("input");
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", "xqeQSATPage_Package_Hidden");
        burner.addAttribute("value", this.inputPackage);
        burner.elementEnd("input");
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", "xqeQSATPage_Operations_Hidden");
        burner.addAttribute("value", this.inputOperation);
        burner.elementEnd("input");
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", "xqeQSATPage_FLUSH_Hidden");
        burner.addAttribute("value", "Clear cache");
        burner.elementEnd("input");
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", "xqeQSATPage_DUMP_Hidden");
        burner.addAttribute("value", "Write cache state");
        burner.elementEnd("input");
        String formFieldWidth = "25%";
        String cachedObjectDisplayCaption = LOCALIZED_OPERATION_CAPTION;
        burner.elementStart("table");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("width", formFieldWidth);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("style", "padding-left:10px;");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("align", "left");
        burner.addAttribute("class", STR_PORTAL_TABLE_HEADER);
        burner.addAttribute("nowrap", STR_TRUE);
        ControlHelper.addLocalizedString(burner, cachedObjectDisplayCaption);
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("align", "left");
        burner.addAttribute("class", "tableText");
        burner.addAttribute("nowrap", STR_TRUE);
        this.drawDDList(burner, this.inputOperation, OPERATION_HTML_DDLIST_NAME);
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        this.addVerticalSpace(burner);
        formFieldWidth = "40%";
        burner.elementStart("table");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("width", formFieldWidth);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("style", "padding-left:10px;");
        cachedObjectDisplayCaption = LOCALIZED_TYPE_CAPTION;
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("align", "left");
        burner.addAttribute("class", STR_PORTAL_TABLE_HEADER);
        burner.addAttribute("nowrap", STR_TRUE);
        ControlHelper.addLocalizedString(burner, cachedObjectDisplayCaption);
        burner.elementEnd("td");
        burner.elementEnd("tr");
        String formFieldId = "xqeQSATPage_Package";
        String formFieldName = "Package";
        cachedObjectDisplayCaption = LOCALIZED_PACKAGE_CAPTION;
        burner.elementStart("tr");
        burner.addAttribute("style", "padding-left:20px;");
        burner.elementStart("td");
        burner.addAttribute("class", STR_PORTAL_TABLE_HEADER);
        burner.addAttribute("align", "left");
        burner.elementStart("input");
        burner.addAttribute("type", "radio");
        burner.addAttribute("class", STR_PORTAL_TABLE_HEADER);
        burner.addAttribute("name", "xqeQSATPage_DMR_Radio_Button_Group");
        burner.addAttribute("id", "xqeQSATPage_DMR_Radio_Button_Group");
        burner.addAttribute("value", formFieldName);
        burner.addAttribute("onclick", "javascript:dmrRadioButtonSelection(document.getElementById('_THIS_pform'))");
        if (this.inputPackage != null && !this.inputPackage.equals("")) {
            burner.addAttribute("checked", "checked");
        } else if (this.inputDs == null || this.inputDs.equals("")) {
            burner.addAttribute("checked", "checked");
        }
        ControlHelper.addLocalizedString(burner, cachedObjectDisplayCaption);
        burner.elementEnd("input");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("align", "left");
        burner.addAttribute("class", "tableText");
        burner.addAttribute("nowrap", STR_TRUE);
        burner.elementStart("table");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("width", "98%");
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("style", "padding-left:25px;");
        burner.elementStart("tr");
        burner.elementStart("td");
        if (this.inputPackage != null && !this.inputPackage.equals("")) {
            this.addEditBox(burner, formFieldId, this.inputPackage, formFieldName, false);
        } else if (this.inputDs == null || this.inputDs.equals("")) {
            this.addEditBox(burner, formFieldId, this.inputPackage, formFieldName, false);
        } else {
            this.addEditBox(burner, formFieldId, this.inputPackage, formFieldName, true);
        }
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementStart("tr");
        burner.elementStart("td");
        this.addVerticalSpace(burner);
        burner.elementEnd("td");
        burner.elementEnd("tr");
        formFieldId = "xqeQSATPage_DataSources";
        formFieldName = DS_HTML_DDLIST_NAME;
        cachedObjectDisplayCaption = LOCALIZED_DS_CAPTION;
        burner.elementStart("tr");
        burner.addAttribute("style", "padding-left:20px;");
        burner.elementStart("td");
        burner.addAttribute("class", STR_PORTAL_TABLE_HEADER);
        burner.addAttribute("align", "left");
        burner.elementStart("input");
        burner.addAttribute("type", "radio");
        burner.addAttribute("name", "xqeQSATPage_DMR_Radio_Button_Group");
        burner.addAttribute("id", "xqeQSATPage_DMR_Radio_Button_Group");
        burner.addAttribute("value", formFieldName);
        burner.addAttribute("onclick", "javascript:dmrRadioButtonSelection(document.getElementById('_THIS_pform'))");
        if (this.inputDs != null && !this.inputDs.equals("")) {
            burner.addAttribute("checked", "checked");
        }
        ControlHelper.addLocalizedString(burner, cachedObjectDisplayCaption);
        burner.elementEnd("input");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("align", "left");
        burner.addAttribute("class", "tableText");
        burner.addAttribute("nowrap", STR_TRUE);
        burner.elementStart("table");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("width", "98%");
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("style", "padding-left:25px;");
        burner.elementStart("tr");
        burner.elementStart("td");
        if (this.inputDs != null && !this.inputDs.equals("")) {
            this.addEditBox(burner, formFieldId, this.inputDs, formFieldName, false);
        } else {
            this.addEditBox(burner, formFieldId, this.inputDs, formFieldName, true);
        }
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        this.addVerticalSpace(burner);
    }

    private void drawROLAPQSATPage(HtmlBurner burner) throws XMLStreamException {
        this.setPageHeader(burner, "XQE_UI_xqeROLAPQSATIntroductionText");
        this.addVerticalSpace(burner);
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", SAVED_OPTIONS_FIELD_NAME);
        burner.addAttribute("id", SAVED_OPTIONS_FIELD_NAME);
        burner.addAttribute("value", this.options);
        burner.elementEnd("input");
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", SAVED_CANWRITE_FIELD_NAME);
        burner.addAttribute("id", SAVED_CANWRITE_FIELD_NAME);
        burner.addAttribute("value", this.canWrite);
        burner.elementEnd("input");
        for (OMOperation op : OMOperation.values()) {
            this.drawOperationInput(burner, op.getName());
        }
        this.drawOperationsDDL(burner, this.selectedROLAPOperation);
        this.addVerticalSpace(burner);
        this.drawServerGroupsDDL(burner, this.getAllServerGroupsFromMap(this.rolapDispatcherDefaultNameToServerGroupMap), this.selectedROLAPServerGroup);
        this.addVerticalSpace(burner);
        this.drawDispatcherDDL(burner, this.getAllDispatchersForSpecificSGFromMap(this.rolapDispatcherDefaultNameToServerGroupMap, this.selectedROLAPServerGroup));
        this.addVerticalSpace(burner);
        String dispatcherPath = null;
        if (this.selectedROLAPDispatcher != null && !this.selectedROLAPDispatcher.equals("")) {
            dispatcherPath = this.getDispatcherDefaultNameFromNameToIDMap(this.selectedROLAPDispatcher);
            this.cubeList = this.fetchROLAPCubesFromCM(dispatcherPath);
            this.rolapCubeDatasourceNameToHiddenStatusMap = this.fetchAllROLAPCubeNamesAndHiddenStatusMapping();
        }
        if (this.cubeList.size() == 0 || this.cubeList == null || this.cubeList.size() == 1 && this.cubeList.get(0).equals("No Cube Found")) {
            this.drawCubesArea(burner, null);
        } else {
            Object[] cubes = this.cubeList.toArray(new Cube[0]);
            Arrays.sort(cubes);
            this.drawCubesArea(burner, (Cube[])cubes);
        }
    }

    private void drawOperationInput(HtmlBurner burner, String operationName) throws XMLStreamException {
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", SELECTED_OPERATION_FIELD_NAME + operationName + "hidden");
        burner.addAttribute("id", SELECTED_OPERATION_FIELD_NAME + operationName + "hidden");
        burner.addAttribute("value", operationName);
        burner.elementEnd("input");
    }

    private boolean drawServerGroupsDDL(HtmlBurner burner, String[] entries, String selectedValue) throws XMLStreamException {
        burner.elementStart("table");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("width", "98%");
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("style", "padding-left:10px;");
        burner.addAttribute("role", "presentation");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("class", STR_PORTAL_TABLE_HEADER);
        burner.addAttribute("align", "left");
        burner.elementStart("label");
        burner.addAttribute("for", SELECTED_SG_FIELD_NAME);
        ControlHelper.addLocalizedString(burner, "XQE_UI_xqeROLAPQSATServerGroupDDLCaption");
        burner.elementEnd("label");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementStart("tr");
        burner.elementStart("td");
        DropdownList ddl = new DropdownList(SELECTED_SG_FIELD_NAME);
        ddl.addAction("onchange", "javascript:changeROLAPServerGroup(document.getElementById('_THIS_pform'))");
        if (!this.canWrite.equalsIgnoreCase(STR_TRUE)) {
            ddl.setDisabled(true);
        }
        boolean setSelected = false;
        for (int i = 0; i < entries.length; ++i) {
            String value = entries[i];
            String urlEncodedValue = null;
            try {
                urlEncodedValue = URLEncoder.encode(value, UTF8);
            }
            catch (UnsupportedEncodingException e) {
                throw new XMLStreamException(e);
            }
            BlankPage page = new BlankPage(value, value, "_THIS?page=xqeQSATPage&xqeROLAPQSATPage_selectedSG=" + urlEncodedValue + THISPAGEURL);
            ddl.add(page);
            if (setSelected) continue;
            if (this.selectedROLAPServerGroup != null && !this.selectedROLAPServerGroup.equals("")) {
                if (!this.selectedROLAPServerGroup.equalsIgnoreCase(value)) continue;
                ddl.setSelected(page);
                setSelected = true;
                continue;
            }
            ddl.setSelected(page);
            setSelected = true;
        }
        ddl.draw(burner);
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        return true;
    }

    private boolean drawOperationsDDL(HtmlBurner burner, String selectedValue) throws XMLStreamException {
        burner.elementStart("table");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("width", "98%");
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("style", "padding-left:10px;");
        burner.addAttribute("role", "presentation");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("class", STR_PORTAL_TABLE_HEADER);
        burner.addAttribute("align", "left");
        burner.elementStart("label");
        burner.addAttribute("for", SELECTED_OPERATION_FIELD_NAME);
        ControlHelper.addLocalizedString(burner, "XQE_UI_xqeROLAPQSATOperationDDLCaption");
        burner.elementEnd("label");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementStart("tr");
        burner.elementStart("td");
        DropdownList ddl = new DropdownList(SELECTED_OPERATION_FIELD_NAME);
        ddl.addAction("onchange", "javascript:changeROLAPOperation(document.getElementById('_THIS_pform'))");
        if (!this.canWrite.equalsIgnoreCase(STR_TRUE)) {
            ddl.setDisabled(true);
        }
        boolean setSelected = false;
        String[] entries = this.rolapOperationsMap.keySet().toArray(new String[0]);
        String value = "";
        String title = "";
        for (int i = 0; i < entries.length; ++i) {
            value = entries[i];
            title = this.rolapOperationsMap.get(value);
            BlankPage page = new BlankPage(title, value, "_THIS?page=xqeQSATPage&xqeROLAPQSATPage_selectedOperation=" + value + THISPAGEURL);
            ddl.add(page);
            if (setSelected) continue;
            if (this.selectedROLAPOperation != null && !this.selectedROLAPOperation.equals("")) {
                if (!this.selectedROLAPOperation.equalsIgnoreCase(value)) continue;
                ddl.setSelected(page);
                setSelected = true;
                continue;
            }
            ddl.setSelected(page);
            setSelected = true;
        }
        ddl.draw(burner);
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        return true;
    }

    private void drawDispatcherDDL(HtmlBurner burner, String[] entries) throws XMLStreamException {
        burner.elementStart("table");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("width", "98%");
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("style", "padding-left:10px;");
        burner.addAttribute("role", "presentation");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("class", STR_PORTAL_TABLE_HEADER);
        burner.addAttribute("align", "left");
        burner.elementStart("label");
        burner.addAttribute("for", SELECTED_DISPATCHER_FIELD_NAME);
        ControlHelper.addLocalizedString(burner, "XQE_UI_xqeROLAPQSATDispatcherDDLCaption");
        burner.elementEnd("label");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementStart("tr");
        burner.elementStart("td");
        DropdownList ddl = new DropdownList(SELECTED_DISPATCHER_FIELD_NAME);
        ddl.addAction("onchange", "javascript:changeROLAPDispatcher(document.getElementById('_THIS_pform'))");
        if (!this.canWrite.equalsIgnoreCase(STR_TRUE)) {
            ddl.setDisabled(true);
        }
        boolean setSelected = false;
        Page firstPage = null;
        for (int i = 0; i < entries.length; ++i) {
            String value = entries[i];
            String dispatcherGUID = this.rolapDispatcherDefaultNameToIDMap.get(value);
            BlankPage page = new BlankPage(value, dispatcherGUID, "_THIS?page=xqeQSATPage&xqeROLAPQSATPage_selectedDispatcher=" + dispatcherGUID + THISPAGEURL);
            ddl.add(page);
            if (!setSelected) {
                if (this.selectedROLAPDispatcher != null && !this.selectedROLAPDispatcher.equals("")) {
                    if (this.selectedROLAPDispatcher.equalsIgnoreCase(dispatcherGUID)) {
                        ddl.setSelected(page);
                        setSelected = true;
                    }
                } else {
                    ddl.setSelected(page);
                    this.selectedROLAPDispatcher = page.getValue();
                    setSelected = true;
                }
            }
            if (i != 0) continue;
            firstPage = page;
        }
        if (!setSelected) {
            ddl.setSelected(firstPage);
            setSelected = true;
            this.selectedROLAPDispatcher = firstPage.getValue();
        }
        ddl.draw(burner);
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
    }

    private void drawCubesArea(HtmlBurner burner, Cube[] cubes) throws XMLStreamException {
        burner.elementStart("table");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("width", "98%");
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("style", "padding-left:10px;");
        burner.addAttribute("role", "presentation");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("class", STR_PORTAL_TABLE_HEADER);
        burner.addAttribute("align", "left");
        ControlHelper.addLocalizedString(burner, "XQE_UI_xqeROLAPQSATCubesAreaCaption");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        burner.elementStart("table");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("width", "40%");
        burner.addAttribute("style", "padding-left:10px;");
        burner.addAttribute("role", "presentation");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("valign", "top");
        burner.addAttribute("width", "100%");
        burner.addAttribute("colspan", "2");
        burner.addEmptyElement("div");
        burner.elementStart("table");
        burner.addAttribute("width", "100%");
        burner.addAttribute("border", "1");
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("role", "presentation");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.elementStart("table");
        burner.addAttribute("width", "100%");
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("cellpadding", "2");
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("class", "cogstyle-xqe-table");
        burner.elementStart("thead");
        burner.addAttribute("id", "Header");
        burner.elementStart("tr");
        burner.addAttribute("class", "dialogHeader");
        burner.elementStart("th");
        burner.addAttribute("height", "10");
        burner.addAttribute("class", "dialogHeader");
        burner.addAttribute("style", "padding-left:2px;padding-top:2px;");
        burner.addAttribute("width", "16");
        burner.addAttribute("valign", "center");
        burner.elementStart("input");
        burner.addAttribute("type", "checkbox");
        burner.addAttribute("id", "control_checkbox");
        burner.addAttribute("onclick", "toggleChecks(document._THIS_pform, 'xqe_cubes_checkbox', checked)");
        burner.addAttribute("title", XQEMessages.getMessage(XQEMessageKeys.UI_xqeROLAPQSATSelectAllCubes, LocaleConverter.strToLocale(this.getProductLocale())));
        burner.elementEnd("input");
        burner.elementEnd("th");
        burner.elementStart("th");
        burner.addAttribute("height", "15");
        burner.addAttribute("width", "1");
        burner.elementEnd();
        int width = 100 / this.columnHeaders.size();
        for (int i = 0; i < this.columnHeaders.size(); ++i) {
            String columnHeader = this.columnHeaders.get(i);
            burner.elementStart("th");
            burner.addAttribute("height", "10");
            burner.addAttribute("class", "dialogHeader");
            burner.addAttribute("style", "padding-left:2px;padding-top:2px;");
            burner.addAttribute("style", "text-align:left");
            burner.addAttribute("width", width + "%");
            ControlHelper.addLocalizedString(burner, columnHeader);
            burner.elementEnd("th");
        }
        burner.elementStart("th");
        burner.addAttribute("height", "10");
        burner.addAttribute("class", "dialogHeader");
        burner.addAttribute("style", "padding-left:2px;padding-top:2px;");
        burner.addAttribute("width", "16");
        burner.addAttribute("valign", "center");
        burner.elementEnd("th");
        burner.elementEnd("tr");
        burner.elementEnd("thead");
        burner.elementStart("tbody");
        if (cubes != null) {
            String cubeName = null;
            for (int i = 0; i < cubes.length; ++i) {
                cubeName = cubes[i].label;
                if (this.isROLAPCubeHidden(cubeName)) {
                    if (!this.isROLAPCubeGreyed(cubeName)) continue;
                    this.drawCubeEntry(burner, cubes[i], i + 1, true);
                    continue;
                }
                this.drawCubeEntry(burner, cubes[i], i + 1, false);
            }
        } else {
            this.drawEmptyMessage(burner);
        }
        burner.elementEnd("tbody");
        burner.elementEnd("table");
        burner.elementEnd("table");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
    }

    private void drawEmptyMessage(HtmlBurner burner) throws XMLStreamException {
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("height", "100");
        burner.addAttribute("width", "16");
        burner.addAttribute("class", "tableText");
        burner.addAttribute("halign", "right");
        burner.addAttribute("valign", "right");
        burner.addAttribute("align", "right");
        burner.elementEnd("td");
        burner.elementEnd("tr");
    }

    private void drawCubeEntry(HtmlBurner burner, Cube cube, int rowIndex, boolean isHidden) throws XMLStreamException {
        String alt;
        String img;
        int i;
        boolean isChecked = false;
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("height", "10");
        burner.addAttribute("width", "16");
        burner.addAttribute("class", "tableText");
        burner.addAttribute("halign", "right");
        burner.addAttribute("valign", "right");
        burner.addAttribute("align", "right");
        if (this.selectedROLAPCubes != null && this.selectedROLAPCubes.size() > 0) {
            for (i = 0; i < this.selectedROLAPCubes.size(); ++i) {
                if (cube.name.equals(this.selectedROLAPCubes.get(i))) {
                    isChecked = true;
                    break;
                }
                isChecked = false;
            }
        } else if (this.inputCubeNames != null && this.inputCubeNames.length != 0) {
            for (i = 0; i < this.inputCubeNames.length; ++i) {
                if (cube.name.equals(this.inputCubeNames[i])) {
                    isChecked = true;
                    break;
                }
                isChecked = false;
            }
        }
        CheckBoxControl checkBox = new CheckBoxControl(XQE_CUBES_CHECKBOX + rowIndex, OptionsXMLProcessor.xmlEncode(cube.name), isChecked);
        if (!this.canWrite.equalsIgnoreCase(STR_TRUE)) {
            checkBox.setEnabled(false);
        } else {
            checkBox.setEnabled(true);
        }
        checkBox.draw(burner);
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("height", "10");
        burner.addAttribute("width", "16");
        burner.addAttribute("valign", "center");
        burner.elementStart("img");
        if (isHidden) {
            burner.addAttribute("class", "hiddenEntryIcon");
        }
        if (cube.isVirtual) {
            img = "$WEB$/ps/portal/images/icon_rolapVirtualDataSource.gif";
            alt = XQEMessages.getMessage(XQEMessageKeys.UI_xqeROLAPQSATVirtualCube, LocaleConverter.strToLocale(this.getProductLocale()));
        } else {
            img = "$WEB$/ps/portal/images/icon_rolapDataSource.gif";
            alt = XQEMessages.getMessage(XQEMessageKeys.UI_xqeROLAPQSATCube, LocaleConverter.strToLocale(this.getProductLocale()));
        }
        burner.addAttribute("src", img);
        burner.addAttribute("alt", alt);
        burner.elementEnd("img");
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.addAttribute("height", "10");
        burner.addAttribute("class", "portlet-form-field");
        burner.addAttribute("style", "padding-left:2px;padding-top:2px;");
        burner.addAttribute("width", "50%");
        burner.addAttribute("valign", "left");
        burner.addAttribute("halign", "left");
        ControlHelper.addLocalizedString(burner, cube.label);
        burner.elementEnd("td");
        burner.elementStart("td");
        burner.elementStart("input");
        burner.addAttribute("type", "hidden");
        burner.addAttribute("name", XQE_CUBES_CHECKBOX + rowIndex + "HIDDEN");
        burner.addAttribute("id", XQE_CUBES_CHECKBOX + rowIndex + "HIDDEN");
        burner.addAttribute("value", cube.name);
        burner.elementEnd("input");
        burner.elementEnd("td");
        burner.elementEnd("tr");
    }

    private List<Cube> fetchROLAPCubesFromCM(String dispatcher) {
        try {
            QueryROLAPCubesCMCommand command = new QueryROLAPCubesCMCommand(this.getCMQueryPathForROLAPCubes(dispatcher));
            XMLString str = this.context.getBusHeader();
            String str1 = str.toString();
            Element element = null;
            try {
                SAXReader reader = new SAXReader();
                Document doc = reader.read((InputStream)new ByteArrayInputStream(str1.getBytes(UTF8)));
                element = doc.getRootElement();
            }
            catch (Exception e) {
                this.errorLogger.log(e.getMessage());
            }
            command.setBIBusHeader(element);
            command.setDoTrustedRequest(true);
            command.execute();
            return this.getLocalizedCubeList(command.getCubeList(), element);
        }
        catch (Exception e) {
            this.errorLogger.log(e.getMessage());
            if (e.getMessage() == null) {
                this.errorLogger.log("NullPointerException");
            } else {
                this.errorLogger.log(e.getMessage());
            }
            return null;
        }
    }

    private List<Cube> getLocalizedCubeList(List<String> cubeNames, Element biBusElement) throws CommandExecutionException {
        ContentManagerMultipleQueryCommand query = new ContentManagerMultipleQueryCommand("/");
        for (String cube : cubeNames) {
            query.addSearchProperties("CAMID(\":\")/*[@objectClass='rolapDataSource' or @objectClass='rolapVirtualDataSource' and @name='" + cube + "'" + "]", new String[]{"defaultName", "name"});
        }
        biBusElement.detach();
        query.setBIBusHeader(biBusElement);
        query.execute();
        List cubeNodeList = query.getResponseEnvelope().getBody().selectNodes("//*[local-name()='queryResult']/*[local-name()='item']");
        ArrayList<Cube> cubeObjList = new ArrayList<Cube>();
        block1: for (int i = 1; i < cubeNodeList.size(); ++i) {
            Node cubeNode = (Node)cubeNodeList.get(i);
            Node type = cubeNode.selectSingleNode("@*[local-name()='type']");
            Node defaultName = cubeNode.selectSingleNode("*[local-name()='defaultName']/*[local-name()='value']");
            List nameNodes = cubeNode.selectNodes("*[local-name()='name']/*[local-name()='value']/*[local-name()='item']/*[local-name()='value']");
            for (int j = 0; j < nameNodes.size(); ++j) {
                boolean found = false;
                String name = ((Node)nameNodes.get(j)).getText();
                for (String cubeName : cubeNames) {
                    if (!name.equals(cubeName)) continue;
                    Cube myCube = new Cube(cubeName, type.getText(), defaultName.getText());
                    cubeObjList.add(myCube);
                    found = true;
                    break;
                }
                if (found) continue block1;
            }
        }
        return cubeObjList;
    }

    private String getCMQueryPathForROLAPCubes(String disp) {
        return "//dispatcher[@name=" + XMLUtils.xPathLiteral(disp) + "]/queryService";
    }

    private String[] getAllServerGroupsFromMap(Map<String, String> dispatcherToSGMap) {
        Collection<String> collection = dispatcherToSGMap.values();
        HashSet<String> serverGroupSet = new HashSet<String>(collection);
        Object[] serverGroups = serverGroupSet.toArray(new String[0]);
        Arrays.sort(serverGroups);
        if (this.selectedROLAPServerGroup == null || this.selectedROLAPServerGroup.equals("")) {
            this.selectedROLAPServerGroup = serverGroups[0];
        }
        return serverGroups;
    }

    private String[] getAllDispatchersForSpecificSGFromMap(Map<String, String> dispatcherToSGMap, String serverGroup) {
        Object[] dispatchers = null;
        ArrayList<String> matchingDispatchersList = new ArrayList<String>();
        Set<String> keys = dispatcherToSGMap.keySet();
        String[] keySetArray = keys.toArray(new String[0]);
        for (int i = 0; i < keySetArray.length; ++i) {
            if (serverGroup == null || !dispatcherToSGMap.get(keySetArray[i]).equals(serverGroup)) continue;
            matchingDispatchersList.add(keySetArray[i]);
        }
        dispatchers = matchingDispatchersList.toArray(new String[0]);
        Arrays.sort(dispatchers);
        return dispatchers;
    }

    private void loadDispatcherToServerGroupMap() {
        try {
            QueryServerGroupCMCommand command = new QueryServerGroupCMCommand(ALL_DISPATCHER_XPATH);
            command.setDoTrustedRequest(true);
            command.execute();
            this.rolapDispatcherDefaultNameToServerGroupMap = command.getDispatcherDefaultNameToServerGroupMap();
            this.rolapDispatcherDefaultNameToIDMap = command.getDispatcherDefaultNameToIDMap();
        }
        catch (Exception e) {
            this.errorLogger.log(e.getMessage());
            if (e.getMessage() == null) {
                this.errorLogger.log("NullPointerException");
            }
            this.errorLogger.log(e.getMessage());
        }
    }

    public String getDispatcherDefaultNameFromNameToIDMap(String selectedDispatcherID) {
        Set<String> keySet = this.rolapDispatcherDefaultNameToIDMap.keySet();
        Iterator<String> iter = keySet.iterator();
        String dispatcherName = null;
        String dispatcherID = null;
        while (iter.hasNext()) {
            dispatcherName = iter.next();
            dispatcherID = this.rolapDispatcherDefaultNameToIDMap.get(dispatcherName);
            if (!dispatcherID.equalsIgnoreCase(selectedDispatcherID)) continue;
            return dispatcherName;
        }
        return null;
    }

    private void loadDatasourceSpecificFormFieldData(String dataSource) {
        if (this.dataSourceType.equals(ROLAP_DATASOURCE_TYPE)) {
            this.loadROLAPDatasourceSpecificFormFieldData();
        } else if (this.dataSourceType.equals(DMR_DATASOURCE_TYPE)) {
            this.loadDMRDatasourceSpecificFormFieldData();
        } else if (this.dataSourceType.equals(SAPBW_DATASOURCE_TYPE) || this.dataSourceType.equals(ESSBASE_DATASOURCE_TYPE) || this.dataSourceType.equals(LOLAP_DATASOURCE_TYPE)) {
            this.loadLOLAPDatasourceSpecificFormFieldData();
        } else {
            this.loadLOLAPDatasourceSpecificFormFieldData();
        }
    }

    private void loadROLAPDatasourceSpecificFormFieldData() {
        this.loadDispatcherToServerGroupMap();
        this.loadRolapOperationsMap();
        if (this.options != null && !this.options.equals("")) {
            OptionsXMLProcessor inputOptionsProcessor = new OptionsXMLProcessor();
            inputOptionsProcessor.initializeInputOptionsXML(this.options);
            inputOptionsProcessor.getInputTaskParameters();
            this.inputOperation = inputOptionsProcessor.getInputTaskType();
            this.inputCubeNames = inputOptionsProcessor.getROLAPCubes();
            this.inputDispatcherForROLAPType = inputOptionsProcessor.getROLAPDispatcher();
        } else {
            this.inputOperation = "";
            this.inputDispatcherForROLAPType = "";
            this.inputCubeNames = null;
        }
        this.selectedROLAPServerGroup = this.context.getRequestParameters().getValue(SELECTED_SG_FIELD_NAME);
        if ((this.selectedROLAPServerGroup == null || this.selectedROLAPServerGroup.equals("")) && this.inputDispatcherForROLAPType != null && !this.inputDispatcherForROLAPType.equals("")) {
            this.selectedROLAPServerGroup = this.rolapDispatcherDefaultNameToServerGroupMap.get(this.getDispatcherDefaultNameFromNameToIDMap(this.inputDispatcherForROLAPType));
        }
        this.selectedROLAPDispatcher = this.context.getRequestParameters().getValue(SELECTED_DISPATCHER_FIELD_NAME);
        if ((this.selectedROLAPDispatcher == null || this.selectedROLAPDispatcher.equals("")) && this.inputDispatcherForROLAPType != null && !this.inputDispatcherForROLAPType.equals("")) {
            this.selectedROLAPDispatcher = this.inputDispatcherForROLAPType;
        }
        this.selectedROLAPOperation = this.context.getRequestParameters().getValue(SELECTED_OPERATION_FIELD_NAME);
        if ((this.selectedROLAPOperation == null || this.selectedROLAPOperation.equals("")) && this.inputOperation != null && !this.inputOperation.equals("")) {
            this.selectedROLAPOperation = this.inputOperation;
        }
        Parameters params = this.context.getRequestParameters();
        Iterator iter = params.iterator();
        Parameters.NameValuePair param = null;
        while (iter.hasNext()) {
            param = (Parameters.NameValuePair)iter.next();
            if (param.getName().indexOf(XQE_CUBES_CHECKBOX) < 0 || param.getName().indexOf("HIDDEN") >= 0) continue;
            this.selectedROLAPCubes.add(param.getValue());
        }
    }

    private void loadLOLAPDatasourceSpecificFormFieldData() {
        this.loadCacheOperationsMap();
        if (this.options != null && !this.options.equals("")) {
            OptionsXMLProcessor inputOptionsProcessor = new OptionsXMLProcessor();
            inputOptionsProcessor.initializeInputOptionsXML(this.options);
            inputOptionsProcessor.getInputTaskParameters();
            this.inputOperation = inputOptionsProcessor.getInputTaskType();
            this.inputDs = inputOptionsProcessor.getInputElement(DS_HTML_DDLIST_NAME);
            this.inputCtlg = inputOptionsProcessor.getInputElement(CATALOGS_HTML_DDLIST_NAME);
            this.inputCube = inputOptionsProcessor.getInputElement(CUBES_HTML_DDLIST_NAME);
        } else {
            this.inputOperation = "";
            this.inputDs = "";
            this.inputCtlg = "";
            this.inputCube = "";
        }
    }

    private void loadDMRDatasourceSpecificFormFieldData() {
        this.loadCacheOperationsMap();
        if (this.options != null && !this.options.equals("")) {
            OptionsXMLProcessor inputOptionsProcessor = new OptionsXMLProcessor();
            inputOptionsProcessor.initializeInputOptionsXML(this.options);
            inputOptionsProcessor.getInputTaskParameters();
            this.inputOperation = inputOptionsProcessor.getInputTaskType();
            this.inputDs = inputOptionsProcessor.getInputElement(DS_HTML_DDLIST_NAME);
            this.inputPackage = inputOptionsProcessor.getInputElement("Package");
        } else {
            this.inputOperation = "";
            this.inputDs = "";
            this.inputPackage = "";
        }
    }

    private void setDatasourceType() {
        OptionsXMLProcessor inputOptionsProcessor = null;
        if (this.dataSourceType == null || this.dataSourceType.equals("")) {
            if (this.options != null && !this.options.equals("")) {
                inputOptionsProcessor = new OptionsXMLProcessor();
                inputOptionsProcessor.initializeInputOptionsXML(this.options);
                this.dataSourceType = inputOptionsProcessor.getDatasourceType();
            } else {
                this.dataSourceType = LOLAP_DATASOURCE_TYPE;
            }
        }
    }

    private boolean isROLAPCubeHidden(String rolapCubeName) {
        boolean isHidden = false;
        String hiddenStatus = null;
        hiddenStatus = this.rolapCubeDatasourceNameToHiddenStatusMap.get(rolapCubeName);
        isHidden = hiddenStatus == null || hiddenStatus.equals("") ? true : hiddenStatus.equalsIgnoreCase(STR_TRUE);
        return isHidden;
    }

    private boolean isROLAPCubeGreyed(String rolapCubeName) {
        boolean isGreyed = false;
        String grayedStatus = null;
        grayedStatus = this.rolapCubeDatasourceNameToHiddenStatusMap.get(rolapCubeName);
        isGreyed = grayedStatus != null && grayedStatus.equalsIgnoreCase(STR_TRUE);
        return isGreyed;
    }

    private Map<String, String> fetchAllROLAPCubeNamesAndHiddenStatusMapping() {
        HashMap<String, String> rolapCubeNameToHiddenStatusMap = new HashMap<String, String>();
        ContentManagerQueryCommand query = new ContentManagerQueryCommand("CAMID(\":\")/*[@objectClass='rolapDataSource' or@objectClass='rolapVirtualDataSource']");
        XMLString str = this.context.getBusHeader();
        String str1 = str.toString();
        Element element = null;
        List resultList = null;
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read((InputStream)new ByteArrayInputStream(str1.getBytes(UTF8)));
            element = doc.getRootElement();
        }
        catch (Exception e) {
            this.errorLogger.log(LogLevel.ERROR, (Throwable)e);
        }
        query.setBIBusHeader(element);
        query.addQueryPropertyName("defaultName");
        query.addQueryPropertyName("hidden");
        query.addQueryPropertyName("objectClass");
        resultList = null;
        try {
            query.execute();
            resultList = query.getResultList();
        }
        catch (CommandExecutionException ce) {
            this.errorLogger.log(LogLevel.ERROR, (Throwable)ce);
        }
        Element nextItemElement = null;
        Element defaultNameElement = null;
        Element hiddenStatusElement = null;
        Element defaultNameValueElement = null;
        Element hiddenStatusValueElement = null;
        String rolapCubeName = null;
        String rolapCubeHiddenStatus = null;
        if (resultList != null) {
            for (CMClass cmResult : resultList) {
                defaultNameElement = null;
                hiddenStatusElement = null;
                defaultNameValueElement = null;
                hiddenStatusValueElement = null;
                rolapCubeName = null;
                rolapCubeHiddenStatus = null;
                nextItemElement = cmResult.getItemElement();
                if (nextItemElement == null) continue;
                defaultNameElement = nextItemElement.element("defaultName");
                if (defaultNameElement != null && (defaultNameValueElement = defaultNameElement.element("value")) != null) {
                    rolapCubeName = defaultNameValueElement.getTextTrim();
                }
                if ((hiddenStatusElement = nextItemElement.element("hidden")) != null && (hiddenStatusValueElement = hiddenStatusElement.element("value")) != null) {
                    rolapCubeHiddenStatus = hiddenStatusValueElement.getTextTrim();
                }
                if (rolapCubeName == null || rolapCubeHiddenStatus == null) continue;
                rolapCubeNameToHiddenStatusMap.put(rolapCubeName, rolapCubeHiddenStatus);
            }
        }
        return rolapCubeNameToHiddenStatusMap;
    }

    private String getProductLocale() {
        return this.productLocale;
    }

    private void loadRolapOperationsMap() {
        for (OMOperation op : OMOperation.values()) {
            this.rolapOperationsMap.put(XqeQSATPage.getFullyQualifiedOMCubeOperation(op.getName()), XQEMessages.getMessage(op.getLabel(), LocaleConverter.strToLocale(this.getProductLocale())));
        }
    }

    private void loadCacheOperationsMap() {
        this.cacheOperationsMap.put("Clear cache", XqeSALMetrics.getFlushOperationLocalizedName(this.getProductLocale()));
        this.cacheOperationsMap.put("Write cache state", XqeSALMetrics.getDumpOperationLocalizedName(this.getProductLocale()));
    }

    private String tweakInputProductLocaleString(String locale) {
        int firstIndexOfHyphen = -1;
        firstIndexOfHyphen = locale != null ? locale.indexOf("-") : -1;
        if (firstIndexOfHyphen > 0) {
            String localePrefix = locale.substring(0, firstIndexOfHyphen);
            String localeSuffix = locale.substring(firstIndexOfHyphen + 1);
            return localePrefix + UNDERSCORE + localeSuffix.toUpperCase();
        }
        return locale;
    }

    private class Cube
    implements Comparable {
        private String name;
        private boolean isVirtual = false;
        private String label;

        Cube(String cubeName, String type, String cubeLabel) {
            this.name = cubeName;
            this.isVirtual = type.endsWith("rolapVirtualDataSource");
            this.label = cubeLabel;
        }

        public String toString() {
            return this.label;
        }

        public int compareTo(Object cubeName) {
            return this.label.compareTo(cubeName.toString());
        }
    }

    public static enum OMOperation {
        ClearCubeWorkload("clearROLAPCubeWorkloadLog", XQEMessageKeys.UI_xqeROLAPQSATClearWorkloadLogOperation),
        RefreshCubeDataCache("refreshROLAPCubeDataCache", XQEMessageKeys.UI_xqeROLAPQSATRefreshDataCacheOperation),
        RefreshCubeMemberCache("refreshROLAPCubeMemberCache", XQEMessageKeys.UI_xqeROLAPQSATRefreshMemberCacheOperation),
        RefreshCubeSecurity("refreshROLAPCubeSecurity", XQEMessageKeys.UI_xqeROLAPQSATRefreshSecuritySettingsOperation),
        RestartCubes("restartROLAPCubes", XQEMessageKeys.UI_xqeROLAPQSATRestartOperation),
        StartCubes("startROLAPCubes", XQEMessageKeys.UI_xqeROLAPQSATStartOperation),
        StartCubesAndSourceCubes("startROLAPCubesAndSourceCubes", XQEMessageKeys.UI_xqeROLAPQSATStartCubesAndSourceCubesOperation),
        StopCubes("stopROLAPCubes", XQEMessageKeys.UI_xqeROLAPQSATStopOperation),
        StopCubesImmediately("stopROLAPCubesImmediately", XQEMessageKeys.UI_xqeROLAPQSATStopImmediatelyOperation),
        IncrementallyLoadCubes("incrementallyLoadROLAPCubes", XQEMessageKeys.UI_xqeROLAPQSATIncrementallyLoadOperation),
        PauseCubes("pauseROLAPCubes", XQEMessageKeys.UI_xqeROLAPQSATPauseOperation);

        private final String mName;
        private final IMessageKey.Param0 mLabel;

        private OMOperation(String name, IMessageKey.Param0 label) {
            this.mName = name;
            this.mLabel = label;
        }

        public String getName() {
            return this.mName;
        }

        public IMessageKey.Param0 getLabel() {
            return this.mLabel;
        }
    }
}

