/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.qsat.rolap.server;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.QName;

public class QueryROLAPCubesCMCommand
extends ContentManagerCommand {
    public static final String NO_CUBE_FOUND = "No Cube Found";
    private List<String> cubeList = new ArrayList<String>();
    private static final String BUS_PROP_ENUM = "bus:propEnum";
    private static final String ITEM = "item";
    private static final String QUERY = "query";
    private String searchPathToQuery = null;
    protected static final QName BUS_QUERY = new QName("query", BUS_NAMESPACE);
    private static final QName BUS_QUERYRESPONSE = new QName("queryResponse", BUS_NAMESPACE);
    private static final String QS_ROLAP_CUBE_CONFIGURATIONSELEMENT = "qsROLAPCubeConfigurations";

    public QueryROLAPCubesCMCommand(String sp) {
        this.searchPathToQuery = sp;
    }

    protected void executeImpl(Element bodyElement) throws CommandExecutionException {
        Element queryElement = bodyElement.addElement(BUS_QUERY);
        Element searchElement = queryElement.addElement("search");
        searchElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        searchElement.addText(this.searchPathToQuery);
        Element propertiesElement = queryElement.addElement("properties");
        propertiesElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.SOAP_ENC_ARRAY);
        propertiesElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, "bus:propEnum[1]");
        Element itemElementServerGroup = propertiesElement.addElement(ITEM);
        itemElementServerGroup.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_PROP_ENUM);
        itemElementServerGroup.addText(QS_ROLAP_CUBE_CONFIGURATIONSELEMENT);
        this.addSessionRequestIds("runtimeInfo");
    }

    protected void handleResponseImpl(Element bodyElement) throws CommandExecutionException {
        Element resultElement;
        Element queryResponse = bodyElement.element(BUS_QUERYRESPONSE);
        if (queryResponse != null && (resultElement = queryResponse.element("queryResult")) != null) {
            List itemElements = resultElement.elements();
            for (Element itemElement : itemElements) {
                List cubeList = itemElement.elements();
                String qsROLAPCubeConfigurations = null;
                for (int j = 0; j < cubeList.size(); ++j) {
                    Element cubeElement = (Element)cubeList.get(j);
                    List valueList = cubeElement.elements();
                    if (valueList.size() <= 0) continue;
                    for (int k = 0; k < valueList.size(); ++k) {
                        Element value = (Element)valueList.get(k);
                        Iterator elementIter = value.elementIterator();
                        Element rolapCubeConfigurationsItemElement = null;
                        Element dataSourceName = null;
                        while (elementIter.hasNext()) {
                            rolapCubeConfigurationsItemElement = (Element)elementIter.next();
                            dataSourceName = rolapCubeConfigurationsItemElement.element("dataSourceName");
                            qsROLAPCubeConfigurations = dataSourceName.getTextTrim();
                            this.addCubeToList(qsROLAPCubeConfigurations);
                        }
                    }
                }
            }
        }
    }

    private void addCubeToList(String cubeConfig) {
        this.cubeList.add(cubeConfig);
    }

    public List<String> getCubeList() {
        return this.cubeList;
    }
}

