/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.server;

import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration.StringResources;
import com.cognos.xqebifw.adminconsole.server.XqeConfigEnum;
import com.cognos.xqebifw.adminconsole.server.XqeUIBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class AbstractXqeUIBean
implements XqeUIBean {
    protected List<XqeConfigEnum> mEnums = null;
    protected Object mValue = null;
    private String mName = null;
    private Map<String, XqeUIBean> mChildren = new HashMap<String, XqeUIBean>();
    private static ResourceBundle bundle = StringResources.getResourceBundle(StringResources.getGsResourceName(), LocaleConverter.strToLocale("en"));

    public List<XqeConfigEnum> getEnumerations() {
        return this.mEnums;
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }

    public AbstractXqeUIBean(String name) {
        this.mName = name;
    }

    private Object getResourceString(String key) {
        try {
            return bundle.getObject(key);
        }
        catch (MissingResourceException mre) {
            return key;
        }
    }

    @Override
    public String getLabel() {
        String key = "XQE_ADMIN_LABEL_" + this.mName;
        Object label = this.getResourceString(key);
        if (label != null) {
            return label.toString();
        }
        return this.mName;
    }

    @Override
    public String getDescription() {
        String key = "XQE_ADMIN_DESC_" + this.mName;
        Object desc = this.getResourceString(key);
        if (desc != null) {
            return desc.toString();
        }
        return this.mName;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void addChild(XqeUIBean child) {
        this.mChildren.put(child.getName(), child);
    }

    @Override
    public XqeUIBean getChild(String name) {
        return this.mChildren.get(name);
    }
}

