/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.server;

import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqebifw.adminconsole.server.AdminConsoleDefaultConfigUtility;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JmxUtils {
    public static final int DEFAULT_JMX_REQUEST_WAITING_TIMEOUT = 300000;
    public static final String JMX_REQUEST_WAITING_TIMEOUT = "request.waiting.timeout";
    public static final String ERRMSG_XQEJMX_URL = "XQE JMX URL is ";
    public static final String FOR_JMX_URL_CREDENTIALS_STR = "for XQE JMX URL Credentials ";
    public static final String FOR_JMX_URL_STR = " for XQE JMX URL ";
    public static final String FLUSH = "flush";
    public static final String DUMP = "dump";
    public static final String DUMP_DMR_CACHE = "dumpDMRCache";
    public static final String FLUSH_DMR_CACHE = "flushDMRCache";
    public static final String QUERYSERVICE_INSTANCE_NO_LONGER_EXISTS = "Query Service Instance  no longer exists for ";
    public static final String GETALLQSINSTANCESJMXURL_METHOD_NAME = "getAllQSInstancesJMXURL";
    public static final String GETCREDENTIALS_METHOD_NAME = "getCredentials";
    public static final String NO_CACHED_OBJECTS = "No Cached Objects";
    private static final int SLEEP_TIME = 1000;
    private static final int MAX_GET_CONNECTION_RETRY_COUNT = 5;
    private static final String URL = "Url";
    private static final String CREDENTIALS = "Credentials";
    public static final String JMX_URL_MBEAN_NAME = "com.cognos:type=config,service=XqeJMXConfigMBean";
    public static final String XQE_JMXURLHOLDERBEAN_ADDRESS_PROXY_PATTERN = "com.cognos:type=Metrics,service=XqeJMXConfigMBean";
    private static final String DISP_EXCEPTION_MSG = "Could not query dispatcher ";
    private static final String XQE_MBEAN_JMX_CONFIG_PATTERN = "com.cognos:type=Metrics,service=XqeJMXConfigMBean,dispatcher=";
    private static final String XQE_MBEAN_XQE_SERVICE_PATTERN = "com.cognos:type=XQEConfig,service=xqeService";
    private static final String XQE_MBEAN_SAVE_SERVICE_PATTERN = "com.cognos:type=XQEOperations,service=xqeService";
    private static final String XQE_MBEAN_ALL_DISPATCHER_PATTERN = "com.cognos:type=Metrics,service=XqeJMXConfigMBean,*";
    private static final String XQE_MBEAN_SAL_SERVICE_PATTERN = "com.cognos:type=salMetrics,service=xqeMetricsService";
    private static final String ESCAPED_DOUBLE_QUOTES = "\"";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    static XQELogger errorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public static Object getConfigAttributeValue(String attributeName, String dispatcherName) {
        JMXConnector connector = JmxUtils.getJMXConnector(dispatcherName);
        try {
            Object value;
            MBeanServerConnection mbeanServerConnection = connector.getMBeanServerConnection();
            StringBuilder objNameBuilder = new StringBuilder();
            objNameBuilder.append(XQE_MBEAN_XQE_SERVICE_PATTERN);
            String objectName = objNameBuilder.toString();
            ObjectName obName = new ObjectName(objectName);
            Object object = value = mbeanServerConnection.getAttribute(obName, attributeName);
            return object;
        }
        catch (MalformedObjectNameException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (AttributeNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (connector != null) {
                    connector.close();
                }
            }
            catch (IOException e) {
                errorLogger.log(e);
                throw new RuntimeException(e);
            }
        }
    }

    private static MBeanServerConnection getProxyMBeanServer(String dispatcherName) {
        return PogoMBeanServer.getInstance().getProxyMBeanServer();
    }

    private static JMXConnector getJMXConnector(String dispatcherName) {
        String xqeJmxUrl = null;
        int retryCount = 0;
        for (retryCount = 0; retryCount < 5; ++retryCount) {
            try {
                String credentials = null;
                JMXServiceURL url = null;
                if (dispatcherName == null) {
                    xqeJmxUrl = AdminConsoleDefaultConfigUtility.getDefaultXqeJmxUrl()[0];
                    credentials = AdminConsoleDefaultConfigUtility.getDispatcherDefaultPassword();
                } else {
                    xqeJmxUrl = JmxUtils.getXqeJmxUrl(dispatcherName, null);
                    credentials = JmxUtils.getCredentials(dispatcherName, xqeJmxUrl, null);
                }
                url = new JMXServiceURL(xqeJmxUrl);
                HashMap<String, Object> environment = new HashMap<String, Object>();
                environment.put("jmx.remote.credentials", credentials);
                environment.put(JMX_REQUEST_WAITING_TIMEOUT, 300000);
                return JMXConnectorFactory.connect(url, environment);
            }
            catch (MalformedURLException e) {
                errorLogger.log(e);
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                errorLogger.log(e);
                errorLogger.log(ERRMSG_XQEJMX_URL + xqeJmxUrl);
                errorLogger.log("Dispatcher is " + dispatcherName);
                if (retryCount >= 4) {
                    throw new RuntimeException(QUERYSERVICE_INSTANCE_NO_LONGER_EXISTS + dispatcherName);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    errorLogger.log(e1);
                }
                continue;
            }
        }
        return null;
    }

    public static void setConfigAttributeValue(String attributeName, Object value, String dispatcherName) {
        JMXConnector connector = JmxUtils.getJMXConnector(dispatcherName);
        try {
            MBeanServerConnection mbeanServerConnection = connector.getMBeanServerConnection();
            StringBuilder objNameBuilder = new StringBuilder();
            objNameBuilder.append(XQE_MBEAN_SAVE_SERVICE_PATTERN);
            ObjectName obName = new ObjectName(objNameBuilder.toString());
            mbeanServerConnection.invoke(obName, "saveXQEConfigurationValue", new Object[]{attributeName, value}, new String[]{JAVA_LANG_STRING, JAVA_LANG_OBJECT});
        }
        catch (MalformedObjectNameException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (connector != null) {
                    connector.close();
                }
            }
            catch (IOException e) {
                errorLogger.log(e);
                throw new RuntimeException(e);
            }
        }
    }

    public static Set<String> getDispatcherNames() {
        HashSet<String> dispatcherNames = new HashSet<String>();
        try {
            Set<ObjectName> objNames = JmxUtils.getProxyMBeanServer(null).queryNames(new ObjectName(XQE_MBEAN_ALL_DISPATCHER_PATTERN), null);
            for (ObjectName objName : objNames) {
                String dispatcherName = objName.getKeyProperty("dispatcher");
                if (dispatcherName == null) continue;
                dispatcherNames.add(JmxUtils.trimQoutes(dispatcherName));
            }
        }
        catch (MalformedObjectNameException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        return dispatcherNames;
    }

    private static String trimQoutes(String dispatcherName) {
        if (dispatcherName.startsWith(ESCAPED_DOUBLE_QUOTES) && dispatcherName.endsWith(ESCAPED_DOUBLE_QUOTES)) {
            dispatcherName = dispatcherName.substring(1, dispatcherName.length() - 1);
        }
        return dispatcherName;
    }

    public static void saveXQEConfigurationToFile(String dispatcherName) {
        JMXConnector connector = null;
        try {
            String xqeJmxUrl = null;
            String credentials = null;
            if (dispatcherName == null) {
                xqeJmxUrl = AdminConsoleDefaultConfigUtility.getDefaultXqeJmxUrl()[0];
                credentials = AdminConsoleDefaultConfigUtility.getDispatcherDefaultPassword();
            } else {
                xqeJmxUrl = JmxUtils.getXqeJmxUrl(dispatcherName, null);
                credentials = JmxUtils.getCredentials(dispatcherName, xqeJmxUrl, null);
            }
            StringBuilder objNameBuilder = new StringBuilder();
            objNameBuilder.append(XQE_MBEAN_SAVE_SERVICE_PATTERN);
            ObjectName obName = new ObjectName(objNameBuilder.toString());
            JMXServiceURL url = new JMXServiceURL(xqeJmxUrl);
            HashMap<String, Object> environment = new HashMap<String, Object>();
            environment.put("jmx.remote.credentials", credentials);
            environment.put(JMX_REQUEST_WAITING_TIMEOUT, 300000);
            connector = JMXConnectorFactory.connect(url, environment);
            MBeanServerConnection mbeanServerConnection = connector.getMBeanServerConnection();
            mbeanServerConnection.invoke(obName, "saveXQEConfiguration", new Object[0], new String[0]);
        }
        catch (MalformedObjectNameException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (connector != null) {
                    connector.close();
                }
            }
            catch (IOException e) {
                errorLogger.log(e);
                throw new RuntimeException(e);
            }
        }
    }

    public static String getXqeJmxUrl(String dispatcherName, MBeanServerConnection con) {
        ObjectName obName = null;
        String[] array = null;
        StringBuilder objNameBuilder = new StringBuilder();
        String objectName = null;
        String url = null;
        try {
            if (con == null) {
                if (dispatcherName.equals("localdispatcher")) {
                    objNameBuilder.append(JMX_URL_MBEAN_NAME);
                    objectName = objNameBuilder.toString();
                    obName = new ObjectName(objectName);
                    url = (String)PogoMBeanServer.getInstance().getServer().getAttribute(obName, URL);
                } else {
                    objNameBuilder.append(XQE_MBEAN_JMX_CONFIG_PATTERN);
                    objNameBuilder.append(ESCAPED_DOUBLE_QUOTES);
                    objNameBuilder.append(dispatcherName);
                    objNameBuilder.append(ESCAPED_DOUBLE_QUOTES);
                    objectName = objNameBuilder.toString();
                    obName = new ObjectName(objectName);
                    url = (String)PogoMBeanServer.getInstance().getProxyMBeanServer().getAttribute(obName, URL);
                }
                array = new String[]{url};
            } else {
                objNameBuilder.append(JMX_URL_MBEAN_NAME);
                objectName = objNameBuilder.toString();
                obName = new ObjectName(objectName);
                url = (String)con.getAttribute(obName, URL);
                array = new String[]{url};
            }
        }
        catch (InstanceNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException("Could not query dispatcher  for XQE JMX URL " + dispatcherName);
        }
        catch (AttributeNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MalformedObjectNameException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        if (dispatcherName != null && !dispatcherName.equals("localdispatcher")) {
            URL dispURL = null;
            try {
                dispURL = new URL(dispatcherName);
            }
            catch (MalformedURLException e) {
                errorLogger.log(e);
                throw new RuntimeException(e);
            }
            for (int i = 0; i < array.length; ++i) {
                if (array[i].indexOf(dispURL.getHost()) < 0) continue;
                return array[i];
            }
        } else if (array != null) {
            return array[0];
        }
        return null;
    }

    public static String getCredentials(String dispatcherName, String url, MBeanServerConnection con) {
        ObjectName obName = null;
        String credentials = null;
        StringBuilder objNameBuilder = new StringBuilder();
        String objectName = null;
        try {
            if (con == null) {
                if (dispatcherName.equals("localdispatcher")) {
                    objNameBuilder.append(JMX_URL_MBEAN_NAME);
                    objectName = objNameBuilder.toString();
                    obName = new ObjectName(objectName);
                    credentials = (String)PogoMBeanServer.getInstance().getServer().getAttribute(obName, CREDENTIALS);
                } else {
                    objNameBuilder.append(XQE_MBEAN_JMX_CONFIG_PATTERN);
                    objNameBuilder.append(ESCAPED_DOUBLE_QUOTES);
                    objNameBuilder.append(dispatcherName);
                    objNameBuilder.append(ESCAPED_DOUBLE_QUOTES);
                    objectName = objNameBuilder.toString();
                    obName = new ObjectName(objectName);
                    credentials = (String)PogoMBeanServer.getInstance().getProxyMBeanServer().getAttribute(obName, CREDENTIALS);
                }
            } else {
                objNameBuilder.append(JMX_URL_MBEAN_NAME);
                objectName = objNameBuilder.toString();
                obName = new ObjectName(objectName);
                credentials = (String)con.getAttribute(obName, CREDENTIALS);
            }
        }
        catch (InstanceNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException("Could not query dispatcher for XQE JMX URL Credentials " + dispatcherName);
        }
        catch (AttributeNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MalformedObjectNameException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        return credentials;
    }

    public static void dumpSALCache(String dispatcherName) {
        JMXConnector connector = JmxUtils.getJMXConnector(dispatcherName);
        try {
            MBeanServerConnection mbeanServerConnection = connector.getMBeanServerConnection();
            StringBuilder objNameBuilder = new StringBuilder();
            objNameBuilder.append(XQE_MBEAN_SAL_SERVICE_PATTERN);
            ObjectName obName = new ObjectName(objNameBuilder.toString());
            mbeanServerConnection.invoke(obName, DUMP, new Object[0], new String[0]);
        }
        catch (MalformedObjectNameException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (connector != null) {
                    connector.close();
                }
            }
            catch (IOException e) {
                errorLogger.log(e);
                throw new RuntimeException(e);
            }
        }
    }

    public static void flushSALCache(String dispatcherName) {
        JMXConnector connector = JmxUtils.getJMXConnector(dispatcherName);
        try {
            MBeanServerConnection mbeanServerConnection = connector.getMBeanServerConnection();
            StringBuilder objNameBuilder = new StringBuilder();
            objNameBuilder.append(XQE_MBEAN_SAL_SERVICE_PATTERN);
            ObjectName obName = new ObjectName(objNameBuilder.toString());
            mbeanServerConnection.invoke(obName, FLUSH, new Object[0], new String[0]);
        }
        catch (MalformedObjectNameException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (connector != null) {
                    connector.close();
                }
            }
            catch (IOException e) {
                errorLogger.log(e);
                throw new RuntimeException(e);
            }
        }
    }

    public static String[] fetchCachedDataSources(String dispatcherName) {
        String[] cachedDatasources = null;
        JMXConnector connector = JmxUtils.getJMXConnector(dispatcherName);
        try {
            MBeanServerConnection mbeanServerConnection = connector.getMBeanServerConnection();
            StringBuilder objNameBuilder = new StringBuilder();
            objNameBuilder.append(XQE_MBEAN_SAL_SERVICE_PATTERN);
            ObjectName obName = new ObjectName(objNameBuilder.toString());
            cachedDatasources = (String[])mbeanServerConnection.invoke(obName, "getCachedDatasources", new Object[0], new String[0]);
            if (cachedDatasources == null || cachedDatasources.length == 0) {
                cachedDatasources = new String[]{NO_CACHED_OBJECTS};
            }
            String[] stringArray = cachedDatasources;
            return stringArray;
        }
        catch (MalformedObjectNameException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (connector != null) {
                    connector.close();
                }
            }
            catch (IOException e) {
                errorLogger.log(e);
                throw new RuntimeException(e);
            }
        }
    }

    public static String[] fetchCachedCatalogs(String dispatcherName, String datasource) {
        String[] cachedCatalogs = null;
        JMXConnector connector = JmxUtils.getJMXConnector(dispatcherName);
        try {
            if (datasource.equals(NO_CACHED_OBJECTS)) {
                String[] stringArray = cachedCatalogs = new String[]{NO_CACHED_OBJECTS};
                return stringArray;
            }
            MBeanServerConnection mbeanServerConnection = connector.getMBeanServerConnection();
            StringBuilder objNameBuilder = new StringBuilder();
            objNameBuilder.append(XQE_MBEAN_SAL_SERVICE_PATTERN);
            ObjectName obName = new ObjectName(objNameBuilder.toString());
            cachedCatalogs = (String[])mbeanServerConnection.invoke(obName, "getCachedCatalogs", new Object[]{datasource}, new String[]{JAVA_LANG_STRING});
            if (cachedCatalogs == null || cachedCatalogs.length == 0) {
                cachedCatalogs = new String[]{NO_CACHED_OBJECTS};
            }
            String[] stringArray = cachedCatalogs;
            return stringArray;
        }
        catch (MalformedObjectNameException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (connector != null) {
                    connector.close();
                }
            }
            catch (IOException e) {
                errorLogger.log(e);
                throw new RuntimeException(e);
            }
        }
    }

    public static String[] fetchCachedCubes(String dispatcherName, String datasource, String catalogName) {
        String[] cachedCubes = null;
        JMXConnector connector = JmxUtils.getJMXConnector(dispatcherName);
        try {
            if (datasource.equals(NO_CACHED_OBJECTS) || catalogName.equals(NO_CACHED_OBJECTS)) {
                String[] stringArray = cachedCubes = new String[]{NO_CACHED_OBJECTS};
                return stringArray;
            }
            MBeanServerConnection mbeanServerConnection = connector.getMBeanServerConnection();
            StringBuilder objNameBuilder = new StringBuilder();
            objNameBuilder.append(XQE_MBEAN_SAL_SERVICE_PATTERN);
            ObjectName obName = new ObjectName(objNameBuilder.toString());
            cachedCubes = (String[])mbeanServerConnection.invoke(obName, "getCachedCubes", new Object[]{datasource, catalogName}, new String[]{JAVA_LANG_STRING, JAVA_LANG_STRING});
            if (cachedCubes == null || cachedCubes.length == 0) {
                cachedCubes = new String[]{NO_CACHED_OBJECTS};
            }
            String[] stringArray = cachedCubes;
            return stringArray;
        }
        catch (MalformedObjectNameException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (connector != null) {
                    connector.close();
                }
            }
            catch (IOException e) {
                errorLogger.log(e);
                throw new RuntimeException(e);
            }
        }
    }

    public static String[] fetchCacheOperations(String dispatcherName) {
        String[] cacheOperations = null;
        JMXConnector connector = JmxUtils.getJMXConnector(dispatcherName);
        try {
            MBeanServerConnection mbeanServerConnection = connector.getMBeanServerConnection();
            StringBuilder objNameBuilder = new StringBuilder();
            objNameBuilder.append(XQE_MBEAN_SAL_SERVICE_PATTERN);
            ObjectName obName = new ObjectName(objNameBuilder.toString());
            cacheOperations = (String[])mbeanServerConnection.invoke(obName, "getCacheOperations", new Object[0], new String[0]);
            if (cacheOperations == null || cacheOperations.length == 0) {
                cacheOperations = new String[]{};
            }
            String[] stringArray = cacheOperations;
            return stringArray;
        }
        catch (MalformedObjectNameException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (connector != null) {
                    connector.close();
                }
            }
            catch (IOException e) {
                errorLogger.log(e);
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean submitFlushQESALCaches(String dispatcherName, String dataSource, String catalog, String cube) {
        JMXConnector connector = null;
        String[] jmxUrls = null;
        Boolean[] resultArray = null;
        try {
            jmxUrls = dispatcherName == null ? AdminConsoleDefaultConfigUtility.getDefaultXqeJmxUrl() : JmxUtils.getAllXqeJMXURls(dispatcherName, null);
            resultArray = new Boolean[jmxUrls.length];
            for (int i = 0; i < jmxUrls.length; ++i) {
                try {
                    Boolean flushStatus;
                    String xqeJmxUrl = jmxUrls[i];
                    String credential = null;
                    credential = dispatcherName == null ? AdminConsoleDefaultConfigUtility.getDispatcherDefaultPassword() : JmxUtils.getPassword(dispatcherName, xqeJmxUrl, null);
                    connector = JmxUtils.getXQEMBeanServerConnection(dispatcherName, xqeJmxUrl, credential);
                    MBeanServerConnection mbeanServerConnection = connector.getMBeanServerConnection();
                    StringBuilder objNameBuilder = new StringBuilder();
                    objNameBuilder.append(XQE_MBEAN_SAL_SERVICE_PATTERN);
                    ObjectName obName = new ObjectName(objNameBuilder.toString());
                    resultArray[i] = flushStatus = (Boolean)mbeanServerConnection.invoke(obName, FLUSH, new Object[]{dataSource, catalog, cube}, new String[]{JAVA_LANG_STRING, JAVA_LANG_STRING, JAVA_LANG_STRING});
                    continue;
                }
                catch (MalformedObjectNameException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (InstanceNotFoundException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (ReflectionException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (MBeanException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (IOException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (Exception e) {
                    errorLogger.log(e);
                }
            }
        }
        catch (Exception e) {
            errorLogger.log(e);
        }
        finally {
            if (connector != null) {
                try {
                    connector.close();
                }
                catch (IOException e) {
                    errorLogger.log(e);
                }
            }
        }
        boolean commandExecutedSuccessfully = true;
        for (Boolean flag : resultArray) {
            if (flag != null && flag.booleanValue()) continue;
            commandExecutedSuccessfully = false;
            break;
        }
        return commandExecutedSuccessfully;
    }

    public static String[] getAllXqeJMXURls(String dispatcherName, MBeanServerConnection con) {
        ObjectName obName = null;
        StringBuilder objNameBuilder = new StringBuilder();
        String objectName = null;
        String[] urls = null;
        try {
            if (con == null) {
                if (dispatcherName.equals("localdispatcher")) {
                    objNameBuilder.append(JMX_URL_MBEAN_NAME);
                    objectName = objNameBuilder.toString();
                    obName = new ObjectName(objectName);
                    urls = (String[])PogoMBeanServer.getInstance().getServer().getAttribute(obName, URL);
                } else {
                    objNameBuilder.append(XQE_MBEAN_JMX_CONFIG_PATTERN);
                    objNameBuilder.append(ESCAPED_DOUBLE_QUOTES);
                    objNameBuilder.append(dispatcherName);
                    objNameBuilder.append(ESCAPED_DOUBLE_QUOTES);
                    objectName = objNameBuilder.toString();
                    obName = new ObjectName(objectName);
                    urls = (String[])PogoMBeanServer.getInstance().getProxyMBeanServer().getAttribute(obName, URL);
                }
            } else {
                objNameBuilder.append(JMX_URL_MBEAN_NAME);
                objectName = objNameBuilder.toString();
                obName = new ObjectName(objectName);
                urls = (String[])con.getAttribute(obName, URL);
            }
        }
        catch (InstanceNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException("Could not query dispatcher  for XQE JMX URL " + dispatcherName);
        }
        catch (ReflectionException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MalformedObjectNameException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (AttributeNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        return urls;
    }

    public static String getPassword(String dispatcherName, String url, MBeanServerConnection con) {
        ObjectName obName = null;
        String credentials = null;
        StringBuilder objNameBuilder = new StringBuilder();
        String objectName = null;
        try {
            if (con == null) {
                if (dispatcherName.equals("localdispatcher")) {
                    objNameBuilder.append(JMX_URL_MBEAN_NAME);
                    objectName = objNameBuilder.toString();
                    obName = new ObjectName(objectName);
                    credentials = (String)PogoMBeanServer.getInstance().getServer().getAttribute(obName, CREDENTIALS);
                } else {
                    objNameBuilder.append(XQE_MBEAN_JMX_CONFIG_PATTERN);
                    objNameBuilder.append(ESCAPED_DOUBLE_QUOTES);
                    objNameBuilder.append(dispatcherName);
                    objNameBuilder.append(ESCAPED_DOUBLE_QUOTES);
                    objectName = objNameBuilder.toString();
                    obName = new ObjectName(objectName);
                    credentials = (String)PogoMBeanServer.getInstance().getProxyMBeanServer().getAttribute(obName, CREDENTIALS);
                }
            } else {
                objNameBuilder.append(JMX_URL_MBEAN_NAME);
                objectName = objNameBuilder.toString();
                obName = new ObjectName(objectName);
                credentials = (String)con.getAttribute(obName, CREDENTIALS);
            }
        }
        catch (InstanceNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException("Could not query dispatcher for XQE JMX URL Credentials " + dispatcherName);
        }
        catch (ReflectionException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MalformedObjectNameException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (AttributeNotFoundException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        return credentials;
    }

    private static JMXConnector getXQEMBeanServerConnection(String dispatcherName, String jmxUrl, String credentials) {
        int retryCount = 0;
        JMXServiceURL url = null;
        for (retryCount = 0; retryCount < 5; ++retryCount) {
            try {
                url = new JMXServiceURL(jmxUrl);
                HashMap<String, Object> environment = new HashMap<String, Object>();
                environment.put("jmx.remote.credentials", credentials);
                environment.put(JMX_REQUEST_WAITING_TIMEOUT, 300000);
                return JMXConnectorFactory.connect(url, environment);
            }
            catch (MalformedURLException e) {
                errorLogger.log(e);
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                errorLogger.log(e);
                errorLogger.log(ERRMSG_XQEJMX_URL + jmxUrl);
                if (retryCount >= 4) {
                    throw new RuntimeException(QUERYSERVICE_INSTANCE_NO_LONGER_EXISTS + dispatcherName);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    errorLogger.log(e1);
                }
                continue;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean submitDumpQESALCaches(String dispatcherName, String dataSource, String catalog, String cube) {
        JMXConnector connector = null;
        String[] dumpFilePaths = null;
        String[] jmxUrls = null;
        try {
            jmxUrls = dispatcherName == null ? AdminConsoleDefaultConfigUtility.getDefaultXqeJmxUrl() : JmxUtils.getAllXqeJMXURls(dispatcherName, null);
            dumpFilePaths = new String[jmxUrls.length];
            for (int i = 0; i < jmxUrls.length; ++i) {
                try {
                    String dumpFilePath;
                    String xqeJmxUrl = jmxUrls[i];
                    String credential = null;
                    credential = dispatcherName == null ? AdminConsoleDefaultConfigUtility.getDispatcherDefaultPassword() : JmxUtils.getPassword(dispatcherName, xqeJmxUrl, null);
                    connector = JmxUtils.getXQEMBeanServerConnection(dispatcherName, xqeJmxUrl, credential);
                    MBeanServerConnection mbeanServerConnection = connector.getMBeanServerConnection();
                    StringBuilder objNameBuilder = new StringBuilder();
                    objNameBuilder.append(XQE_MBEAN_SAL_SERVICE_PATTERN);
                    ObjectName obName = new ObjectName(objNameBuilder.toString());
                    dumpFilePaths[i] = dumpFilePath = (String)mbeanServerConnection.invoke(obName, DUMP, new Object[]{dataSource, catalog, cube}, new String[]{JAVA_LANG_STRING, JAVA_LANG_STRING, JAVA_LANG_STRING});
                    continue;
                }
                catch (MalformedObjectNameException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (InstanceNotFoundException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (ReflectionException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (MBeanException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (IOException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (Exception e) {
                    errorLogger.log(e);
                }
            }
        }
        catch (Exception e) {
            errorLogger.log(e);
        }
        finally {
            if (connector != null) {
                try {
                    if (connector != null) {
                        connector.close();
                    }
                }
                catch (IOException e) {
                    errorLogger.log(e);
                }
            }
        }
        boolean commandExecutedSuccessfully = true;
        for (String str : dumpFilePaths) {
            if (str != null) continue;
            commandExecutedSuccessfully = false;
            break;
        }
        return commandExecutedSuccessfully;
    }

    public static boolean submitFlushDispSALCaches(String dataSource, String catalog, String cube) {
        boolean finalCommandExecutionSucceeded = true;
        try {
            String[] dispatchers;
            for (String dispatcher : dispatchers = JmxUtils.getDispatcherNames().toArray(new String[0])) {
                if (JmxUtils.submitFlushQESALCaches(dispatcher, dataSource, catalog, cube)) continue;
                finalCommandExecutionSucceeded = false;
            }
        }
        catch (Exception e) {
            finalCommandExecutionSucceeded = false;
            errorLogger.log(e);
        }
        return finalCommandExecutionSucceeded;
    }

    public static boolean submitDumpDispSALCaches(String dataSource, String catalog, String cube) {
        boolean finalCommandExecutionSucceeded = true;
        try {
            String[] dispatchers;
            for (String dispatcher : dispatchers = JmxUtils.getDispatcherNames().toArray(new String[0])) {
                if (JmxUtils.submitDumpQESALCaches(dispatcher, dataSource, catalog, cube)) continue;
                finalCommandExecutionSucceeded = false;
            }
        }
        catch (Exception e) {
            finalCommandExecutionSucceeded = false;
            errorLogger.log(e);
        }
        return finalCommandExecutionSucceeded;
    }

    public static boolean submitDMRDumpDispSALCaches(String dataSource, String packageName) {
        boolean finalCommandExecutionSucceeded = true;
        try {
            String[] dispatchers;
            for (String dispatcher : dispatchers = JmxUtils.getDispatcherNames().toArray(new String[0])) {
                if (JmxUtils.submitDMRDumpQESALCaches(dispatcher, dataSource, packageName)) continue;
                finalCommandExecutionSucceeded = false;
            }
        }
        catch (Exception e) {
            finalCommandExecutionSucceeded = false;
            errorLogger.log(e);
        }
        return finalCommandExecutionSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean submitDMRDumpQESALCaches(String dispatcherName, String dataSource, String packageName) {
        JMXConnector connector = null;
        String[] dumpFilePaths = null;
        String[] jmxUrls = null;
        try {
            jmxUrls = dispatcherName == null ? AdminConsoleDefaultConfigUtility.getDefaultXqeJmxUrl() : JmxUtils.getAllXqeJMXURls(dispatcherName, null);
            dumpFilePaths = new String[jmxUrls.length];
            for (int i = 0; i < jmxUrls.length; ++i) {
                try {
                    String dumpFilePath;
                    String xqeJmxUrl = jmxUrls[i];
                    String credential = null;
                    credential = dispatcherName == null ? AdminConsoleDefaultConfigUtility.getDispatcherDefaultPassword() : JmxUtils.getPassword(dispatcherName, xqeJmxUrl, null);
                    connector = JmxUtils.getXQEMBeanServerConnection(dispatcherName, xqeJmxUrl, credential);
                    MBeanServerConnection mbeanServerConnection = connector.getMBeanServerConnection();
                    StringBuilder objNameBuilder = new StringBuilder();
                    objNameBuilder.append(XQE_MBEAN_SAL_SERVICE_PATTERN);
                    ObjectName obName = new ObjectName(objNameBuilder.toString());
                    dumpFilePaths[i] = dumpFilePath = (String)mbeanServerConnection.invoke(obName, DUMP_DMR_CACHE, new Object[]{dataSource, packageName}, new String[]{JAVA_LANG_STRING, JAVA_LANG_STRING});
                    continue;
                }
                catch (MalformedObjectNameException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (InstanceNotFoundException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (ReflectionException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (MBeanException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (IOException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (Exception e) {
                    errorLogger.log(e);
                }
            }
        }
        catch (Exception e) {
            errorLogger.log(e);
        }
        finally {
            if (connector != null) {
                try {
                    if (connector != null) {
                        connector.close();
                    }
                }
                catch (IOException e) {
                    errorLogger.log(e);
                }
            }
        }
        boolean commandExecutedSuccessfully = true;
        for (String str : dumpFilePaths) {
            if (str != null) continue;
            commandExecutedSuccessfully = false;
            break;
        }
        return commandExecutedSuccessfully;
    }

    public static boolean submitDMRFlushDispSALCaches(String dataSource, String packageName) {
        boolean finalCommandExecutionSucceeded = true;
        try {
            String[] dispatchers;
            for (String dispatcher : dispatchers = JmxUtils.getDispatcherNames().toArray(new String[0])) {
                if (JmxUtils.submitDMRFlushQESALCaches(dispatcher, dataSource, packageName)) continue;
                finalCommandExecutionSucceeded = false;
            }
        }
        catch (Exception e) {
            finalCommandExecutionSucceeded = false;
            errorLogger.log(e);
        }
        return finalCommandExecutionSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean submitDMRFlushQESALCaches(String dispatcherName, String dataSource, String packageName) {
        JMXConnector connector = null;
        String[] jmxUrls = null;
        Boolean[] resultArray = null;
        try {
            jmxUrls = dispatcherName == null ? AdminConsoleDefaultConfigUtility.getDefaultXqeJmxUrl() : JmxUtils.getAllXqeJMXURls(dispatcherName, null);
            resultArray = new Boolean[jmxUrls.length];
            for (int i = 0; i < jmxUrls.length; ++i) {
                try {
                    Boolean flushStatus;
                    String xqeJmxUrl = jmxUrls[i];
                    String credential = null;
                    credential = dispatcherName == null ? AdminConsoleDefaultConfigUtility.getDispatcherDefaultPassword() : JmxUtils.getPassword(dispatcherName, xqeJmxUrl, null);
                    connector = JmxUtils.getXQEMBeanServerConnection(dispatcherName, xqeJmxUrl, credential);
                    MBeanServerConnection mbeanServerConnection = connector.getMBeanServerConnection();
                    StringBuilder objNameBuilder = new StringBuilder();
                    objNameBuilder.append(XQE_MBEAN_SAL_SERVICE_PATTERN);
                    ObjectName obName = new ObjectName(objNameBuilder.toString());
                    resultArray[i] = flushStatus = (Boolean)mbeanServerConnection.invoke(obName, FLUSH_DMR_CACHE, new Object[]{dataSource, packageName}, new String[]{JAVA_LANG_STRING, JAVA_LANG_STRING});
                    continue;
                }
                catch (MalformedObjectNameException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (InstanceNotFoundException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (ReflectionException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (MBeanException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (IOException e) {
                    errorLogger.log(e);
                    continue;
                }
                catch (Exception e) {
                    errorLogger.log(e);
                }
            }
        }
        catch (Exception e) {
            errorLogger.log(e);
        }
        finally {
            if (connector != null) {
                try {
                    if (connector != null) {
                        connector.close();
                    }
                }
                catch (IOException e) {
                    errorLogger.log(e);
                }
            }
        }
        boolean commandExecutedSuccessfully = true;
        for (Boolean flag : resultArray) {
            if (flag != null && flag.booleanValue()) continue;
            commandExecutedSuccessfully = false;
            break;
        }
        return commandExecutedSuccessfully;
    }
}

