/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.server;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.QName;

public class QueryServerGroupCMCommand
extends ContentManagerCommand {
    private static final String SERVERGROUP = "serverGroup";
    private static final String DISPATCHERPATH = "dispatcherPath";
    public static final String DISPATCHERDEFAULTNAME = "defaultName";
    private static final String DISPATCHERID = "dispatcherID";
    public static final String CUBENAME = "name";
    private static final String BUS_PROP_ENUM = "bus:propEnum";
    private static final String ITEM = "item";
    private String serverGroupSearchPath = null;
    protected static final QName BUS_QUERY = new QName("query", BUS_NAMESPACE);
    private static final QName BUS_QUERYRESPONSE = new QName("queryResponse", BUS_NAMESPACE);
    private Map<String, String> dispatcherToServerGroupMap = new HashMap<String, String>();
    private Map<String, String> dispatcherNameToIDMap = new HashMap<String, String>();
    private Map<String, String> dispatcherNameToPathMap = new HashMap<String, String>();

    public QueryServerGroupCMCommand(String searchPath) {
        this.serverGroupSearchPath = searchPath;
    }

    protected void executeImpl(Element bodyElement) throws CommandExecutionException {
        Element queryElement = bodyElement.addElement(BUS_QUERY);
        Element searchElement = queryElement.addElement("search");
        searchElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        searchElement.addText(this.serverGroupSearchPath);
        Element propertiesElement = queryElement.addElement("properties");
        propertiesElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.SOAP_ENC_ARRAY);
        propertiesElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, "bus:propEnum[2]");
        Element itemElementServerGroup = propertiesElement.addElement(ITEM);
        itemElementServerGroup.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_PROP_ENUM);
        itemElementServerGroup.addText(SERVERGROUP);
        Element itemElementDispatcherName = propertiesElement.addElement(ITEM);
        itemElementDispatcherName.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_PROP_ENUM);
        itemElementDispatcherName.addText(DISPATCHERDEFAULTNAME);
        Element itemElementDispatcherID = propertiesElement.addElement(ITEM);
        itemElementDispatcherID.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_PROP_ENUM);
        itemElementDispatcherID.addText(DISPATCHERID);
        Element itemElementDispatcherPath = propertiesElement.addElement(ITEM);
        itemElementDispatcherPath.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_PROP_ENUM);
        itemElementDispatcherPath.addText(DISPATCHERPATH);
        this.addSessionRequestIds("runtimeInfo");
    }

    protected void handleResponseImpl(Element bodyElement) throws CommandExecutionException {
        Element resultElement;
        Element queryResponse = bodyElement.element(BUS_QUERYRESPONSE);
        if (queryResponse != null && (resultElement = queryResponse.element("queryResult")) != null) {
            List itemElements = resultElement.elements();
            for (Element itemElement : itemElements) {
                List serverGroupOrDispatcherPathList = itemElement.elements();
                String serverGroup = null;
                String dispatcherDefaultName = null;
                String dispatcherID = null;
                String dispatcherPath = null;
                for (int j = 0; j < serverGroupOrDispatcherPathList.size(); ++j) {
                    String result;
                    Element value;
                    int k;
                    Element serverGroupOrDispatcherElement = (Element)serverGroupOrDispatcherPathList.get(j);
                    List valueList = serverGroupOrDispatcherElement.elements();
                    if (serverGroupOrDispatcherElement.getName().equals(SERVERGROUP)) {
                        if (valueList.size() > 0) {
                            for (k = 0; k < valueList.size(); ++k) {
                                value = (Element)valueList.get(k);
                                result = value.getTextTrim();
                                if (result == null || result.equals("")) {
                                    result = "Default Server Group";
                                }
                                serverGroup = result;
                            }
                            continue;
                        }
                        serverGroup = "Default Server Group";
                        continue;
                    }
                    if (serverGroupOrDispatcherElement.getName().equals(DISPATCHERDEFAULTNAME)) {
                        for (k = 0; k < valueList.size(); ++k) {
                            value = (Element)valueList.get(k);
                            dispatcherDefaultName = result = value.getTextTrim();
                        }
                        continue;
                    }
                    if (serverGroupOrDispatcherElement.getName().equals(DISPATCHERID)) {
                        for (k = 0; k < valueList.size(); ++k) {
                            value = (Element)valueList.get(k);
                            dispatcherID = result = value.getTextTrim();
                        }
                        continue;
                    }
                    if (!serverGroupOrDispatcherElement.getName().equals(DISPATCHERPATH)) continue;
                    for (k = 0; k < valueList.size(); ++k) {
                        value = (Element)valueList.get(k);
                        dispatcherPath = result = value.getTextTrim();
                    }
                }
                this.addDispatcherToServerGroupEntry(dispatcherDefaultName, serverGroup);
                this.addDispatcherNameToIDEntry(dispatcherDefaultName, dispatcherID);
                this.addDispatcherNameToPathEntry(dispatcherDefaultName, dispatcherPath);
            }
        }
    }

    private void addDispatcherToServerGroupEntry(String dispName, String serverGroup) {
        this.dispatcherToServerGroupMap.put(dispName, serverGroup);
    }

    private void addDispatcherNameToIDEntry(String dispPath, String dispID) {
        this.dispatcherNameToIDMap.put(dispPath, dispID);
    }

    public Map<String, String> getDispatcherDefaultNameToServerGroupMap() {
        return this.dispatcherToServerGroupMap;
    }

    private void addDispatcherNameToPathEntry(String dispName, String dispPath) {
        this.dispatcherNameToPathMap.put(dispName, dispPath);
    }

    public Map<String, String> getDispatcherDefaultNameToIDMap() {
        return this.dispatcherNameToIDMap;
    }

    public Map<String, String> getDispatcherDefaultNameToPathMap() {
        return this.dispatcherNameToPathMap;
    }
}

