/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.server;

import com.cognos.xqebifw.adminconsole.server.JmxUtils;
import com.cognos.xqebifw.adminconsole.server.XqeConfigurationBean;
import com.cognos.xqebifw.adminconsole.server.XqeConfigurationElementBean;
import com.cognos.xqebifw.adminconsole.server.XqeService;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class XqeAdministrator {
    private static XqeAdministrator mInstance = null;
    private Map<String, XqeService> mXqeServices = new HashMap<String, XqeService>();
    public static final String LOCAL_DISPATCHER = "localdispatcher";

    public XqeService getXqeService(String dispatcherName) {
        XqeService service = this.mXqeServices.get(dispatcherName);
        if (service == null) {
            service = new XqeService(dispatcherName);
            this.mXqeServices.put(dispatcherName, service);
        }
        return service;
    }

    private XqeAdministrator() {
    }

    public static XqeAdministrator getInstance() {
        if (mInstance == null) {
            mInstance = new XqeAdministrator();
        }
        return mInstance;
    }

    public Set<String> getDispatchers() {
        return JmxUtils.getDispatcherNames();
    }

    public static void main(String[] args) {
        XqeAdministrator xqeAdmin = new XqeAdministrator();
        String dispatcherName = "http://vpunsecondary32:9300/p2pd";
        XqeService service = xqeAdmin.getXqeService(dispatcherName);
        XqeConfigurationBean config = service.getConfiguration();
        config.displayConfigOnConsole();
        XqeConfigurationElementBean elem = (XqeConfigurationElementBean)config.getChild("XqeMetadataService").getChild("XqeDefaultProvider");
        elem.setValue("NATIVEODP");
        elem = (XqeConfigurationElementBean)config.getChild("XqeGeneral").getChild("XqeReloadConfigInterval");
        elem.setValue("6500");
        config.save();
    }
}

