/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.server;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqebifw.adminconsole.server.AbstractXqeUIBean;
import com.cognos.xqebifw.adminconsole.server.JmxUtils;
import com.cognos.xqebifw.adminconsole.server.XqeConfigEnums;
import com.cognos.xqebifw.adminconsole.server.XqeConfigurationCategoryBean;
import com.cognos.xqebifw.adminconsole.server.XqeConfigurationElementBean;
import com.cognos.xqebifw.adminconsole.server.XqeService;
import com.cognos.xqebifw.adminconsole.server.XqeUIBean;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XqeConfigurationBean
extends AbstractXqeUIBean {
    private List<XqeConfigurationCategoryBean> mCategories = null;
    private String mDispatcherName = null;
    private static Map<String, XqeConfigEnums> mGlobalConfigEnums = new HashMap<String, XqeConfigEnums>();
    private static XqeConfigurationBean mBaseConfig = null;
    private static final Map<String, XqeConfigurationBean> CONFIG_CACHE = new HashMap<String, XqeConfigurationBean>();
    private static final String UI_CONFIG_FILE_PATH = "/com/cognos/xqe/adminconsole/XQEUIConfig.xml";
    private static final String XML_NODE_XQECONFIGURATION = "XQEConfiguration";
    private static final String XML_NODE_ATTRIBUTE_NAME = "name";

    XqeConfigurationBean(String name, String dispatcherName) {
        super(name);
        this.mDispatcherName = dispatcherName;
    }

    public void addCategory(XqeConfigurationCategoryBean category) {
        super.addChild(category);
        if (this.mCategories == null) {
            this.mCategories = new ArrayList<XqeConfigurationCategoryBean>();
        }
        this.mCategories.add(category);
    }

    public List<XqeConfigurationCategoryBean> getCategories() {
        return this.mCategories;
    }

    @Override
    public String getName() {
        return XML_NODE_XQECONFIGURATION;
    }

    @Override
    public Object getValue() {
        return null;
    }

    public static XqeConfigEnums getGlobalConfigEnumsRef(String name) {
        return mGlobalConfigEnums.get(name);
    }

    public void readConfiguration(Node configNode) {
        NodeList categories = configNode.getChildNodes();
        int length = categories.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = categories.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("XQEConfigEnums")) {
                NamedNodeMap attributes = node.getAttributes();
                String name = attributes.getNamedItem(XML_NODE_ATTRIBUTE_NAME).getNodeValue();
                XqeConfigEnums enums = new XqeConfigEnums();
                enums.readEnums(node);
                mGlobalConfigEnums.put(name, enums);
            }
            if (!node.getNodeName().equals("XQEConfigurationCategory")) continue;
            String name = node.getAttributes().getNamedItem(XML_NODE_ATTRIBUTE_NAME).getNodeValue();
            XqeConfigurationCategoryBean catBean = new XqeConfigurationCategoryBean(name);
            catBean.readCategory(node);
            this.addCategory(catBean);
        }
    }

    public void displayConfigOnConsole() {
        ListIterator<XqeConfigurationCategoryBean> catsIter = this.getCategories().listIterator();
        while (catsIter.hasNext()) {
            XqeConfigurationCategoryBean cat = catsIter.next();
            XQEDebugLog.out.println("================" + cat.getLabel() + "=================");
            ListIterator<XqeConfigurationElementBean> elemsIter = cat.getConfigElements().listIterator();
            while (elemsIter.hasNext()) {
                XqeConfigurationElementBean elem = elemsIter.next();
                XQEDebugLog.out.println(elem.getLabel() + " = " + elem.getValue() + " [type = " + (Object)((Object)elem.getType()) + "] ");
                if (!elem.getType().equals((Object)XqeConfigurationElementBean.XqeConfigurationElementType.Enumeration)) continue;
                XQEDebugLog.out.println(elem.getEnumerations());
            }
        }
    }

    public void save() {
        this.save(this.mDispatcherName);
    }

    private void save(String dispatcherName) {
        ListIterator<XqeConfigurationCategoryBean> catsIter = this.getCategories().listIterator();
        while (catsIter.hasNext()) {
            XqeConfigurationCategoryBean cat = catsIter.next();
            cat.save(dispatcherName);
        }
        JmxUtils.saveXQEConfigurationToFile(this.mDispatcherName);
    }

    public void load() {
        this.load(this.mDispatcherName);
    }

    private void load(String dispatcherName) {
        ListIterator<XqeConfigurationCategoryBean> catsIter = this.getCategories().listIterator();
        while (catsIter.hasNext()) {
            XqeConfigurationCategoryBean cat = catsIter.next();
            cat.load(dispatcherName);
        }
    }

    public XqeUIBean createCopy(String dispatcherName) {
        XqeConfigurationBean newConfig = new XqeConfigurationBean(this.getName(), dispatcherName);
        ListIterator<XqeConfigurationCategoryBean> catsIter = this.getCategories().listIterator();
        while (catsIter.hasNext()) {
            XqeConfigurationCategoryBean cat = catsIter.next();
            XqeConfigurationCategoryBean newCategory = (XqeConfigurationCategoryBean)cat.createCopy();
            newConfig.addCategory(newCategory);
        }
        return newConfig;
    }

    private static Document parseConfigFile() {
        InputStream is = XqeService.class.getResourceAsStream(UI_CONFIG_FILE_PATH);
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setNamespaceAware(false);
        f.setValidating(false);
        DocumentBuilder b = null;
        try {
            b = f.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        try {
            return b.parse(is);
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, e);
        }
    }

    private static void readBaseConfig() {
        Document doc = XqeConfigurationBean.parseConfigFile();
        Node root = doc.getElementsByTagName(XML_NODE_XQECONFIGURATION).item(0);
        NamedNodeMap attributes = root.getAttributes();
        String name = attributes.getNamedItem(XML_NODE_ATTRIBUTE_NAME).getNodeValue();
        mBaseConfig = new XqeConfigurationBean(name, null);
        mBaseConfig.readConfiguration(root);
    }

    public static XqeConfigurationBean fetchConfiguration(String dispatcherName) {
        XqeConfigurationBean config = CONFIG_CACHE.get(dispatcherName);
        if (mBaseConfig == null) {
            XqeConfigurationBean.readBaseConfig();
        }
        config = (XqeConfigurationBean)mBaseConfig.createCopy(dispatcherName);
        config.load();
        return config;
    }

    public static XqeConfigurationBean fetchConfiguration(String dispatcherName, String cacheID) {
        XqeConfigurationBean config = CONFIG_CACHE.get(cacheID);
        if (config != null) {
            return config;
        }
        config = XqeConfigurationBean.fetchConfiguration(dispatcherName);
        CONFIG_CACHE.put(cacheID, config);
        return config;
    }
}

