/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.server;

import com.cognos.xqebifw.adminconsole.server.AbstractXqeUIBean;
import com.cognos.xqebifw.adminconsole.server.XqeConfigurationElementBean;
import com.cognos.xqebifw.adminconsole.server.XqeUIBean;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XqeConfigurationCategoryBean
extends AbstractXqeUIBean {
    private List<XqeConfigurationElementBean> mConfigElements = null;

    XqeConfigurationCategoryBean(String name) {
        super(name);
    }

    public List<XqeConfigurationElementBean> getConfigElements() {
        return this.mConfigElements;
    }

    public void addConfigElement(XqeConfigurationElementBean configElement) {
        super.addChild(configElement);
        if (this.mConfigElements == null) {
            this.mConfigElements = new ArrayList<XqeConfigurationElementBean>();
        }
        this.mConfigElements.add(configElement);
    }

    public void readCategory(Node category) {
        NodeList elements = category.getChildNodes();
        int length = elements.getLength();
        for (int i = 0; i < length; ++i) {
            Node element = elements.item(i);
            if (element.getNodeType() != 1) continue;
            NamedNodeMap attributes = element.getAttributes();
            String name = attributes.getNamedItem("name").getNodeValue();
            XqeConfigurationElementBean elementBean = new XqeConfigurationElementBean(name);
            elementBean.readconfigurationElement(element);
            this.addConfigElement(elementBean);
        }
    }

    public void save(String dispatcherName) {
        ListIterator<XqeConfigurationElementBean> elemsIter = this.getConfigElements().listIterator();
        while (elemsIter.hasNext()) {
            XqeConfigurationElementBean elem = elemsIter.next();
            elem.save(dispatcherName);
        }
    }

    public void load(String dispatcherName) {
        ListIterator<XqeConfigurationElementBean> elemsIter = this.getConfigElements().listIterator();
        while (elemsIter.hasNext()) {
            XqeConfigurationElementBean elem = elemsIter.next();
            elem.load(dispatcherName);
        }
        this.processParameterDependencies();
    }

    public XqeUIBean createCopy() {
        XqeConfigurationCategoryBean newCategory = new XqeConfigurationCategoryBean(this.getName());
        ListIterator<XqeConfigurationElementBean> elemsIter = this.getConfigElements().listIterator();
        while (elemsIter.hasNext()) {
            XqeConfigurationElementBean elem = elemsIter.next();
            XqeConfigurationElementBean newElem = elem.createCopy();
            newCategory.addConfigElement(newElem);
        }
        return newCategory;
    }

    @Override
    public Object getValue() {
        return null;
    }

    public void processParameterDependencies() {
        ListIterator<XqeConfigurationElementBean> elemsIter = this.getConfigElements().listIterator();
        block0: while (elemsIter.hasNext()) {
            XqeConfigurationElementBean elem = elemsIter.next();
            if (elem.mDependsOn == null) continue;
            for (int i = 0; i < this.mConfigElements.size(); ++i) {
                XqeConfigurationElementBean configBean = this.mConfigElements.get(i);
                if (!configBean.getName().equals(elem.mDependsOn)) continue;
                elem.setMDependingParent(configBean);
                configBean.addMDependentChild(elem);
                configBean.mDependingValue = elem.mDependingValue;
                continue block0;
            }
        }
    }
}

