/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.server;

import com.cognos.xqebifw.adminconsole.server.AbstractXqeUIBean;
import com.cognos.xqebifw.adminconsole.server.JmxUtils;

public class XqeSALBean
extends AbstractXqeUIBean {
    private String mDispatcherName = null;

    XqeSALBean(String name, String dispatcherName) {
        super(name);
        this.mDispatcherName = dispatcherName;
    }

    public boolean flush(String dataSource, String catalog, String cube) {
        if (this.mDispatcherName != null && this.mDispatcherName.equals("All")) {
            return JmxUtils.submitFlushDispSALCaches(dataSource, catalog, cube);
        }
        return JmxUtils.submitFlushQESALCaches(this.mDispatcherName, dataSource, catalog, cube);
    }

    public boolean dump(String dataSource, String catalog, String cube) {
        if (this.mDispatcherName != null && this.mDispatcherName.equals("All")) {
            return JmxUtils.submitDumpDispSALCaches(dataSource, catalog, cube);
        }
        return JmxUtils.submitDumpQESALCaches(this.mDispatcherName, dataSource, catalog, cube);
    }

    public String[] getCachedDataSources() {
        return JmxUtils.fetchCachedDataSources(this.mDispatcherName);
    }

    public String[] getCachedCatalogs(String datasourceName) {
        return JmxUtils.fetchCachedCatalogs(this.mDispatcherName, datasourceName);
    }

    public String[] getCachedCubes(String datasourceName, String catalogName) {
        return JmxUtils.fetchCachedCubes(this.mDispatcherName, datasourceName, catalogName);
    }

    public String[] getCacheOperations() {
        return JmxUtils.fetchCacheOperations(this.mDispatcherName);
    }

    public boolean flushDMRCache(String dataSource, String packageName) {
        if (this.mDispatcherName != null && this.mDispatcherName.equals("All")) {
            return JmxUtils.submitDMRFlushDispSALCaches(dataSource, packageName);
        }
        return JmxUtils.submitDMRFlushQESALCaches(this.mDispatcherName, dataSource, packageName);
    }

    public boolean dumpDMRCache(String dataSource, String packageName) {
        if (this.mDispatcherName != null && this.mDispatcherName.equals("All")) {
            return JmxUtils.submitDMRDumpDispSALCaches(dataSource, packageName);
        }
        return JmxUtils.submitDMRDumpQESALCaches(this.mDispatcherName, dataSource, packageName);
    }
}

