/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.DSServiceAccessSession;
import com.ibm.bi.org.apache.hadoop.io.CryptoException;
import com.ibm.bi.org.apache.hadoop.io.ICryptoProvider;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import mx4j.tools.remote.rmi.SSLRMIServerSocketFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;

public final class CAMCryptoProvider
implements ICryptoProvider {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static final CAMFactory CAM_FACTORY = new CAMFactory();
    public static final String SERVICE_ID = "XQE";
    private static final byte[] INITDOC = "<initializeDocument><serviceID>XQE</serviceID></initializeDocument>".getBytes();
    private static final String ERRMSG_NOT_INITIALIZED = "CryptoProvider was already terminated.";
    private static DSServiceAccessSession session;

    public void initialize() throws CryptoException {
        if (INITIALIZED.compareAndSet(false, true)) {
            INITIALIZED.set(true);
            try {
                CAM_FACTORY.initialize(INITDOC);
                session = new DSServiceAccessSession();
            }
            catch (CAMCryptoException e) {
                throw new CryptoException((Throwable)e);
            }
        }
    }

    public void terminate() throws CryptoException {
        if (!INITIALIZED.compareAndSet(true, false)) {
            throw new IllegalStateException(ERRMSG_NOT_INITIALIZED);
        }
        CAM_FACTORY.terminate();
    }

    public byte[] encrypt(byte[] data) throws CryptoException {
        if (INITIALIZED.get()) {
            try {
                return CAM_FACTORY.createEncryptingSession().encryptData(data);
            }
            catch (CAMCryptoException e) {
                throw new CryptoException((Throwable)e);
            }
        }
        throw new IllegalStateException(ERRMSG_NOT_INITIALIZED);
    }

    public byte[] decrypt(byte[] data) throws CryptoException {
        if (INITIALIZED.get()) {
            try {
                return CAM_FACTORY.createEncryptingSession().decryptData(data);
            }
            catch (CAMCryptoException e) {
                throw new CryptoException((Throwable)e);
            }
        }
        throw new IllegalStateException(ERRMSG_NOT_INITIALIZED);
    }

    public OutputStream createEncryptingOutputStream(OutputStream sourceOutputStream) throws CryptoException {
        if (INITIALIZED.get()) {
            try {
                return CAM_FACTORY.createEncryptingOutputStream(sourceOutputStream);
            }
            catch (CAMCryptoException e) {
                throw new CryptoException((Throwable)e);
            }
        }
        throw new IllegalStateException(ERRMSG_NOT_INITIALIZED);
    }

    public InputStream createDecryptingInputStream(InputStream sourceInputStream) throws CryptoException {
        if (INITIALIZED.get()) {
            try {
                return CAM_FACTORY.createDecryptingInputStream(sourceInputStream);
            }
            catch (CAMCryptoException e) {
                throw new CryptoException((Throwable)e);
            }
        }
        throw new IllegalStateException(ERRMSG_NOT_INITIALIZED);
    }

    public HttpConnection createHttpConnection(String host, int port, boolean isSecure) throws CryptoException {
        if (INITIALIZED.get()) {
            try {
                return CAM_FACTORY.createHttpConnection(host, port, isSecure);
            }
            catch (CAMCryptoException e) {
                throw new CryptoException((Throwable)e);
            }
        }
        throw new IllegalStateException(ERRMSG_NOT_INITIALIZED);
    }

    public HttpClient createHttpClient(String host, int port, boolean isSecure) throws CryptoException {
        if (INITIALIZED.get()) {
            try {
                if (isSecure) {
                    return CAM_FACTORY.createSecurePooledHttpClient(host, port);
                }
                return CAM_FACTORY.createHttpClient(host, port, isSecure);
            }
            catch (CAMCryptoException e) {
                throw new CryptoException((Throwable)e);
            }
        }
        throw new IllegalStateException(ERRMSG_NOT_INITIALIZED);
    }

    public ServerSocket createServerSocket(int port, boolean isSecure) throws CryptoException {
        if (INITIALIZED.get()) {
            try {
                return CAM_FACTORY.createServerSocket(port, isSecure);
            }
            catch (CAMCryptoException e) {
                throw new CryptoException((Throwable)e);
            }
        }
        throw new IllegalStateException(ERRMSG_NOT_INITIALIZED);
    }

    public Socket createSocket(String host, int port, boolean isSecure) throws CryptoException {
        if (INITIALIZED.get()) {
            try {
                return CAM_FACTORY.createSocket(host, port, isSecure);
            }
            catch (CAMCryptoException e) {
                throw new CryptoException((Throwable)e);
            }
        }
        throw new IllegalStateException(ERRMSG_NOT_INITIALIZED);
    }

    @Deprecated
    public SSLContext getSSLContext() throws CryptoException {
        return null;
    }

    @Deprecated
    public SSLRMIServerSocketFactory createRMIServerSocketFactory() throws CryptoException {
        return null;
    }

    public byte[] getToken(byte[] arg) throws CryptoException {
        try {
            return session.getToken(arg);
        }
        catch (CAMCryptoException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public boolean verifyToken(byte[] arg1, byte[] arg2) throws CryptoException {
        try {
            return session.verifyToken(arg1, arg2);
        }
        catch (CAMCryptoException e) {
            throw new CryptoException((Throwable)e);
        }
    }
}

