/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.CancelableRequestRegistry;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.concurrent.ThreadPool;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.cubingservices.DQThreadContext;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.dom4j.Element;

public class CancelRequestAdapter
extends RequestAdapter {
    public static final String CANCEL_ELEMENT_NAME = "cancel";
    private static final int CANCEL_ITERATION_INTERVAL = 1000;
    private static final int CANCEL_MAX_CHECK_ITERATIONS = 60;
    int iterationWaitTime = 1000;
    int maxTries = 60;
    private ThreadPool cancelLoggingThreadPool = null;
    private static final String ID = "id=";
    private static final String NAME = " name=";
    private static final String NEWLINE = "\n";
    private static XQELogger mLogger = null;

    private static XQELogger getLogger() {
        if (mLogger == null) {
            mLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Cancel", LogLevel.ERROR);
        }
        return mLogger;
    }

    private boolean isTracing() {
        return CancelRequestAdapter.getLogger().isOn(LogLevel.INFO);
    }

    public CancelRequestAdapter() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.iterationWaitTime = configuration.getIntegerProperty("Cancel.CancelIterationInterval[@value]", 1000);
        this.maxTries = configuration.getIntegerProperty("Cancel.CancelMaximumCheckIterations[@value]", 60);
    }

    @Override
    public ResponseAdapter executeRequest(RequestEnvironment environment) {
        MetricsService.collectMetricInfo(environment, "requestType", CANCEL_ELEMENT_NAME);
        BIBusEnvelope requestEnvelope = environment.getRequestEnvelope();
        Element cancelElement = requestEnvelope.getBody().element(CANCEL_ELEMENT_NAME);
        Element requestIDElement = cancelElement.element("requestID");
        String requestID = requestIDElement.attributeValue("value");
        CancelRequestAdapter.getLogger().log("Attempting to cancel request " + requestID);
        CancelableRequestRegistry cancelableRequestRegistry = environment.getCancelableRequestRegistry();
        if (null == cancelableRequestRegistry) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "null == cancelableRequestRegistry");
        }
        if (this.cancelLoggingThreadPool == null) {
            this.cancelLoggingThreadPool = ThreadPool.getInstance();
        }
        this.cancelLoggingThreadPool.submit(new CancelLogger(requestID));
        cancelableRequestRegistry.cancel(requestID);
        return NULL_RESPONSE_ADAPTER;
    }

    @Override
    public String getOperationName() {
        return CANCEL_ELEMENT_NAME;
    }

    @Override
    public boolean sequentializeRequestsInSession() {
        return false;
    }

    @Override
    public boolean requiresMultiRequestContext() {
        return false;
    }

    @Override
    protected boolean requiresCancelableRegistration() {
        return false;
    }

    private static String getStackTrace(Thread cancelThread) {
        StackTraceElement[] stack = cancelThread.getStackTrace();
        StringBuilder buffer = new StringBuilder();
        for (StackTraceElement e : stack) {
            buffer.append(e.toString()).append(" at\n");
        }
        return buffer.toString();
    }

    @Override
    public void release() {
        if (this.cancelLoggingThreadPool != null) {
            this.cancelLoggingThreadPool.shutdown();
            this.cancelLoggingThreadPool = null;
        }
    }

    private class CancelLogger<V>
    implements Callable<V> {
        ConcurrentLinkedQueue<Thread> cancelThreads = null;
        String requestIdToCancel = null;

        CancelLogger(String requestID) {
            this.cancelThreads = DQThreadContext.getInstance().getRequestedThreads(requestID);
            this.requestIdToCancel = requestID;
            if (CancelRequestAdapter.this.isTracing()) {
                StringBuilder threadsInfoMessage = new StringBuilder();
                if (this.cancelThreads == null || this.cancelThreads.isEmpty()) {
                    threadsInfoMessage.append("All threads were already canceled for requestId=").append(requestID);
                    CancelRequestAdapter.getLogger().log(threadsInfoMessage.toString());
                } else {
                    threadsInfoMessage.append("Canceling for requestId=").append(requestID);
                    for (Thread t : this.cancelThreads) {
                        threadsInfoMessage.append(CancelRequestAdapter.NEWLINE).append(CancelRequestAdapter.ID).append(t.getId()).append(CancelRequestAdapter.NAME).append(t.getName());
                    }
                    CancelRequestAdapter.getLogger().log(threadsInfoMessage.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V call() {
            if (this.cancelThreads == null || this.cancelThreads.isEmpty()) {
                CancelRequestAdapter.getLogger().log("All threads were canceled for requestId =" + this.requestIdToCancel);
                return null;
            }
            int iter = -1;
            try {
                boolean isTracing = CancelRequestAdapter.this.isTracing();
                for (iter = 0; iter < 60 && this.cancelThreads != null; ++iter) {
                    if (this.cancelThreads.isEmpty()) {
                        break;
                    }
                    if (isTracing) {
                        StringBuilder threadsInfoMessage = new StringBuilder("Still canceling for requestId=").append(this.requestIdToCancel);
                        for (Thread t : this.cancelThreads) {
                            threadsInfoMessage.append(CancelRequestAdapter.NEWLINE).append(CancelRequestAdapter.ID).append(t.getId()).append(CancelRequestAdapter.NAME).append(t.getName());
                        }
                        CancelRequestAdapter.getLogger().log(threadsInfoMessage.toString());
                    }
                    Thread.sleep(CancelRequestAdapter.this.iterationWaitTime);
                }
            }
            catch (Exception ex) {
                CancelRequestAdapter.getLogger().log(ex);
            }
            finally {
                StringBuilder successMessage = new StringBuilder();
                String iterationsTime = " iterations. Iterations time = " + iter * CancelRequestAdapter.this.iterationWaitTime + " ms" + " requestId =" + this.requestIdToCancel;
                successMessage.append("Info: all threads have terminated in ");
                successMessage.append(iter);
                successMessage.append(iterationsTime);
                if (this.cancelThreads == null || this.cancelThreads.isEmpty()) {
                    CancelRequestAdapter.getLogger().log(successMessage.toString());
                } else {
                    StringBuilder message = new StringBuilder();
                    message.append("Warning: not all threads have terminated in ").append(iter);
                    message.append(iterationsTime).append(CancelRequestAdapter.NEWLINE);
                    for (Thread thread : this.cancelThreads) {
                        if (this.cancelThreads == null || this.cancelThreads.isEmpty()) {
                            CancelRequestAdapter.getLogger().log(successMessage.toString());
                            break;
                        }
                        Thread.State currState = thread.getState();
                        message.append("Thread id = " + thread.getId() + " thread name = " + thread.getName() + " state = " + currState.toString()).append(CancelRequestAdapter.NEWLINE);
                        message.append(CancelRequestAdapter.getStackTrace(thread));
                    }
                    if (this.cancelThreads == null || this.cancelThreads.isEmpty()) {
                        CancelRequestAdapter.getLogger().log(successMessage.toString());
                    } else {
                        CancelRequestAdapter.getLogger().log(message.toString());
                    }
                }
                DQThreadContext.getInstance().removeThreads(this.requestIdToCancel);
            }
            return null;
        }
    }
}

