/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.LogIPFControl;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.config.ConfigurationImpl;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationAdapter;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.datasets.DatasetManager;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import com.cognos.xqebifw.cubingservices.V5ServerProcessException;
import com.cognos.xqebifw.management.XqeAgent;
import java.io.IOException;
import java.util.Collections;
import org.dom4j.Element;

public class ConfigureRequestAdapter
extends RequestAdapter {
    private static final String INTERNAL_DISP = "internalDispatcher";
    public static final String CONFIGURE_ELEMENT_NAME = "configure";

    @Override
    public ResponseAdapter executeRequest(RequestEnvironment environment) throws XQEException, IOException {
        BIBusEnvelope requestEnvelope = environment.getRequestEnvelope();
        Element configureElement = requestEnvelope.getBody().element(CONFIGURE_ELEMENT_NAME);
        if (configureElement == null) {
            throw new V5ServerProcessException(XQEMessageKeys.INI_RuntimeConfigurationError);
        }
        String requestType = configureElement.attributeValue("requestType");
        Element cmConfigElement = configureElement.element("queryResult");
        if (cmConfigElement == null) {
            throw new V5ServerProcessException(XQEMessageKeys.INI_RuntimeConfigurationError);
        }
        ConfigurationImpl dispatcherConfiguration = new ConfigurationImpl();
        dispatcherConfiguration.reconfigure(cmConfigElement);
        ICCLConfiguration cclConfig = dispatcherConfiguration.getICCLConfiguration();
        LogIPFControl.configure((ICCLConfiguration)cclConfig);
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (config == null) {
            config = XQECCLConfigurationAdapter.createDefaultConfiguration(cclConfig);
            XQEConfigurationManager.getInstance().add(ServiceEnumeration.XQE, config);
            config.setProperty("lastConfigureRequestType", requestType);
        } else {
            config.setProperty("lastConfigureRequestType", requestType);
            config.update(cclConfig);
        }
        try {
            String cmURL = cclConfig.getValue(INTERNAL_DISP, false);
            NodeIdGuidMapper.setContentManagerNID((NodeID)NodeID.getNodeID((String)cmURL));
        }
        catch (CCLConfigurationException ce) {
            throw new XQERuntimeException(ce);
        }
        if (!XqeAgent.isXqeJmxUrlRegistered()) {
            XqeAgent.updateDispatcherMBeans(cclConfig);
        }
        DatasetManager.getInstance().initializeFlintServerManager();
        ZipiBridge.reconfigure(cclConfig);
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        responseEnvelope.setBIBusHeader((Element)requestEnvelope.getBIBusHeader().detach());
        return new SimpleResponseAdapter(responseEnvelope, Collections.emptyList());
    }

    @Override
    public String getOperationName() {
        return CONFIGURE_ELEMENT_NAME;
    }

    @Override
    protected boolean requiresCancelableRegistration() {
        return false;
    }

    @Override
    public boolean requiresMultiRequestContext() {
        return false;
    }
}

