/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.ICryptoHandle;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnection;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnectionSignon;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.IDataProvider;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.SimpleDataSource;
import com.cognos.xqe.data.providers.SimpleDataSourceConnection;
import com.cognos.xqe.data.providers.connection.ConnectionStringParser;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.security.EncryptedObject;
import com.cognos.xqe.security.IEncryptedObject;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.reference.IResourceHolder;
import com.cognos.xqebifw.bibushandler.content.GenCredCommand;
import com.cognos.xqebifw.bibushandler.content.LogonCommand;
import com.cognos.xqebifw.bibushandler.datasource.JCAMImpersonator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public final class ConnectionTester {
    private static final XQELogger ENGINE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryEngine", LogLevel.INFO);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<XQEMessage> testDataSourceConnection(Document requestDocument, RequestEnvironment reqEnv) throws XQEException {
        Element domCredentials;
        List<XQEMessage> databaseConnectionInfo = null;
        if (ENGINE_LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Test data source connection for request document: ").append(requestDocument.asXML());
            ENGINE_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
        String connectionString = null;
        Element domConnString = requestDocument.getRootElement().element("connectionString");
        if (domConnString == null) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_InvalidTestConnectionRequest);
        }
        connectionString = domConnString.getText();
        if (connectionString.indexOf("#") >= 0) {
            ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(env.getRequestEnvironment());
            MacroExpander expander = new MacroExpander();
            connectionString = expander.expand(null, planEnv, connectionString);
        }
        if ((domCredentials = requestDocument.getRootElement().element("credentials")) == null) {
            throw new XQERuntimeException(XQEMessageKeys.XML_MissingXMLElement, "credentials");
        }
        String encryptedXML = domCredentials.getText();
        Element domApiToken = requestDocument.getRootElement().element("apiToken");
        if (domApiToken != null) {
            encryptedXML = domApiToken.getText();
        }
        DataSourceConnection.Credentials cred = DataSourceConnection.retrieveCredentials(encryptedXML);
        JCAMImpersonator.DelegatedCredential credential = null;
        IResourceHolder<? extends ICryptoHandle> cryptoHandle = null;
        String nameSpace = cred.getNameSpace();
        if (nameSpace != null && cred.getUsername() == null) {
            CAMPassport camPassport = new CAMPassport();
            camPassport.setId(reqEnv.getCAMPassport());
            GenCredCommand credRetriever = new GenCredCommand(nameSpace, camPassport, connectionString, reqEnv.getProductLocale());
            String encryptedVal = credRetriever.getEncryptedCredentials();
            if (encryptedVal != null) {
                cred = DataSourceConnection.retrieveCredentials(encryptedVal, nameSpace);
            } else {
                credential = credRetriever.getDelegatedCredential();
                cryptoHandle = credRetriever.getCryptoHandle();
            }
        }
        LogonCommand cmd = null;
        BIBusEnvelope envelope = reqEnv.getRequestEnvelope();
        try {
            if (cred != null && cred.getNameSpace() != null && cred.getUsername() != null) {
                cmd = ConnectionTester.logonToNamespace(reqEnv, cred);
            }
            databaseConnectionInfo = ConnectionTester.doTestConnection(reqEnv, connectionString, cred, credential, cryptoHandle);
        }
        finally {
            if (cmd != null) {
                cmd.logoff();
            }
            reqEnv.resetBIBusEnvelope(envelope);
        }
        return databaseConnectionInfo;
    }

    public static void testConnection(Document requestDocument, RequestEnvironment reqEnv) throws XQEException {
        Element connStrNode;
        Element connNode;
        if (ENGINE_LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Test connection for request document: ").append(requestDocument.asXML());
            ENGINE_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
        if ((connNode = requestDocument.getRootElement().element("connection")) == null) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_InvalidTestConnectionRequest);
        }
        Element nestedConnElement = connNode.element("connection");
        if (nestedConnElement != null) {
            connNode = nestedConnElement;
        }
        if ((connStrNode = connNode.element("connectionString")) == null) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_InvalidTestConnectionRequest);
        }
        String connectionString = connStrNode.attributeValue("value");
        Element usernameNode = connNode.element("username");
        String username = null;
        if (usernameNode != null) {
            username = usernameNode.attributeValue("value");
        }
        Element passwordNode = connNode.element("password");
        EncryptedObject<String> password = null;
        if (passwordNode != null) {
            password = new EncryptedObject<String>(passwordNode.attributeValue("value"));
        }
        Element cubePasswordNode = connNode.element("cubePassword");
        EncryptedObject<String> cubePassword = null;
        if (cubePasswordNode != null) {
            cubePassword = new EncryptedObject<String>(cubePasswordNode.attributeValue("value"));
        }
        Element namespaceNode = connNode.element("namespace");
        String namespace = null;
        if (namespaceNode != null) {
            namespace = namespaceNode.attributeValue("value");
        }
        ConnectionTester.doTestConnection(reqEnv, connectionString, username, password, cubePassword, namespace, null, null, null, null, null, null);
    }

    private static List<XQEMessage> doTestConnection(RequestEnvironment reqEnv, String connectionString, String username, IEncryptedObject<String> password, IEncryptedObject<String> cubePassword, String namespace, JCAMImpersonator.DelegatedCredential credential, IResourceHolder<? extends ICryptoHandle> cryptoHandle, IEncryptedObject<String> oidcIdToken, IEncryptedObject<String> oidcAccessToken, IEncryptedObject<String> authKey, IEncryptedObject<String> secretKey) throws XQERuntimeException {
        if (ENGINE_LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Test connection string: ").append(connectionString);
            ENGINE_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
        Map<String, String> connectionParams = ConnectionStringParser.parse(connectionString, new HashSet<String>());
        String providerCode = connectionParams.get("PROVIDER_TYPE");
        IDataProvider provider = ProviderManager.getInstance().getProvider(providerCode);
        if (provider == null) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_DataProviderNotFound, providerCode);
        }
        IDataSourceConnectionSignon signon = DataSourceConnectionSignon.createSignon(providerCode, "TestSignon", null, username, password, null, null, cubePassword, null, cryptoHandle, connectionString, credential, oidcIdToken, oidcAccessToken, authKey, secretKey);
        SimpleDataSourceConnection connection = new SimpleDataSourceConnection(connectionString, signon, namespace);
        SimpleDataSource dataSource = new SimpleDataSource("TestDataSource", providerCode, connection, new HashMap<String, Object>());
        ConnectionTestQueryArguments queryArguments = new ConnectionTestQueryArguments(dataSource, (IExecutionEnvironment)reqEnv.getExecutionEnvironment());
        return provider.testConnection(queryArguments);
    }

    private static List<XQEMessage> doTestConnection(RequestEnvironment reqEnv, String connectionString, DataSourceConnection.Credentials cred, JCAMImpersonator.DelegatedCredential credential, IResourceHolder<? extends ICryptoHandle> cryptoHandle) throws XQERuntimeException {
        return ConnectionTester.doTestConnection(reqEnv, connectionString, cred.getUsername(), cred.getPassword(), cred.getCubePassword(), cred.getNameSpace(), credential, cryptoHandle, cred.getIdToken(), cred.getAccessToken(), cred.getAuthKey(), cred.getSecretKey());
    }

    private static LogonCommand logonToNamespace(RequestEnvironment reqEnv, DataSourceConnection.Credentials cred) {
        String decryptedPwd = null;
        if (cred.getPassword() != null) {
            decryptedPwd = cred.getPassword().decrypt();
        }
        LogonCommand cmd = new LogonCommand(cred.getNameSpace(), cred.getUsername(), decryptedPwd);
        cmd.logon();
        BIBusEnvelope envelope = cmd.getEnvelope();
        if (envelope != null) {
            reqEnv.resetBIBusEnvelope(envelope);
        }
        return cmd;
    }
}

