/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqebifw.bibushandler.RSVP4JHelper;
import com.cognos.xqebifw.bibushandler.RSVP4JResponseAdapter;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import com.cognos.xqebifw.bibushandler.XQENodeSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public class ExecuteDetailQueryRequestAdapter
extends RequestAdapter {
    private static final String MASTER_DATASET_ID = "masterDatasetId";
    private static final String MASTER_DATASET = "masterDataset";

    @Override
    public ResponseAdapter executeRequest(RequestEnvironment environment) throws XQEException {
        long startTime = System.currentTimeMillis();
        MetricsService.collectMetricInfo(environment, "requestType", "executeDetailQuery");
        BIBusEnvelope requestEnvelope = environment.getRequestEnvelope();
        Element v5RootElement = requestEnvelope.getBody().element("executeDetailQuery");
        v5RootElement.detach();
        this.logV5Request(v5RootElement, "queriesPlanned", environment.getReportName());
        Element detailDatasetElement = v5RootElement.element(MASTER_DATASET);
        if (null == detailDatasetElement) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_MissingMasterDatasetId);
        }
        String datasetId = detailDatasetElement.attributeValue(MASTER_DATASET_ID);
        if (null == datasetId) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_MissingMasterDatasetId);
        }
        Element detailQuery = v5RootElement.element("detailQuery");
        RSAPIDataset detailDataset = ExecuteDetailQueryRequestAdapter.getDetailDataset(environment, detailQuery, datasetId);
        ZipiBridge.setZipiContextAndObjPath(detailDataset.getName());
        Element queryFeedback = v5RootElement.element("queryFeedback");
        ByteArrayInputStream resultStream = null;
        String origRefQueryName = detailQuery.attributeValue("queryNameOrig");
        if (origRefQueryName != null && !detailDataset.getRefQueryName().equals(origRefQueryName)) {
            detailDataset.setRefQueryName(origRefQueryName);
        }
        List<Object> rsvp4jAttachmentList = null;
        ArrayList<ByteArrayInputStream> attachmentList = null;
        IXQEQueryNode[] detailDataSets = new IXQEQueryNode[]{detailDataset};
        if (!environment.getRSVP4J()) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                OutputStreamWriter aWriter = new OutputStreamWriter((OutputStream)baos, "UTF-8");
                aWriter.write("Content-Type: text/xml; charset=utf-8\r\n\r\n");
                XQENodeSerializer.generateExecuteResponse(aWriter, detailDataSets, environment, XQENodeSerializer.AppendPlanIDs.DO_NOT_APPEND, queryFeedback, null);
                ((Writer)aWriter).close();
                byte[] attachmentBytes = baos.toByteArray();
                resultStream = new ByteArrayInputStream(attachmentBytes);
            }
            catch (IOException ex) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
            }
            attachmentList = new ArrayList<ByteArrayInputStream>(1);
            attachmentList.add(resultStream);
        } else {
            rsvp4jAttachmentList = RSVP4JHelper.generateExecuteResponse(detailDataSets);
        }
        long time = System.currentTimeMillis() - startTime;
        MetricsService.collectMetricInfo(environment, "isV5QueryExecuted", "true", time);
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        if (environment.getRSVP4J()) {
            return new RSVP4JResponseAdapter(responseEnvelope, rsvp4jAttachmentList, null);
        }
        return new SimpleResponseAdapter(responseEnvelope, attachmentList);
    }

    public static RSAPIDataset getDetailDataset(RequestEnvironment environment, Element detailQuery, String datasetId) {
        RSAPIDataset detailDataset = QueryEngine.getInstance().getDatasetByID(datasetId);
        if (null == detailDataset) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_MissingMasterDataset);
        }
        String detailQRDName = detailQuery.attributeValue("qrdName");
        if (!detailDataset.getName().equals(detailQRDName)) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_DetailMasterDatasetNameMismatch);
        }
        PlannedV5QuerySet querySet = (PlannedV5QuerySet)detailDataset.getParent();
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(environment);
        planEnv.setMetdataConnection(querySet.getMetadataConnection());
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)environment.getExecutionEnvironment();
        MultiRequestContext multiRequestContext = executionEnvironment.getMultiRequestContextNoThrow();
        if (null == multiRequestContext) {
            String requestID = environment.getRequestID();
            if (null == requestID) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_RequestIdMissing);
            }
            QueryEngine.getInstance().setCachedMultiRequestContext(environment);
        }
        Element parametersElem = ExecuteDetailQueryRequestAdapter.updateParametersNode(detailQuery);
        Parameters parameters = environment.getRequestParameters();
        parameters.prepare(parametersElem, planEnv);
        environment.setRequestParameters(parameters);
        detailDataset.adjustDataItemTypes(executionEnvironment);
        String queryName = detailQuery.attributeValue("queryName");
        if (multiRequestContext.queryRequiresReplan(queryName)) {
            environment.setReplanQuery(detailQRDName);
            environment.getMasterDetailProvider().reset();
            Map<String, RSAPIDataset> name2Dataset = ExecuteDetailQueryRequestAdapter.getName2DatasetMap(querySet);
            Document requestDocument = ExecuteDetailQueryRequestAdapter.getRequestDocument(queryName, environment);
            PlannedV5QuerySet planTree = QueryEngine.getInstance().prepareRequest(requestDocument, environment, false);
            ExecuteDetailQueryRequestAdapter.replaceDatasetsInCache(name2Dataset, planTree);
            detailDataset = QueryEngine.getInstance().getDatasetByID(datasetId);
        }
        return detailDataset;
    }

    @Override
    public String getOperationName() {
        return "executeDetailQuery";
    }

    public static void collectParameterNames(Element detailQuery, List<String> parameterNamesList, List<String> refParameterNamesList) {
        Element linksElem = detailQuery.element("links");
        List links = linksElem.elements();
        for (int i = 0; i < links.size(); ++i) {
            Element link = (Element)links.get(i);
            parameterNamesList.add(link.attributeValue("parameterName"));
            refParameterNamesList.add(link.attributeValue("refParameterName"));
        }
    }

    private static Element updateParametersNode(Element detailQuery) {
        ArrayList<String> parameterNamesList = new ArrayList<String>();
        ArrayList<String> refParameterNamesList = new ArrayList<String>();
        ExecuteDetailQueryRequestAdapter.collectParameterNames(detailQuery, parameterNamesList, refParameterNamesList);
        return ExecuteDetailQueryRequestAdapter.updateParametersNode(parameterNamesList, refParameterNamesList, detailQuery);
    }

    public static Element updateParametersNode(List<String> parameterNamesList, List<String> refParameterNamesList, Element detailQuery) {
        Element parametersElem = detailQuery.element("parameters");
        List parametersList = parametersElem.elements();
        block0: for (int i = 0; i < parametersList.size(); ++i) {
            Element parameterElem = (Element)parametersList.get(i);
            Element nameElem = parameterElem.element("name");
            for (int iName = 0; iName < parameterNamesList.size(); ++iName) {
                String paramName = parameterNamesList.get(iName);
                String refParamName = refParameterNamesList.get(iName);
                if (paramName == null || !nameElem.getText().equals(refParamName)) continue;
                nameElem.setText(paramName);
                refParameterNamesList.set(iName, paramName);
                continue block0;
            }
        }
        return parametersElem;
    }

    private static Document getRequestDocument(String queryName, RequestEnvironment reqEnv) {
        MultiRequestContext multiRequestContext = ((ExecutionEnvironment)reqEnv.getExecutionEnvironment()).getMultiRequestContext();
        return multiRequestContext.getDetailQueryRequestDocument(queryName);
    }

    private static Map<String, RSAPIDataset> getName2DatasetMap(PlannedV5QuerySet querySet) {
        RSAPIDataset rsapiDataset = null;
        HashMap<String, RSAPIDataset> name2Dataset = new HashMap<String, RSAPIDataset>();
        IXQEQueryNode[] rsapiDatasets = querySet.getChildrenOfType(401005);
        for (int i = 0; i < rsapiDatasets.length; ++i) {
            rsapiDataset = (RSAPIDataset)rsapiDatasets[i];
            name2Dataset.put(rsapiDataset.getName(), rsapiDataset);
        }
        return name2Dataset;
    }

    private static void replaceDatasetsInCache(Map<String, RSAPIDataset> name2Dataset, PlannedV5QuerySet planTree) {
        RSAPIDataset rsapiDataset = null;
        IXQEQueryNode[] rsapiDatasets = planTree.getChildrenOfType(401005);
        IPlanningEnvironment planTreeEnv = planTree.getPlanningEnvironment();
        for (int i = 0; i < rsapiDatasets.length; ++i) {
            rsapiDataset = (RSAPIDataset)rsapiDatasets[i];
            RSAPIDataset oldRsapiDataset = name2Dataset.get(rsapiDataset.getName());
            if (null == oldRsapiDataset) continue;
            IPlanningEnvironment newDatasetEnv = rsapiDataset.getPlanningEnvironment();
            IPlanningEnvironment newDatasetPlanTreeEnv = ((PlannedV5QuerySet)rsapiDataset.getParent()).getPlanningEnvironment();
            IPlanningEnvironment oldDatasetEnv = oldRsapiDataset.getPlanningEnvironment();
            IPlanningEnvironment oldDatasetPlanTreeEnv = ((PlannedV5QuerySet)oldRsapiDataset.getParent()).getPlanningEnvironment();
            planTreeEnv.setPlanningActive(null);
            newDatasetEnv.setPlanningActive(null);
            newDatasetPlanTreeEnv.setPlanningActive(null);
            oldDatasetEnv.setPlanningActive(null);
            oldDatasetPlanTreeEnv.setPlanningActive(null);
            RSAPIDataset.transferDataItemTypes(oldRsapiDataset, rsapiDataset);
            oldRsapiDataset.exchange(rsapiDataset);
            QueryEngine.getInstance().replaceDataset(oldRsapiDataset, rsapiDataset);
            planTreeEnv.setPlanningInactive();
            newDatasetEnv.setPlanningInactive();
            newDatasetPlanTreeEnv.setPlanningInactive();
            oldDatasetEnv.setPlanningInactive();
            oldDatasetPlanTreeEnv.setPlanningInactive();
        }
    }
}

