/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEIDGenerator;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.RequestMetrics;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.IteratorProfilingManager;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.query.executor.QueryExecutor;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.TraceLogManager;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.StringSubstitutionEngine;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqebifw.bibushandler.RSVP4JHelper;
import com.cognos.xqebifw.bibushandler.RSVP4JResponseAdapter;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import com.cognos.xqebifw.bibushandler.XQEBinaryNodeSerializer;
import com.cognos.xqebifw.bibushandler.XQENodeSerializer;
import com.cognos.xqebifw.bibushandler.binaryprotocol.VarLenByteBufferOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ExecuteRequestAdapter
extends RequestAdapter {
    private static final String REFPARAMETERS_OPEN_TAG = "<refParameters";
    private static final String PARAMETER_TAG = "<parameter name=\"";
    private static final String QUOTE = "\"";
    private static final String CLOSE_TAG = "/>";
    private static final String PARAMETER_CLOSE_TAG = "</parameter>";
    private static final String CLOSE_ANGLE_BACKET = ">";
    private static final String REFPARAMETERS_CLOSE_TAG = "</refParameters>";
    private static final String UTF_8 = "utf-8";
    private static final byte[] XML_CONTENT_TYPE_HEADER_BYTES = "Content-Type: text/xml; charset=utf-8\r\n\r\n".getBytes();

    @Override
    public ResponseAdapter executeRequest(RequestEnvironment reqEnv) {
        return this.executeRequest(reqEnv, true);
    }

    public boolean isGenerateDatasetScenario(IXQEQueryNode[] datasets) {
        return null != datasets && datasets.length == 1 && datasets[0].getGovernors().getDatasetMode() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseAdapter executeRequest(RequestEnvironment reqEnv, boolean bAddContentType) {
        Set<String> executionParameters;
        List<Object> rsvp4jAttachmentList;
        List<InputStream> attachmentList;
        block44: {
            long startTime = System.currentTimeMillis();
            XQELogger pLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Timing", LogLevel.INFO);
            if (pLogger.isOn()) {
                pLogger.log(OperationEnum.START, "Start of data query request.");
            }
            BIBusEnvelope requestEnvelope = reqEnv.getRequestEnvelope();
            Element v5RootElement = requestEnvelope.getBody().element("execute");
            v5RootElement.detach();
            Document requestDocument = DocumentHelper.createDocument((Element)v5RootElement);
            ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
            ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
            MultiRequestContext multiRequestContext = QueryEngine.getInstance().configureMultiRequestContext(reqEnv, requestDocument);
            multiRequestContext.incrementRefCount();
            attachmentList = null;
            rsvp4jAttachmentList = null;
            executionParameters = null;
            String reportVersion = "";
            long numBytesReturned = 0L;
            boolean exceptionThrown = false;
            IXQEQueryNode[] datasets = null;
            try {
                try {
                    block42: {
                        ROLAPContext.startFirstPage();
                        XQETrace trace = new XQETrace();
                        QueryEngineLoggingUtils.addExecutionTraceLevels(trace, reqEnv);
                        trace.setNodeIDGenerator(new XQEIDGenerator());
                        executionEnvironment.setTrace(trace);
                        boolean success = false;
                        try {
                            MetricsService.collectMetricInfo(reqEnv, "requestType", "execute");
                            IteratorProfilingManager.getInstance().registerProfiler(trace);
                            Element queryFeedback = v5RootElement.element("queryFeedback");
                            String remoteIsLittleEndian = v5RootElement.attributeValue("littleEndian");
                            boolean endiannessMismatch = VarLenByteBufferOutputStream.endiannessMismatch(remoteIsLittleEndian);
                            datasets = QueryEngine.getInstance().executeRequest(requestDocument, reqEnv);
                            executionParameters = reqEnv.getBoundParameters();
                            if (!reqEnv.getRSVP4J()) {
                                ByteArrayInputStream headerStream;
                                ByteArrayInputStream resultStream;
                                block41: {
                                    resultStream = null;
                                    headerStream = null;
                                    success = true;
                                    boolean useBinaryProtocolForThisRequest = true;
                                    if (endiannessMismatch || queryFeedback != null && queryFeedback.elements().size() > 0) {
                                        useBinaryProtocolForThisRequest = false;
                                    }
                                    try {
                                        if (this.isGenerateDatasetScenario(datasets)) {
                                            boolean datasetExceptionThrown = false;
                                            RSAPIDataset dataset = (RSAPIDataset)datasets[0];
                                            try {
                                                reportVersion = QueryExecutor.getInstance().executeDatasetOperation(dataset, executionEnvironment);
                                            }
                                            catch (Exception datasetEx) {
                                                datasetExceptionThrown = true;
                                                throw datasetEx;
                                            }
                                            finally {
                                                dataset.releaseResultset(executionEnvironment);
                                                QueryEngine.getInstance().releaseMasterDataset(executionEnvironment, dataset.getUniqueID());
                                                if (datasetExceptionThrown) {
                                                    QueryEngine.getInstance().removeMasterDatasetAndMultiRequestContext(dataset.getUniqueID(), reqEnv);
                                                }
                                            }
                                        }
                                        if (bAddContentType) {
                                            numBytesReturned += (long)XML_CONTENT_TYPE_HEADER_BYTES.length;
                                            headerStream = new ByteArrayInputStream(XML_CONTENT_TYPE_HEADER_BYTES);
                                            this.binaryAttachment = multiRequestContext.fetchBooleanConfiguration("general.binaryMasterDataset", true);
                                        }
                                        if (!this.binaryAttachment) {
                                            useBinaryProtocolForThisRequest = false;
                                        }
                                        if (useBinaryProtocolForThisRequest) {
                                            try (VarLenByteBufferOutputStream outStream = new VarLenByteBufferOutputStream();){
                                                outStream.write(BIN_STREAM_TYPE);
                                                byte[] resultBytes = XQEBinaryNodeSerializer.generateBinaryExecuteResponse(outStream, datasets, reqEnv, XQENodeSerializer.AppendPlanIDs.APPEND, queryFeedback);
                                                resultStream = new ByteArrayInputStream(resultBytes);
                                                numBytesReturned += (long)resultBytes.length;
                                                XQEDebugLog.out.println("MasterDataset was created in binary format.");
                                                break block41;
                                            }
                                        }
                                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                        OutputStreamWriter aWriter = new OutputStreamWriter((OutputStream)baos, "UTF-8");
                                        if (bAddContentType) {
                                            baos.write(XML_STREAM_TYPE);
                                        }
                                        XQENodeSerializer.generateExecuteResponse(aWriter, datasets, reqEnv, XQENodeSerializer.AppendPlanIDs.APPEND, queryFeedback, reportVersion);
                                        ((Writer)aWriter).close();
                                        byte[] attachmentBytes = baos.toByteArray();
                                        numBytesReturned += (long)attachmentBytes.length;
                                        resultStream = new ByteArrayInputStream(attachmentBytes);
                                    }
                                    catch (IOException ex) {
                                        XQERuntimeException xqeRTE = new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
                                        this.failQueryReThrowAsXQERTE(reqEnv, v5RootElement, xqeRTE, "isV5QueryExecuted");
                                    }
                                }
                                if (resultStream == null) {
                                    attachmentList = Collections.emptyList();
                                    break block42;
                                } else {
                                    attachmentList = new ArrayList(1);
                                    if (headerStream != null) {
                                        SequenceInputStream sequenceStream = new SequenceInputStream(headerStream, resultStream);
                                        attachmentList.add(sequenceStream);
                                    } else {
                                        attachmentList.add(resultStream);
                                    }
                                    byte[] parameterBytes = ExecuteRequestAdapter.generateParameterBytes(bAddContentType, executionParameters, multiRequestContext, reqEnv);
                                    numBytesReturned += (long)parameterBytes.length;
                                    attachmentList.add(new ByteArrayInputStream(parameterBytes));
                                    numBytesReturned += this.addQueryPlans(bAddContentType, datasets, attachmentList);
                                }
                                break block42;
                            }
                            rsvp4jAttachmentList = RSVP4JHelper.generateExecuteResponse(datasets);
                        }
                        finally {
                            long time = System.currentTimeMillis() - startTime;
                            if (success) {
                                MetricsService.collectMetricInfo(reqEnv, "isV5QueryExecuted", "true", time);
                            } else {
                                MetricsService.collectMetricInfo(reqEnv, "isV5QueryExecuted", "failed", time);
                            }
                            String logDir = "queriesNotPlanned";
                            if (success) {
                                logDir = "queriesPlanned";
                            } else if (QueryEngine.getParameters(reqEnv).size() > 0) {
                                logDir = "queriesUnresolvedParameters";
                            }
                            String reportName = TraceLogManager.escapeName(reqEnv.getReportName());
                            this.logV5Request(v5RootElement, logDir, reportName);
                            RequestMetrics rm = reqEnv.getRequestMetrics();
                            rm.incrementNumberOfBytesReturned(numBytesReturned);
                            multiRequestContext.decrementRefCount();
                            executionEnvironmentContext.exit();
                            IteratorProfilingManager.getInstance().unregisterProfiler();
                        }
                    }
                    if (pLogger.isOn()) {
                        pLogger.log(OperationEnum.END, "End of data query request.");
                    }
                }
                catch (Exception e) {
                    exceptionThrown = true;
                    throw XQERuntimeException.wrap(e);
                }
            }
            catch (Throwable throwable) {
                try {
                    ROLAPContext.updateFirstPage(exceptionThrown, datasets);
                    throw throwable;
                }
                catch (Exception e) {
                    if (this.isGenerateDatasetScenario(datasets)) throw throwable;
                    throw e;
                }
            }
            try {
                ROLAPContext.updateFirstPage(exceptionThrown, datasets);
            }
            catch (Exception e) {
                if (this.isGenerateDatasetScenario(datasets)) break block44;
                throw e;
            }
        }
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        if (!reqEnv.getRSVP4J()) return new SimpleResponseAdapter(responseEnvelope, attachmentList);
        return new RSVP4JResponseAdapter(responseEnvelope, rsvp4jAttachmentList, executionParameters);
    }

    private long addQueryPlans(boolean addContentType, IXQEQueryNode[] datasets, List<InputStream> attachmentList) {
        long count = 0L;
        for (IXQEQueryNode queryNode : datasets) {
            RSAPIDataset dataset = (RSAPIDataset)queryNode;
            byte[] queryPlan = dataset.getQueryPlan();
            if (queryPlan == null) continue;
            InputStream queryPlanStream = new ByteArrayInputStream(queryPlan);
            count += (long)queryPlan.length;
            if (addContentType) {
                ByteArrayInputStream headerStream = new ByteArrayInputStream(XML_CONTENT_TYPE_HEADER_BYTES);
                queryPlanStream = new SequenceInputStream(headerStream, queryPlanStream);
                count += (long)XML_CONTENT_TYPE_HEADER_BYTES.length;
            }
            attachmentList.add(queryPlanStream);
        }
        return count;
    }

    static byte[] generateParameterBytes(boolean addContentType, Set<String> executionParameters, MultiRequestContext mrc, RequestEnvironment reqEnv) {
        boolean containsGlobalParameter = false;
        StringBuilder parameterElements = new StringBuilder();
        for (String executionParameter : executionParameters) {
            parameterElements.append(PARAMETER_TAG);
            parameterElements.append(StringSubstitutionEngine.escapeString(executionParameter));
            parameterElements.append(QUOTE);
            Parameter globalParam = mrc.getEffectiveGlobalParameter(executionParameter, reqEnv);
            if (globalParam != null) {
                containsGlobalParameter = true;
                parameterElements.append(" globalParameter=\"true\">");
                ParameterValues paramValues = globalParam.getParameterValueItems();
                parameterElements.append(paramValues.asDOMString("bus:value"));
                parameterElements.append(PARAMETER_CLOSE_TAG);
                continue;
            }
            parameterElements.append(CLOSE_TAG);
        }
        StringBuilder refParameters = new StringBuilder();
        if (addContentType) {
            refParameters.append("Content-Type: text/xml; charset=utf-8\r\n\r\n");
        }
        refParameters.append(REFPARAMETERS_OPEN_TAG);
        if (containsGlobalParameter) {
            refParameters.append(" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\"");
            refParameters.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
            refParameters.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
            refParameters.append(" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"");
        }
        refParameters.append(CLOSE_ANGLE_BACKET);
        refParameters.append((CharSequence)parameterElements);
        refParameters.append(REFPARAMETERS_CLOSE_TAG);
        byte[] parameterBytes = null;
        try {
            parameterBytes = refParameters.toString().getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return parameterBytes;
    }

    @Override
    public String getOperationName() {
        return "execute";
    }
}

