/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.ma.MAQueryNode;
import com.cognos.xqe.ast.ma.MARequest;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.ma.XMARequest;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.transformation.moser.MoserCommandUtil;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class GenerateFunctionList {
    private MetadataConnection metadataConnection;
    private String module;
    public static final String RESPONSE = "generateFunctionResponse";
    public static final String listOfFunctions = "listOfFunctions";
    public static final String RESULT = "generateFunctionResult";

    public static void generateMAQuery(PlanningEnvironment environment, Element functionSpec) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
        GenerateFunctionList generator = new GenerateFunctionList();
        generator.setCommandParameters(execEnv, functionSpec);
        generator.generateMARequest(environment, functionSpec);
    }

    public MARequest generateMARequest(PlanningEnvironment environment, Element functionSpec) {
        List children = functionSpec.elements();
        int size = children.size();
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        IXQEQueryNode node = null;
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            Pair keyValue = MoserCommandUtil.getNameAndValueMap(child);
            if (keyValue == null || !"requestString".equals(keyValue.getFirst())) continue;
            String newRequest = (String)keyValue.getSecond();
            ByteArrayInputStream stream = new ByteArrayInputStream(newRequest.getBytes());
            try {
                Document requestDocument = this.readInputRequest(stream);
                Element rootElement = requestDocument.getRootElement();
                if (execEnv.getConnectionElement() == null) {
                    execEnv.setConnectionElement(rootElement.element("connection"));
                }
                Element nodeName = rootElement.element("Metadata");
                XQENodeFactory uberNodeFactory = environment.getNodeFactory();
                node = uberNodeFactory.createNode(1101013);
                ((MAQueryNode)node).capture(environment, nodeName);
                environment.setRoot(node);
                ((MAQueryNode)node).setMetadataConnection(this.metadataConnection);
                continue;
            }
            catch (Exception e) {
                XQEDebugLog.err.printStackTrace(e);
            }
        }
        return (MARequest)node;
    }

    protected void setCommandParameters(ExecutionEnvironment environment, Element functionSpec) {
        List children = functionSpec.elements();
        int size = children.size();
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            Pair keyValue = MoserCommandUtil.getNameAndValueMap(child);
            if (keyValue == null || !"module".equals(keyValue.getFirst())) continue;
            this.module = (String)keyValue.getSecond();
        }
        this.metadataConnection = MetadataService.getInstance().getConnection("MOSER", this.module, environment, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document readInputRequest(InputStream inStream) throws Exception {
        SAXReader xmlReader = null;
        xmlReader = XQESAXReaderPool.getInstance().borrowReader();
        try {
            Document document = xmlReader.read(inStream);
            return document;
        }
        finally {
            if (xmlReader != null) {
                XQESAXReaderPool.getInstance().returnReader(xmlReader);
            }
        }
    }

    public static Element generateResponse(XMARequest xMARequest, ExecutionEnvironment execEnv) {
        XDataContext dataContext = execEnv.pushDataContext();
        Element response = DocumentHelper.createElement((String)RESPONSE);
        Element result = DocumentHelper.createElement((String)RESULT);
        response.add(result);
        Element itemEle = DocumentHelper.createElement((String)"item");
        result.add(itemEle);
        JSONObject jObj = GenerateFunctionList.generateResponseForGetFunctionListRequest((XmlValue)xMARequest.execute(dataContext));
        itemEle.setText(jObj.toString());
        return response;
    }

    private static JSONObject generateResponseForGetFunctionListRequest(XmlValue responseTemp) {
        JSONObject response = new JSONObject();
        if (!responseTemp.isNull()) {
            response.put((Object)listOfFunctions, (Object)responseTemp.toString());
        }
        return response;
    }
}

