/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GetDetailQueriesRequestAdapter
extends RequestAdapter {
    private static final String GET_DETAIL_QUERIES_ELEMENT_NAME = "getDetailQueries";
    private static final String MASTER_DATASET = "masterDataset";
    private static final String MASTER_DATASET_ID = "masterDatasetId";

    @Override
    public ResponseAdapter executeRequest(RequestEnvironment environment) throws XQEException {
        MetricsService.collectMetricInfo(environment, "requestType", GET_DETAIL_QUERIES_ELEMENT_NAME);
        BIBusEnvelope requestEnvelope = environment.getRequestEnvelope();
        Element v5RootElement = requestEnvelope.getBody().element(GET_DETAIL_QUERIES_ELEMENT_NAME);
        v5RootElement.detach();
        Element masterDatasetElement = v5RootElement.element(MASTER_DATASET);
        if (null == masterDatasetElement) {
            throw new XQEException(XQEMessageKeys.EXE_MissingMasterDatasetId);
        }
        String datasetId = masterDatasetElement.attributeValue(MASTER_DATASET_ID);
        if (null == datasetId) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_MissingMasterDatasetId);
        }
        RSAPIDataset masterDataset = QueryEngine.getInstance().getDatasetByID(datasetId);
        if (null == masterDataset) {
            throw new XQEException(XQEMessageKeys.EXE_MissingMasterDataset);
        }
        ZipiBridge.setZipiContextAndObjPath(masterDataset.getName());
        PlannedV5QuerySet querySet = (PlannedV5QuerySet)masterDataset.getParent();
        MasterDetailProvider mdProvider = querySet.getMasterDetailProvider();
        List<MasterDetailLink> mdLinks = mdProvider.getMasterDetailLinks(masterDataset.getName());
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        if (mdLinks.isEmpty()) {
            return new SimpleResponseAdapter(responseEnvelope, Collections.EMPTY_LIST);
        }
        Element bodyElement = responseEnvelope.getBody();
        bodyElement.add(GetDetailQueriesRequestAdapter.generateDetailQueriesResponse(querySet, mdLinks));
        return new SimpleResponseAdapter(responseEnvelope, new ArrayList());
    }

    public static Element generateDetailQueriesResponse(PlannedV5QuerySet querySet, List<MasterDetailLink> mdLinks) {
        Map<String, List<MasterDetailLink>> detailQRDs = GetDetailQueriesRequestAdapter.arrangeMDLinksByDetailQueries(mdLinks);
        Parameters parameters = querySet.getRequestParameters();
        Element detailQueriesEle = DocumentHelper.createElement((String)"detailQueries");
        for (Map.Entry<String, List<MasterDetailLink>> entry : detailQRDs.entrySet()) {
            List<MasterDetailLink> links = entry.getValue();
            if (links.size() == 0) continue;
            Element detailQueryEle = detailQueriesEle.addElement("detailQuery");
            String datasetName = entry.getKey();
            RSAPIDataset detailRSAPIDataset = GetDetailQueriesRequestAdapter.findDatasetByName(querySet, datasetName);
            Element detailMasterDatasetElement = detailQueryEle.addElement(MASTER_DATASET);
            detailMasterDatasetElement.addAttribute(MASTER_DATASET_ID, detailRSAPIDataset.getUniqueID());
            Element parametersElem = Parameters.createParametersElement();
            detailQueryEle.add(parametersElem);
            GetDetailQueriesRequestAdapter.addMDLinkAttributes(detailQueryEle, links.get(0));
            Element linksElem = detailQueryEle.addElement("links");
            for (MasterDetailLink mdLink : links) {
                Element linkElem = linksElem.addElement("link");
                linkElem.addAttribute("linkName", mdLink.getName());
                String parameterName = mdLink.getParameterName();
                if (!mdLink.isParameterLink()) {
                    parameterName = mdLink.getName();
                }
                parameterName = parameterName.trim();
                linkElem.addAttribute("parameterName", parameterName);
                String refDataItem = mdLink.getMasterRefDataItem();
                String refParameterName = UniqueNameGenerator.createUniqueName(mdLink.getMasterQrdName(), refDataItem);
                linkElem.addAttribute("refParameterName", refParameterName);
                Parameter parameter = null;
                String queryName = detailRSAPIDataset.getRefQueryName();
                if (parameters != null) {
                    parameter = parameters.getParameter(parameterName, queryName);
                }
                if (parameter == null) {
                    parameter = parameters.getParameter(parameterName);
                }
                if (parameter == null || !parameter.isMasterDetailLinkParameter()) {
                    parameter = new Parameter(parameterName, queryName);
                    parameter.setMasterDetailLinkParameter(true);
                }
                Element paramItem = parameter.createParameterElement(refParameterName);
                parametersElem.add(paramItem);
            }
            Parameters.setParametersArraySize(parametersElem, links.size());
        }
        return detailQueriesEle;
    }

    @Override
    public String getOperationName() {
        return GET_DETAIL_QUERIES_ELEMENT_NAME;
    }

    public static Map<String, List<MasterDetailLink>> arrangeMDLinksByDetailQueries(List<MasterDetailLink> mdLinks) {
        TreeMap<String, List<MasterDetailLink>> detailQRD2MDLink = new TreeMap<String, List<MasterDetailLink>>();
        for (int i = 0; i < mdLinks.size(); ++i) {
            MasterDetailLink mdLink = mdLinks.get(i);
            String detailQRDName = mdLink.getDetailQrdName();
            ArrayList<MasterDetailLink> links = (ArrayList<MasterDetailLink>)detailQRD2MDLink.get(detailQRDName);
            if (null == links) {
                links = new ArrayList<MasterDetailLink>();
                detailQRD2MDLink.put(detailQRDName, links);
            }
            links.add(mdLink);
        }
        return detailQRD2MDLink;
    }

    private static void addMDLinkAttributes(Element detailQueryEle, MasterDetailLink mdLink) {
        detailQueryEle.addAttribute("queryName", mdLink.getDetailQueryName());
        if (mdLink.getDetailQueryNameOrig() != null) {
            detailQueryEle.addAttribute("queryNameOrig", mdLink.getDetailQueryNameOrig());
        }
        detailQueryEle.addAttribute("qrdName", mdLink.getDetailQrdName());
        detailQueryEle.addAttribute("masterQueryName", mdLink.getMasterQueryName());
        detailQueryEle.addAttribute("masterQrdName", mdLink.getMasterQrdName());
    }

    public static RSAPIDataset findDatasetByName(PlannedV5QuerySet querySet, String qrdName) {
        RSAPIDataset dataset = null;
        IXQEQueryNode[] datasets = querySet.getChildren();
        for (int i = 0; i < datasets.length; ++i) {
            RSAPIDataset localDataSet = (RSAPIDataset)datasets[i];
            if (!localDataSet.getName().equals(qrdName)) continue;
            dataset = localDataSet;
            break;
        }
        if (null == dataset) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_DetailMasterDatasetNameMismatch);
        }
        return dataset;
    }
}

