/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.parameters.RequestParameters;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import com.cognos.xqemoser.MoserParameterUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GetParametersRequestAdapter
extends RequestAdapter {
    private static final String RESPONSE = "response";
    private static final String PARAMETERS = "parameters";
    private static final String QUERY_RESULT_DEFINITIONS = "queryResultDefinitions";
    private static final String MASTER_DETAIL_LINKS = "masterDetailLinks";
    private static final String REFERENCED_QUERY = "refQuery";
    private static final String PARAMETER_INFO = "parameterInfo";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAdapter executeRequest(RequestEnvironment reqEnv) throws XQEException {
        long startTime = System.currentTimeMillis();
        MetricsService.collectMetricInfo(reqEnv, "requestType", "getParameters");
        BIBusEnvelope requestEnvelope = reqEnv.getRequestEnvelope();
        Element v5RootElement = requestEnvelope.getBody().element("getParameters");
        v5RootElement.detach();
        Document requestDocument = DocumentHelper.createDocument((Element)v5RootElement);
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
        MultiRequestContext multiRequestContext = QueryEngine.getInstance().configureMultiRequestContext(reqEnv, requestDocument);
        multiRequestContext.incrementRefCount();
        RequestParameters requestParameters = null;
        RequestParameters oldRequestParameters = multiRequestContext.getRequestParameters();
        if (oldRequestParameters.hasParameters() && !oldRequestParameters.getParameters().hasUnresolvedParameters() && oldRequestParameters.getParameters().hasMasterDetailParameter()) {
            requestParameters = new RequestParameters(oldRequestParameters);
        }
        boolean bReturnUsedParameterValues = false;
        Element queryFeedback = v5RootElement.element("queryFeedback");
        if (queryFeedback != null) {
            Iterator it = queryFeedback.elementIterator("property");
            while (it.hasNext()) {
                Element propertyElement = (Element)it.next();
                String property = propertyElement.attributeValue("name");
                if (!"usedParameterValue".equals(property)) continue;
                bReturnUsedParameterValues = true;
                break;
            }
        }
        try {
            Element updateSetElement = requestDocument.getRootElement().element("updateSet");
            if (updateSetElement != null) {
                this.getEngine().prepareUpdateQueryRequest(requestDocument, reqEnv);
                responseEnvelope.getBody().addElement(RESPONSE);
            } else {
                List<Element> qrds = this.getQRDs(v5RootElement);
                if (qrds != null && qrds.size() > 1 && !this.doesMasterDetailLinksExist(qrds)) {
                    List<Map<String, Element>> groupsOfQRDs = this.getGroupsOfQRDsNotReferencingSameQuery(qrds);
                    List<Document> requestDocList = this.generateMultipleGetParamsCommands(v5RootElement, groupsOfQRDs);
                    ArrayList<Element> upResponses = new ArrayList<Element>();
                    for (Document reqDoc : requestDocList) {
                        try {
                            this.getEngine().prepareRequest(reqDoc, reqEnv, false);
                        }
                        catch (UnresolvedParameterException upe) {
                            Element upResponse = upe.getUnresolvedParametersResponse(true);
                            upResponses.add(upResponse);
                        }
                    }
                    this.processUPResponses(responseEnvelope, upResponses, bReturnUsedParameterValues, reqEnv);
                } else {
                    this.getEngine().prepareRequest(requestDocument, reqEnv, false);
                    responseEnvelope.getBody().addElement(RESPONSE);
                }
            }
        }
        catch (UnresolvedParameterException up) {
            Element responseElement = up.getUnresolvedParametersResponse(true);
            if (bReturnUsedParameterValues) {
                MoserParameterUtil.appendUsedParameterValueToResponse(responseElement, reqEnv);
            }
            responseEnvelope.getBody().add(responseElement);
        }
        catch (DataSourceException dse) {
            this.failQuery(reqEnv, v5RootElement, "isV5QueryExecuted", dse);
            throw dse;
        }
        catch (Throwable t) {
            this.failQueryReThrowAsXQERTE(reqEnv, v5RootElement, t, "isV5QueryExecuted");
        }
        finally {
            if (requestParameters != null) {
                multiRequestContext.setRequestParameters(requestParameters);
            }
            multiRequestContext.decrementRefCount();
            executionEnvironmentContext.exit();
            ZipiBridge.setZipiContextAndObjPath("getParameters");
        }
        long time = System.currentTimeMillis() - startTime;
        MetricsService.collectMetricInfo(reqEnv, "isV5QueryExecuted", "true", time);
        List attachmentList = Collections.emptyList();
        return new SimpleResponseAdapter(responseEnvelope, attachmentList);
    }

    @Override
    public String getOperationName() {
        return "getParameters";
    }

    @Override
    public void setEngine(QueryEngine newEngine) {
        super.setEngine(newEngine);
    }

    private Map<String, Element> collectRequestParameterNodes(Element v5RootElement) {
        Element requestParametersElem = v5RootElement.element(PARAMETERS);
        HashMap<String, Element> requestParametersMap = new HashMap<String, Element>();
        if (null == requestParametersElem) {
            return requestParametersMap;
        }
        List requestParametersElements = requestParametersElem.elements();
        for (Element itemElem : requestParametersElements) {
            Element nameElem = itemElem.element("name");
            String name = nameElem.getText();
            requestParametersMap.put(name, itemElem);
        }
        return requestParametersMap;
    }

    private void appendParameterValueItems(Map<String, Element> requestParameters, RequestEnvironment environment, Element responseElem) {
        if (0 == requestParameters.size()) {
            return;
        }
        Parameters parametersMap = environment.getRequestParameters();
        Element parametersElem = responseElem.element(PARAMETERS);
        if (null == parametersElem) {
            parametersElem = Parameters.createParametersElement();
            responseElem.add(parametersElem);
        }
        for (Map.Entry parameterEntry : parametersMap.entrySet()) {
            Element itemElem;
            String parameterName = ((String)parameterEntry.getKey()).trim();
            Parameter parameter = (Parameter)parameterEntry.getValue();
            if (!parameter.isResolved() || null == (itemElem = requestParameters.get(parameterName))) continue;
            itemElem.detach();
            parametersElem.add(itemElem);
        }
        Parameters.setParametersArraySize(parametersElem, parametersElem.elements().size());
    }

    private List<Element> getQRDs(Element rootElem) {
        List childrenUnderRoot = rootElem.elements();
        for (int i = 0; i < childrenUnderRoot.size(); ++i) {
            Element childUnderRoot = (Element)childrenUnderRoot.get(i);
            if (!childUnderRoot.getName().equals("querySet")) continue;
            List childrenUnderQuerySet = childUnderRoot.elements();
            for (int j = 0; j < childrenUnderQuerySet.size(); ++j) {
                Element childUnderQuerySet = (Element)childrenUnderQuerySet.get(j);
                if (!childUnderQuerySet.getName().equals(QUERY_RESULT_DEFINITIONS)) continue;
                List childrenUnderQRDS = childUnderQuerySet.elements();
                return childrenUnderQRDS;
            }
        }
        return null;
    }

    private boolean doesMasterDetailLinksExist(List<Element> qrds) {
        boolean bMasterDetailLinksFound = false;
        for (Element qrd : qrds) {
            if (qrd.element(MASTER_DETAIL_LINKS) == null) continue;
            bMasterDetailLinksFound = true;
            break;
        }
        return bMasterDetailLinksFound;
    }

    private List<Document> generateMultipleGetParamsCommands(Element rootElem, List<Map<String, Element>> groupsOfQRDs) {
        ArrayList<Document> docList = new ArrayList<Document>(groupsOfQRDs.size());
        boolean bPlanKeyExists = false;
        for (Map<String, Element> aGroup : groupsOfQRDs) {
            Element clonedRootElem = (Element)rootElem.clone();
            Element planKeyElem = clonedRootElem.element("V5CommandPlanKey");
            if (planKeyElem != null) {
                planKeyElem.detach();
                bPlanKeyExists = true;
            }
            List childrenUnderRoot = clonedRootElem.elements();
            for (int i = 0; i < childrenUnderRoot.size(); ++i) {
                Element childUnderRoot = (Element)childrenUnderRoot.get(i);
                if (!childUnderRoot.getName().equals("querySet")) continue;
                List childrenUnderQuerySet = childUnderRoot.elements();
                for (int j = 0; j < childrenUnderQuerySet.size(); ++j) {
                    Element childUnderQuerySet = (Element)childrenUnderQuerySet.get(j);
                    if (!childUnderQuerySet.getName().equals(QUERY_RESULT_DEFINITIONS)) continue;
                    List childrenUnderQRDS = childUnderQuerySet.elements();
                    for (int k = 0; k < childrenUnderQRDS.size(); ++k) {
                        Element childQRD = (Element)childrenUnderQRDS.get(k);
                        String qrdName = childQRD.attributeValue("name");
                        boolean qrdFoundInCurrentGroup = false;
                        for (Element qrdInGroup : aGroup.values()) {
                            if (!qrdInGroup.attributeValue("name").equals(qrdName)) continue;
                            qrdFoundInCurrentGroup = true;
                            break;
                        }
                        if (qrdFoundInCurrentGroup) continue;
                        childQRD.detach();
                    }
                    break;
                }
                if (!bPlanKeyExists) break;
                String planKey = this.getEngine().getV5CommandPlanKey(clonedRootElem);
                Element keyElement = DocumentHelper.createElement((String)"V5CommandPlanKey");
                keyElement.addAttribute("value", planKey);
                clonedRootElem.add(keyElement);
                break;
            }
            Document newRequestDoc = DocumentHelper.createDocument((Element)clonedRootElem);
            docList.add(newRequestDoc);
        }
        return docList;
    }

    private void processUPResponses(BIBusEnvelope responseEnvelope, List<Element> upResponses, boolean bReturnUsedValues, RequestEnvironment reqEnv) {
        int numOfRepsonses = upResponses.size();
        switch (numOfRepsonses) {
            case 0: {
                responseEnvelope.getBody().addElement(RESPONSE);
                break;
            }
            case 1: {
                if (bReturnUsedValues) {
                    MoserParameterUtil.appendUsedParameterValueToResponse(upResponses.get(0), reqEnv);
                }
                responseEnvelope.getBody().add(upResponses.get(0));
                break;
            }
            default: {
                TreeMap<String, Element> nameToParamElem = new TreeMap<String, Element>();
                TreeMap<String, Element> nameToParamInfo = new TreeMap<String, Element>();
                this.consolidateUnresolvedParameters(upResponses, nameToParamElem, nameToParamInfo);
                Element responseElem = DocumentHelper.createElement((String)RESPONSE);
                Element parametersElem = Parameters.createParametersElement();
                String sizeValue = "bus:baseParameter[" + nameToParamElem.size() + "]";
                parametersElem.addAttribute("SOAP-ENC:arrayType", sizeValue);
                for (Element item : nameToParamElem.values()) {
                    parametersElem.add(item);
                }
                responseElem.add(parametersElem);
                if (nameToParamInfo.size() > 0) {
                    Element paramInfoElem = DocumentHelper.createElement((String)PARAMETER_INFO);
                    for (Element infoIitem : nameToParamInfo.values()) {
                        paramInfoElem.add(infoIitem);
                    }
                    responseElem.add(paramInfoElem);
                }
                if (bReturnUsedValues) {
                    MoserParameterUtil.appendUsedParameterValueToResponse(responseElem, reqEnv);
                }
                responseEnvelope.getBody().add(responseElem);
            }
        }
    }

    private void consolidateUnresolvedParameters(List<Element> upResponses, Map<String, Element> nameToParamItem, Map<String, Element> nameToParamInfo) {
        for (Element resp : upResponses) {
            Element paramsElem = resp.element(PARAMETERS);
            if (paramsElem == null) continue;
            List paramItems = paramsElem.elements();
            for (Element parmItem : paramItems) {
                Element nameElem = parmItem.element("name");
                String parmName = nameElem.getText();
                if (nameToParamItem.containsKey(parmName)) continue;
                parmItem.detach();
                nameToParamItem.put(parmName, parmItem);
            }
        }
        for (Element resp : upResponses) {
            Element paramInfoElem = resp.element(PARAMETER_INFO);
            if (paramInfoElem == null) continue;
            List infoItems = paramInfoElem.elements();
            for (Element infoItem : infoItems) {
                String parmName = infoItem.attributeValue("name");
                if (nameToParamInfo.containsKey(parmName)) continue;
                infoItem.detach();
                nameToParamInfo.put(parmName, infoItem);
            }
        }
    }

    private List<Map<String, Element>> getGroupsOfQRDsNotReferencingSameQuery(List<Element> qrds) {
        ArrayList<Map<String, Element>> groupsOfQRDs = new ArrayList<Map<String, Element>>();
        for (Element qrd : qrds) {
            String refQueryName = qrd.attributeValue(REFERENCED_QUERY);
            boolean qrdAddedToExistingGroup = false;
            for (Map map : groupsOfQRDs) {
                if (map.containsKey(refQueryName)) continue;
                map.put(refQueryName, qrd);
                qrdAddedToExistingGroup = true;
                break;
            }
            if (qrdAddedToExistingGroup) continue;
            HashMap<String, Element> newGroup = new HashMap<String, Element>();
            newGroup.put(refQueryName, qrd);
            groupsOfQRDs.add(newGroup);
        }
        return groupsOfQRDs;
    }
}

